/*
 * Decompiled with CFR 0.152.
 */
package neoforge.net.creep3rcrafter.mysticpotions.mixin;

import neoforge.net.creep3rcrafter.mysticpotions.register.ModEffects;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    public abstract boolean removeAllEffects();

    @Shadow
    public abstract boolean addEffect(MobEffectInstance var1);

    @Shadow
    public void setHealth(float v) {
    }

    @Shadow
    public abstract boolean hasEffect(MobEffect var1);

    @Shadow
    public abstract boolean removeEffect(MobEffect var1);

    @Shadow
    @Nullable
    public abstract MobEffectInstance getEffect(MobEffect var1);

    @Inject(method={"checkTotemDeathProtection(Lnet/minecraft/world/damagesource/DamageSource;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void inject1(DamageSource damageSource, CallbackInfoReturnable<Boolean> callback) {
        if (this.hasEffect((MobEffect)ModEffects.UNDYING.get())) {
            this.setHealth(1.0f);
            this.removeEffect((MobEffect)ModEffects.UNDYING.get());
            this.removeAllEffects();
            this.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 900, 1));
            this.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 100, 1));
            this.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 800, 0));
            this.level().broadcastEntityEvent((Entity)this, (byte)35);
            callback.setReturnValue((Object)true);
        }
    }

    @Inject(method={"isAffectedByPotions()Z"}, at={@At(value="RETURN")}, cancellable=true)
    public void inject2(CallbackInfoReturnable<Boolean> cir) {
        if (this.hasEffect((MobEffect)ModEffects.NULLIFIER.get())) {
            cir.setReturnValue((Object)false);
        }
    }

    @ModifyVariable(method={"travel(Lnet/minecraft/world/phys/Vec3;)V"}, at=@At(value="LOAD"), name={"f2"}, ordinal=0, index=8)
    public float inject5(float value) {
        if (this.hasEffect((MobEffect)ModEffects.SPLIPPERY.get()) && this.onGround()) {
            int amplifier = this.getEffect((MobEffect)ModEffects.SPLIPPERY.get()).getAmplifier();
            return ((float)amplifier / -300.0f + 1.0f) * 0.98f;
        }
        return value;
    }

    @ModifyVariable(method={"travel(Lnet/minecraft/world/phys/Vec3;)V"}, at=@At(value="LOAD"), name={"d0"}, ordinal=0, index=2)
    public double inject6(double value) {
        if (this.hasEffect((MobEffect)ModEffects.GRAVITATION.get())) {
            if (this.isCrouching()) {
                return 0.08;
            }
            return -0.04;
        }
        return value;
    }
}

