/*
 * Decompiled with CFR 0.152.
 */
package neoforge.net.creep3rcrafter.mysticpotions.register;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import neoforge.net.creep3rcrafter.mysticpotions.utils.Utils;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.ZombieHorse;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ModEffects {
    public static final DeferredRegister<MobEffect> EFFECTS = DeferredRegister.create((String)"mysticpotions", (ResourceKey)Registries.MOB_EFFECT);
    public static final RegistrySupplier<MobEffect> UNDYING = EFFECTS.register("undying", () -> new MobEffect(MobEffectCategory.BENEFICIAL, 16766527){

        public void applyEffectTick(LivingEntity livingEntity, int amplifier) {
        }

        public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
            return duration >= 1;
        }

        public boolean isInstantenous() {
            return false;
        }
    });
    public static final RegistrySupplier<MobEffect> AIR_SWIM = EFFECTS.register("air_swim", () -> new MobEffect(MobEffectCategory.BENEFICIAL, 24991){

        public void applyEffectTick(@NotNull LivingEntity livingEntity, int amplifier) {
            super.applyEffectTick(livingEntity, amplifier);
            if (!(!livingEntity.isSprinting() || livingEntity.isPassenger() || livingEntity.hasEffect(MobEffects.DOLPHINS_GRACE) || livingEntity.isEyeInFluid(FluidTags.WATER) || livingEntity.updateFluidHeightAndDoFluidPushing(FluidTags.WATER, 0.014))) {
                livingEntity.resetFallDistance();
                livingEntity.wasEyeInWater = true;
                livingEntity.wasTouchingWater = true;
                livingEntity.setSwimming(true);
                Vec3 vec32 = livingEntity.getDeltaMovement();
                float f = 1.08f;
                if (livingEntity.horizontalCollision && livingEntity.onClimbable()) {
                    vec32 = new Vec3(vec32.x, 0.25, vec32.z);
                }
                livingEntity.setDeltaMovement(vec32.multiply((double)f, (double)f + 0.05, (double)f));
                livingEntity.gameEvent(GameEvent.SWIM);
            }
        }

        public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
            return duration >= 1;
        }

        public boolean isInstantenous() {
            return false;
        }
    });
    public static final RegistrySupplier<MobEffect> WARMING = EFFECTS.register("warming", () -> new MobEffect(MobEffectCategory.BENEFICIAL, 16757504){

        public void applyEffectTick(@NotNull LivingEntity livingEntity, int amplifier) {
            if (!livingEntity.level().isClientSide()) {
                ServerLevel serverLevel = (ServerLevel)livingEntity.level();
                livingEntity.setTicksFrozen(0);
                if (livingEntity instanceof SnowGolem && serverLevel.getServer().getTickCount() % 20 == 0) {
                    livingEntity.hurt(livingEntity.damageSources().magic(), (float)(amplifier + 1));
                }
            }
        }

        public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
            return duration >= 1;
        }

        public boolean isInstantenous() {
            return false;
        }
    });
    public static final RegistrySupplier<MobEffect> HOMING = EFFECTS.register("homing", () -> new MobEffect(MobEffectCategory.BENEFICIAL, 16736892){

        /*
         * Enabled aggressive block sorting
         */
        public void applyEffectTick(LivingEntity livingEntity, int amplifier) {
            if (livingEntity.level().isClientSide()) return;
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                if (!livingEntity.isSpectator()) {
                    if (serverPlayer.getRespawnPosition() != null && serverPlayer.level().getBlockState(serverPlayer.getRespawnPosition()).getBlock() instanceof BedBlock) {
                        Vec3 pos = Vec3.atBottomCenterOf((Vec3i)serverPlayer.getRespawnPosition());
                        serverPlayer.connection.teleport(pos.x, pos.y, pos.z, Mth.wrapDegrees((float)serverPlayer.getYRot()), Mth.wrapDegrees((float)serverPlayer.getXRot()));
                        return;
                    }
                    Vec3 pos = Vec3.atBottomCenterOf((Vec3i)serverPlayer.level().getSharedSpawnPos());
                    serverPlayer.connection.teleport(pos.x, pos.y, pos.z, Mth.wrapDegrees((float)serverPlayer.getYRot()), Mth.wrapDegrees((float)serverPlayer.getXRot()));
                    return;
                }
            }
            Vec3 pos = Vec3.atBottomCenterOf((Vec3i)livingEntity.level().getSharedSpawnPos());
            livingEntity.teleportTo(pos.x, pos.y, pos.z);
        }

        public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
            return duration == 1;
        }

        public boolean isInstantenous() {
            return true;
        }
    });
    public static final RegistrySupplier<MobEffect> RECOVERY = EFFECTS.register("recovery", () -> new MobEffect(MobEffectCategory.BENEFICIAL, 9044042){

        public void applyEffectTick(LivingEntity livingEntity, int amplifier) {
            if (!livingEntity.level().isClientSide() && livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                if (!livingEntity.isSpectator() && serverPlayer.getLastDeathLocation().isPresent() && serverPlayer.level().dimension() == ((GlobalPos)serverPlayer.getLastDeathLocation().get()).dimension()) {
                    Vec3 pos = Vec3.atBottomCenterOf((Vec3i)((GlobalPos)serverPlayer.getLastDeathLocation().get()).pos());
                    serverPlayer.connection.teleport(pos.x, pos.y, pos.z, Mth.wrapDegrees((float)serverPlayer.getYRot()), Mth.wrapDegrees((float)serverPlayer.getXRot()));
                }
            }
        }

        public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
            return duration == 1;
        }

        public boolean isInstantenous() {
            return true;
        }
    });
    public static final RegistrySupplier<MobEffect> TELEPORTATION = EFFECTS.register("teleportation", () -> new MobEffect(MobEffectCategory.NEUTRAL, 13041919){

        public void applyEffectTick(@NotNull LivingEntity livingEntity, int amplifier) {
            if (!livingEntity.level().isClientSide() && livingEntity.level().getServer() != null && livingEntity.level().getServer().getTickCount() % (20 + livingEntity.getRandom().nextInt(-10, 40)) == 0) {
                ServerLevel level = livingEntity.level().getServer().getLevel(livingEntity.level().dimension());
                assert (level != null);
                if (!level.isClientSide) {
                    double d = livingEntity.getX();
                    double e = livingEntity.getY();
                    double f = livingEntity.getZ();
                    for (int i = 0; i < 32; ++i) {
                        double g = livingEntity.getX() + (livingEntity.getRandom().nextDouble() - 0.5) * 32.0;
                        double h = Mth.clamp((double)(livingEntity.getY() + (double)(livingEntity.getRandom().nextInt(32) - 16)), (double)level.getMinBuildHeight(), (double)(level.getMinBuildHeight() + level.getLogicalHeight() - 1));
                        double j = livingEntity.getZ() + (livingEntity.getRandom().nextDouble() - 0.5) * 32.0;
                        if (livingEntity.isPassenger()) {
                            livingEntity.stopRiding();
                        }
                        Vec3 vec3 = livingEntity.position();
                        if (!livingEntity.randomTeleport(g, h, j, true)) continue;
                        level.gameEvent(GameEvent.TELEPORT, vec3, GameEvent.Context.of((Entity)livingEntity));
                        SoundEvent soundEvent = livingEntity instanceof Fox ? SoundEvents.FOX_TELEPORT : SoundEvents.CHORUS_FRUIT_TELEPORT;
                        level.playSound((Player)null, d, e, f, soundEvent, SoundSource.PLAYERS, 1.0f, 1.0f);
                        livingEntity.playSound(soundEvent, 1.0f, 1.0f);
                        break;
                    }
                }
            }
        }

        public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
            return duration >= 1;
        }

        public boolean isInstantenous() {
            return false;
        }
    });
    public static final RegistrySupplier<MobEffect> SPLIPPERY = EFFECTS.register("slippery", () -> new MobEffect(MobEffectCategory.NEUTRAL, 0x17FFFF){

        public void applyEffectTick(@NotNull LivingEntity livingEntity, int amplifier) {
        }

        public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
            return duration > 1;
        }

        public boolean isInstantenous() {
            return false;
        }
    });
    public static final RegistrySupplier<MobEffect> THUNDEROUS = EFFECTS.register("thunderous", () -> new MobEffect(MobEffectCategory.HARMFUL, 0xE0FFFF){

        public void applyEffectTick(@NotNull LivingEntity livingEntity, int amplifier) {
            if (!livingEntity.level().isClientSide()) {
                ServerLevel serverLevel = (ServerLevel)livingEntity.level();
                Utils.lightning(livingEntity, serverLevel, amplifier);
            }
        }

        public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
            return duration == 1;
        }

        public boolean isInstantenous() {
            return true;
        }
    });
    public static final RegistrySupplier<MobEffect> EXPLOSIVE = EFFECTS.register("explosive", () -> new MobEffect(MobEffectCategory.HARMFUL, 4522008){

        public void applyEffectTick(@NotNull LivingEntity livingEntity, int amplifier) {
            if (!livingEntity.level().isClientSide()) {
                ServerLevel serverLevel = (ServerLevel)livingEntity.level();
                if (!livingEntity.isSpectator()) {
                    if (livingEntity.level().dimension() == Level.NETHER) {
                        Utils.explode(serverLevel, livingEntity.blockPosition(), (float)amplifier, true);
                    } else if (amplifier > 4) {
                        Utils.explode(serverLevel, livingEntity.blockPosition(), (float)amplifier, true);
                    } else {
                        Utils.explode(serverLevel, livingEntity.blockPosition(), (float)amplifier);
                    }
                }
            }
        }

        public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
            return duration == 1;
        }

        public boolean isInstantenous() {
            return true;
        }
    });
    public static final RegistrySupplier<MobEffect> BURNING = EFFECTS.register("burning", () -> new MobEffect(MobEffectCategory.HARMFUL, 16740608){

        public void applyEffectTick(@NotNull LivingEntity livingEntity, int amplifier) {
            if (!livingEntity.isInWaterRainOrBubble()) {
                livingEntity.setSecondsOnFire(1);
            }
        }

        public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
            return duration >= 1;
        }

        public boolean isInstantenous() {
            return false;
        }
    });
    public static final RegistrySupplier<MobEffect> FREEZING = EFFECTS.register("freezing", () -> new MobEffect(MobEffectCategory.HARMFUL, 0x17FFFF){

        public void applyEffectTick(LivingEntity livingEntity, int amplifier) {
            if (livingEntity.canFreeze()) {
                livingEntity.setIsInPowderSnow(true);
            }
        }

        public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
            return duration >= 1;
        }

        public boolean isInstantenous() {
            return false;
        }
    });
    public static final RegistrySupplier<MobEffect> CORROSIVE = EFFECTS.register("corrosive", () -> new MobEffect(MobEffectCategory.HARMFUL, 10157824){

        public void applyEffectTick(@NotNull LivingEntity livingEntity, int amplifier) {
            if (!livingEntity.level().isClientSide()) {
                ServerLevel serverLevel = (ServerLevel)livingEntity.level();
                Random random = new Random();
                if (!livingEntity.isSpectator() && serverLevel.getServer().getTickCount() % 10 == 0) {
                    MinecraftServer server = serverLevel.getServer();
                    if (livingEntity instanceof ServerPlayer) {
                        ArrayList<Item> items = new ArrayList<Item>();
                        items.add(Items.IRON_NUGGET);
                        items.add(Items.IRON_ORE);
                        items.add(Items.IRON_INGOT);
                        items.add(Items.COPPER_INGOT);
                        items.add(Items.NETHERITE_SCRAP);
                        items.add(Items.NETHERITE_INGOT);
                        List<Item> results = Utils.recipesContainsItems(server, RecipeType.CRAFTING, items);
                        results.addAll(Utils.recipesContainsItems(server, RecipeType.SMELTING, items));
                        results.addAll(Utils.recipesContainsItems(server, RecipeType.SMITHING, items));
                        results.addAll(Utils.recipesContainsItems(server, RecipeType.BLASTING, items));
                        results.addAll(Utils.recipesContainsItems(server, RecipeType.SMOKING, items));
                        results.addAll(Utils.recipesContainsItems(server, RecipeType.STONECUTTING, items));
                        results.addAll(Utils.recipesContainsItems(server, RecipeType.CAMPFIRE_COOKING, items));
                        ArrayList<Item> resultsWithoutDuplicates = new ArrayList<Item>(new HashSet<Item>(results));
                        Inventory inventory = ((ServerPlayer)livingEntity).getInventory();
                        for (int i = 0; i < inventory.getContainerSize(); ++i) {
                            Item item = inventory.getItem(i).getItem();
                            ItemStack itemStack = inventory.getItem(i);
                            if (itemStack.isDamageableItem()) {
                                Utils.damageItem(livingEntity, itemStack, 1 + amplifier);
                                continue;
                            }
                            if (itemStack.isDamageableItem() || !resultsWithoutDuplicates.contains(item) || random.nextInt(100) < 90 || random.nextInt(3) > amplifier) continue;
                            itemStack.shrink(1);
                        }
                    } else if (livingEntity instanceof IronGolem) {
                        livingEntity.hurt(livingEntity.damageSources().magic(), 1.0f + (float)amplifier);
                    } else {
                        if (livingEntity.hasItemInSlot(EquipmentSlot.MAINHAND)) {
                            Utils.damageItem(livingEntity, EquipmentSlot.MAINHAND, 1 + amplifier);
                        }
                        if (livingEntity.hasItemInSlot(EquipmentSlot.OFFHAND)) {
                            Utils.damageItem(livingEntity, EquipmentSlot.OFFHAND, 1 + amplifier);
                        }
                        if (livingEntity.hasItemInSlot(EquipmentSlot.HEAD)) {
                            Utils.damageItem(livingEntity, EquipmentSlot.HEAD, 1 + amplifier);
                        }
                        if (livingEntity.hasItemInSlot(EquipmentSlot.CHEST)) {
                            Utils.damageItem(livingEntity, EquipmentSlot.CHEST, 1 + amplifier);
                        }
                        if (livingEntity.hasItemInSlot(EquipmentSlot.LEGS)) {
                            Utils.damageItem(livingEntity, EquipmentSlot.LEGS, 1 + amplifier);
                        }
                        if (livingEntity.hasItemInSlot(EquipmentSlot.FEET)) {
                            Utils.damageItem(livingEntity, EquipmentSlot.FEET, 1 + amplifier);
                        }
                    }
                }
            }
        }

        public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
            return duration >= 1;
        }

        public boolean isInstantenous() {
            return false;
        }
    });
    public static final RegistrySupplier<MobEffect> GRAVITATION = EFFECTS.register("gravitation", () -> new MobEffect(MobEffectCategory.HARMFUL, 11350783){

        public void applyEffectTick(@NotNull LivingEntity livingEntity, int amplifier) {
        }

        public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
            return duration >= 1;
        }

        public boolean isInstantenous() {
            return false;
        }
    });
    public static final RegistrySupplier<MobEffect> FATAL_POISON = EFFECTS.register("fatal_poison", () -> new MobEffect(MobEffectCategory.HARMFUL, 0xFF00FF){

        public void applyEffectTick(@NotNull LivingEntity livingEntity, int amplifier) {
            livingEntity.hurt(livingEntity.damageSources().magic(), 1.0f);
        }

        public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
            int k = 25 >> amplifier;
            if (k > 0) {
                return duration % k == 0;
            }
            return true;
        }
    });
    public static final RegistrySupplier<MobEffect> PROTECTION = EFFECTS.register("protection", () -> new MobEffect(MobEffectCategory.BENEFICIAL, 8751501){

        public void applyEffectTick(LivingEntity livingEntity, int amplifier) {
            if (livingEntity.getAttributes().hasAttribute(Attributes.ARMOR)) {
                this.addAttributeModifier(Attributes.ARMOR, "9aa8ab7f-3f42-4c2d-acc9-30a56847c3fc", 1.0, AttributeModifier.Operation.ADDITION);
            }
        }

        public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
            return duration >= 1;
        }

        public boolean isInstantenous() {
            return false;
        }
    });
    public static final RegistrySupplier<MobEffect> SILENCE = EFFECTS.register("silence", () -> new MobEffect(MobEffectCategory.BENEFICIAL, 92){

        public void applyEffectTick(LivingEntity livingEntity, int amplifier) {
            livingEntity.setSilent(true);
        }

        public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
            return duration >= 1;
        }

        public boolean isInstantenous() {
            return false;
        }
    });
    public static final RegistrySupplier<MobEffect> NULLIFIER = EFFECTS.register("nullifier", () -> new MobEffect(MobEffectCategory.NEUTRAL, 13691391){

        public void applyEffectTick(LivingEntity livingEntity, int amplifier) {
            for (MobEffectInstance effectInstance : livingEntity.getActiveEffects()) {
                if (effectInstance.getEffect() == NULLIFIER.get()) continue;
                livingEntity.removeEffect(effectInstance.getEffect());
            }
        }

        public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
            return duration >= 1;
        }

        public boolean isInstantenous() {
            return false;
        }
    });
    public static final RegistrySupplier<MobEffect> INFECTION = EFFECTS.register("infection", () -> new MobEffect(MobEffectCategory.HARMFUL, 14848){

        public void applyEffectTick(LivingEntity livingEntity, int amplifier) {
            if (livingEntity.hasEffect((MobEffect)this)) {
                int duration = livingEntity.getEffect((MobEffect)this).getDuration();
                if (duration == 600) {
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.HUNGER, 600, 40));
                }
                if (duration == 300) {
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 300));
                }
                if (duration == 200) {
                    livingEntity.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 200));
                }
                if (duration == 1) {
                    if (livingEntity instanceof Player && !((Player)livingEntity).isCreative()) {
                        livingEntity.hurt(livingEntity.damageSources().magic(), 20.0f);
                        if (livingEntity.isDeadOrDying()) {
                            Zombie zombie = new Zombie(EntityType.ZOMBIE, livingEntity.level());
                            zombie.copyPosition((Entity)livingEntity);
                            zombie.setCustomName(livingEntity.getCustomName());
                            zombie.setCanPickUpLoot(true);
                            for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                                ItemStack itemStack = livingEntity.getItemBySlot(equipmentSlot);
                                if (itemStack.isEmpty()) continue;
                                zombie.setItemSlot(equipmentSlot, itemStack.copy());
                                zombie.setDropChance(equipmentSlot, zombie.getEquipmentDropChance(equipmentSlot));
                                itemStack.setCount(0);
                            }
                            livingEntity.level().addFreshEntity((Entity)zombie);
                            if (livingEntity.isPassenger()) {
                                Entity entity = livingEntity.getVehicle();
                                livingEntity.stopRiding();
                                zombie.startRiding(entity, true);
                            }
                            zombie.addEffect(new MobEffectInstance((MobEffect)this, 1200));
                            livingEntity.discard();
                        }
                    } else if (livingEntity instanceof Villager) {
                        Mob mob = ((Mob)livingEntity).convertTo(EntityType.ZOMBIE_VILLAGER, true);
                        mob.addEffect(new MobEffectInstance((MobEffect)this, 1200));
                    } else if (livingEntity instanceof Piglin) {
                        Mob mob = ((Mob)livingEntity).convertTo(EntityType.ZOMBIFIED_PIGLIN, true);
                        mob.addEffect(new MobEffectInstance((MobEffect)this, 1200));
                    } else if (livingEntity instanceof Hoglin) {
                        Mob mob = ((Mob)livingEntity).convertTo(EntityType.ZOGLIN, true);
                        mob.addEffect(new MobEffectInstance((MobEffect)this, 1200));
                    } else if (livingEntity instanceof Horse) {
                        Mob mob = ((Mob)livingEntity).convertTo(EntityType.ZOMBIE_HORSE, true);
                        mob.addEffect(new MobEffectInstance((MobEffect)this, 1200));
                    } else if (!(livingEntity instanceof Zombie || livingEntity instanceof ZombieHorse || livingEntity instanceof Zoglin)) {
                        livingEntity.hurt(livingEntity.damageSources().magic(), 5.0f);
                    }
                }
            }
        }

        public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
            return duration >= 1;
        }

        public boolean isInstantenous() {
            return false;
        }
    });
}

