/*
 * Decompiled with CFR 0.152.
 */
package com.vinurl;

import com.vinurl.AudioHandlerClient;
import com.vinurl.FileSound;
import com.vinurl.VinURL;
import com.vinurl.VinURLConfig;
import com.vinurl.cmd.Commands;
import com.vinurl.exe.FFmpeg;
import com.vinurl.exe.YoutubeDL;
import com.vinurl.gui.MusicDiscScreen;
import java.io.IOException;
import java.net.URISyntaxException;
import java.time.LocalDate;
import java.util.HashMap;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1113;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import org.apache.commons.codec.digest.DigestUtils;

@Environment(value=EnvType.CLIENT)
public class VinURLClient
implements ClientModInitializer {
    public static final VinURLConfig CONFIG = VinURLConfig.createAndLoad();
    public static boolean isAprilFoolsDay = LocalDate.now().getMonthValue() == 4 && LocalDate.now().getDayOfMonth() == 1;
    HashMap<class_243, FileSound> playingSounds = new HashMap();

    public void onInitializeClient() {
        try {
            FFmpeg.getInstance().checkForExecutable();
            YoutubeDL.getInstance().checkForExecutable();
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
        Commands.register();
        ClientPlayNetworking.registerGlobalReceiver((class_2960)VinURL.CUSTOM_RECORD_PACKET_ID, (client, handler, buf, responseSender) -> {
            class_243 blockPosition = buf.method_10811().method_46558();
            String fileUrl = buf.method_19772();
            String fileName = DigestUtils.sha256Hex((String)fileUrl);
            client.execute(() -> {
                FileSound currentSound = this.playingSounds.get(blockPosition);
                if (currentSound != null) {
                    client.method_1483().method_4870((class_1113)currentSound);
                }
                if (fileUrl.isEmpty()) {
                    return;
                }
                if (!AudioHandlerClient.fileNameToFile(fileName + ".ogg").exists() && client.field_1724 != null) {
                    client.field_1724.method_43496((class_2561)class_2561.method_43470((String)"Downloading music, please wait a moment..."));
                    AudioHandlerClient.downloadAudio(fileUrl, fileName).thenAccept(result -> {
                        if (result.booleanValue()) {
                            client.field_1724.method_43496((class_2561)class_2561.method_43470((String)"Downloading complete!"));
                            FileSound fileSound = new FileSound(fileName, blockPosition);
                            this.playingSounds.put(blockPosition, fileSound);
                            client.method_1483().method_4873((class_1113)fileSound);
                        } else {
                            client.field_1724.method_43496((class_2561)class_2561.method_43470((String)"Failed to download music!"));
                        }
                    });
                } else {
                    FileSound fileSound = new FileSound(fileName, blockPosition);
                    this.playingSounds.put(blockPosition, fileSound);
                    client.method_1483().method_4873((class_1113)fileSound);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)VinURL.CUSTOM_RECORD_GUI, (client, handler, buf, responseSender) -> {
            String currentUrl = buf.method_10819().method_7948().method_10558("music_url");
            client.execute(() -> client.method_1507((class_437)new MusicDiscScreen(currentUrl)));
        });
    }
}

