/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils;

import fuzs.easyanvils.config.ClientConfig;
import fuzs.easyanvils.config.CommonConfig;
import fuzs.easyanvils.config.ServerConfig;
import fuzs.easyanvils.data.DynamicRecipeProvider;
import fuzs.easyanvils.handler.BlockConversionHandler;
import fuzs.easyanvils.handler.ItemInteractionHandler;
import fuzs.easyanvils.handler.NameTagDropHandler;
import fuzs.easyanvils.init.ModRegistry;
import fuzs.easyanvils.network.S2CAnvilRepairMessage;
import fuzs.easyanvils.network.S2COpenNameTagEditorMessage;
import fuzs.easyanvils.network.client.C2SNameTagUpdateMessage;
import fuzs.easyanvils.network.client.C2SRenameItemMessage;
import fuzs.puzzleslib.api.config.v3.ConfigHolder;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.context.PackRepositorySourcesContext;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import fuzs.puzzleslib.api.event.v1.RegistryEntryAddedCallback;
import fuzs.puzzleslib.api.event.v1.core.EventPhase;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingDropsCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.AnvilEvents;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerInteractEvents;
import fuzs.puzzleslib.api.event.v1.server.TagsUpdatedCallback;
import fuzs.puzzleslib.api.network.v2.NetworkHandlerV2;
import fuzs.puzzleslib.api.resources.v1.DynamicPackResources;
import fuzs.puzzleslib.api.resources.v1.PackResourcesHelper;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_2969;
import net.minecraft.class_3218;
import net.minecraft.class_3285;
import net.minecraft.class_3481;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyAnvils
implements ModConstructor {
    public static final String MOD_ID = "easyanvils";
    public static final String MOD_NAME = "Easy Anvils";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Easy Anvils");
    public static final NetworkHandlerV2 NETWORK = NetworkHandlerV2.build((String)"easyanvils", (boolean)false);
    public static final ConfigHolder CONFIG = ConfigHolder.builder((String)"easyanvils").client(ClientConfig.class).common(CommonConfig.class).server(ServerConfig.class);

    public void onConstructMod() {
        ModRegistry.touch();
        EasyAnvils.registerMessages();
        EasyAnvils.registerHandlers();
    }

    private static void registerMessages() {
        NETWORK.registerClientbound(S2COpenNameTagEditorMessage.class, S2COpenNameTagEditorMessage::new);
        NETWORK.registerServerbound(C2SNameTagUpdateMessage.class, C2SNameTagUpdateMessage::new);
        NETWORK.registerClientbound(S2CAnvilRepairMessage.class, S2CAnvilRepairMessage::new);
        NETWORK.registerServerbound(C2SRenameItemMessage.class, C2SRenameItemMessage::new);
    }

    private static void registerHandlers() {
        PlayerInteractEvents.USE_ITEM.register(ItemInteractionHandler::onUseItem);
        PlayerInteractEvents.USE_BLOCK.register(ItemInteractionHandler::onUseBlock);
        AnvilEvents.USE.register(ItemInteractionHandler::onAnvilUse);
        RegistryEntryAddedCallback.registryEntryAdded((class_5321)class_7924.field_41254).register(BlockConversionHandler::onRegistryEntryAdded);
        PlayerInteractEvents.USE_BLOCK.register(BlockConversionHandler::onUseBlock);
        TagsUpdatedCallback.EVENT.register(EventPhase.FIRST, BlockConversionHandler::onTagsUpdated);
        LivingDropsCallback.EVENT.register(NameTagDropHandler::onLivingDrops);
    }

    public void onCommonSetup() {
        class_2315.method_10009((class_1935)class_1802.field_8773, (class_2357)new class_2969(){

            public class_1799 method_10135(class_2342 source, class_1799 itemStack) {
                if (!((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).miscellaneous.anvilRepairing) {
                    return super.method_10135(source, itemStack);
                }
                class_2350 direction = (class_2350)source.comp_1969().method_11654((class_2769)class_2315.field_10918);
                class_2338 pos = source.comp_1968().method_10093(direction);
                class_3218 level = source.comp_1967();
                class_2680 state = level.method_8320(pos);
                this.method_27955(true);
                if (state.method_26164(class_3481.field_15486)) {
                    if (ItemInteractionHandler.tryRepairAnvil((class_1937)level, pos, state)) {
                        itemStack.method_7934(1);
                    } else {
                        this.method_27955(false);
                    }
                    return itemStack;
                }
                return super.method_10135(source, itemStack);
            }
        });
    }

    public void onAddDataPackFinders(PackRepositorySourcesContext context) {
        if (!((CommonConfig)EasyAnvils.CONFIG.get(CommonConfig.class)).nameTagCraftingRecipe) {
            return;
        }
        context.addRepositorySource(new class_3285[]{PackResourcesHelper.buildServerPack((class_2960)EasyAnvils.id("name_tag_recipe"), (Supplier)DynamicPackResources.create((DataProviderContext.Factory[])new DataProviderContext.Factory[]{DynamicRecipeProvider::new}), (boolean)true)});
    }

    public static class_2960 id(String path) {
        return new class_2960(MOD_ID, path);
    }
}

