/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils.handler;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import fuzs.easyanvils.EasyAnvils;
import fuzs.easyanvils.config.ServerConfig;
import fuzs.easyanvils.init.ModRegistry;
import fuzs.easyanvils.world.level.block.AnvilWithInventoryBlock;
import fuzs.puzzleslib.api.block.v1.BlockConversionHelper;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.puzzleslib.api.init.v3.registry.RegistryHelper;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2199;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class BlockConversionHandler {
    public static final class_2561 INVALID_BLOCK_COMPONENT = class_2561.method_43471((String)"container.invalidBlock");
    public static final BiMap<class_2248, class_2248> BLOCK_CONVERSIONS = HashBiMap.create();

    public static void onRegistryEntryAdded(class_2378<class_2248> registry, class_2960 id, class_2248 block, BiConsumer<class_2960, Supplier<class_2248>> registrar) {
        if (block instanceof class_2199 && !(block instanceof AnvilWithInventoryBlock)) {
            class_2960 resourceLocation = EasyAnvils.id(id.method_12836() + "/" + id.method_12832());
            registrar.accept(resourceLocation, () -> {
                AnvilWithInventoryBlock newBlock = new AnvilWithInventoryBlock(block);
                BLOCK_CONVERSIONS.put((Object)block, (Object)newBlock);
                return newBlock;
            });
        }
    }

    public static EventResultHolder<class_1269> onUseBlock(class_1657 player, class_1937 level, class_1268 interactionHand, class_3965 hitResult) {
        if (!((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).miscellaneous.disableVanillaAnvil) {
            return EventResultHolder.pass();
        }
        class_2680 blockState = level.method_8320(hitResult.method_17777());
        if (BLOCK_CONVERSIONS.containsKey((Object)blockState.method_26204()) && !blockState.method_26164(ModRegistry.UNALTERED_ANVILS_BLOCK_TAG)) {
            player.method_7353((class_2561)class_2561.method_43473().method_10852(INVALID_BLOCK_COMPONENT).method_27692(class_124.field_1061), true);
            return EventResultHolder.interrupt((Object)class_1269.method_29236((boolean)level.field_9236));
        }
        return EventResultHolder.pass();
    }

    public static void onTagsUpdated(class_5455 registryAccess, boolean client) {
        for (Map.Entry entry : class_7923.field_41178.method_29722()) {
            Object v = entry.getValue();
            if (!(v instanceof class_1747)) continue;
            class_1747 blockItem = (class_1747)v;
            class_2248 block = blockItem.method_7711();
            BlockConversionHandler.setItemForBlock(((class_5321)entry.getKey()).method_29177(), blockItem, block);
            BlockConversionHandler.setBlockForItem(blockItem, block);
        }
        BlockConversionHandler.copyBoundTags();
    }

    private static void setItemForBlock(class_2960 resourceLocation, class_1747 blockItem, class_2248 block) {
        if (block instanceof class_2199 && !(block instanceof AnvilWithInventoryBlock)) {
            BlockConversionHelper.setItemForBlock((class_2248)((class_2248)BLOCK_CONVERSIONS.get((Object)block)), (class_1792)blockItem);
        }
    }

    private static void setBlockForItem(class_1747 blockItem, class_2248 block) {
        class_2248 baseBlock;
        class_2248 diagonalBlock = (class_2248)BLOCK_CONVERSIONS.get((Object)block);
        if (diagonalBlock != null) {
            baseBlock = block;
        } else {
            baseBlock = (class_2248)BLOCK_CONVERSIONS.inverse().get((Object)block);
            if (baseBlock != null) {
                diagonalBlock = block;
            } else {
                return;
            }
        }
        if (RegistryHelper.is(ModRegistry.UNALTERED_ANVILS_BLOCK_TAG, (Object)baseBlock)) {
            BlockConversionHelper.setBlockForItem((class_1747)blockItem, (class_2248)baseBlock);
        } else {
            BlockConversionHelper.setBlockForItem((class_1747)blockItem, (class_2248)diagonalBlock);
        }
    }

    private static void copyBoundTags() {
        BLOCK_CONVERSIONS.forEach(BlockConversionHelper::copyBoundTags);
    }

    public static <T extends Comparable<T>, V extends T> class_2680 copyAllProperties(class_2680 blockState, Map<class_2769<?>, Comparable<?>> values) {
        for (Map.Entry<class_2769<?>, Comparable<?>> entry : values.entrySet()) {
            blockState = (class_2680)blockState.method_47968(entry.getKey(), entry.getValue());
        }
        return blockState;
    }

    public static class_2680 convertReplacementToOriginal(@Nullable class_2680 blockState) {
        if (blockState != null && BLOCK_CONVERSIONS.containsValue((Object)blockState.method_26204())) {
            class_2248 block = (class_2248)BLOCK_CONVERSIONS.inverse().get((Object)blockState.method_26204());
            return BlockConversionHandler.copyAllProperties(block.method_9564(), blockState.method_11656());
        }
        return blockState;
    }

    public static class_2680 convertOriginalToReplacement(@Nullable class_2680 blockState) {
        if (blockState != null && BLOCK_CONVERSIONS.containsKey((Object)blockState.method_26204())) {
            class_2248 block = (class_2248)BLOCK_CONVERSIONS.get((Object)blockState.method_26204());
            return BlockConversionHandler.copyAllProperties(block.method_9564(), blockState.method_11656());
        }
        return blockState;
    }
}

