/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.common.command;

import cloud.commandframework.CommandManager;
import cloud.commandframework.captions.CaptionVariable;
import cloud.commandframework.exceptions.ArgumentParseException;
import cloud.commandframework.exceptions.CommandExecutionException;
import cloud.commandframework.exceptions.InvalidCommandSenderException;
import cloud.commandframework.exceptions.InvalidSyntaxException;
import cloud.commandframework.exceptions.NoPermissionException;
import cloud.commandframework.exceptions.parsing.ParserException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.util.ComponentMessageThrowable;
import org.checkerframework.checker.nullness.qual.NonNull;
import xyz.jpenilla.tabtps.common.Messages;
import xyz.jpenilla.tabtps.common.TabTPS;
import xyz.jpenilla.tabtps.common.command.Commander;
import xyz.jpenilla.tabtps.common.command.exception.CommandCompletedException;
import xyz.jpenilla.tabtps.common.util.Components;
import xyz.jpenilla.tabtps.common.util.Constants;

public final class ExceptionHandler {
    private final TabTPS tabTPS;

    ExceptionHandler(@NonNull TabTPS tabTPS) {
        this.tabTPS = tabTPS;
    }

    private static void decorateAndSend(@NonNull Commander commander, @NonNull ComponentLike componentLike) {
        commander.sendMessage((Component)Components.ofChildren(new ComponentLike[]{Constants.PREFIX, Component.space(), componentLike}));
    }

    public void apply(@NonNull CommandManager<Commander> manager) {
        manager.registerExceptionHandler(CommandExecutionException.class, this::commandExecution);
        manager.registerExceptionHandler(NoPermissionException.class, this::noPermission);
        manager.registerExceptionHandler(ArgumentParseException.class, this::argumentParsing);
        manager.registerExceptionHandler(InvalidCommandSenderException.class, this::invalidSender);
        manager.registerExceptionHandler(InvalidSyntaxException.class, this::invalidSyntax);
    }

    private void commandExecution(@NonNull Commander commander, @NonNull CommandExecutionException exception) {
        Throwable cause = exception.getCause();
        if (cause instanceof CommandCompletedException) {
            Component message = ((CommandCompletedException)cause).componentMessage();
            if (message != null) {
                commander.sendMessage(message);
            }
            return;
        }
        this.tabTPS.platform().logger().warn("An unexpected error occurred during command execution", cause);
        StringWriter writer = new StringWriter();
        cause.printStackTrace(new PrintWriter(writer));
        String stackTrace = writer.toString().replaceAll("\t", "    ");
        TextComponent.Builder hoverText = Component.text();
        Component throwableMessage = ComponentMessageThrowable.getOrConvertMessage((Throwable)cause);
        if (throwableMessage != null) {
            ((TextComponent.Builder)((TextComponent.Builder)hoverText.append(throwableMessage)).append((Component)Component.newline())).append((Component)Component.newline());
        }
        ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)hoverText.append((Component)Component.text((String)stackTrace))).append((Component)Component.newline())).append((Component)Component.text((String)"    "))).append((Component)Messages.MISC_TEXT_CLICK_TO_COPY.styled((TextColor)NamedTextColor.GRAY, TextDecoration.ITALIC, new ComponentLike[0]));
        TextComponent.Builder message = Component.text();
        message.append((Component)Messages.COMMAND_EXCEPTION_COMMAND_EXECUTION.styled((TextColor)NamedTextColor.RED, new ComponentLike[0]));
        if (commander.hasPermission("tabtps.command.hover_stacktrace")) {
            message.hoverEvent((HoverEventSource)hoverText.build());
            message.clickEvent(ClickEvent.copyToClipboard((String)stackTrace));
        }
        ExceptionHandler.decorateAndSend(commander, (ComponentLike)message);
    }

    private void noPermission(@NonNull Commander commander, @NonNull NoPermissionException exception) {
        ExceptionHandler.decorateAndSend(commander, (ComponentLike)Messages.COMMAND_EXCEPTION_NO_PERMISSION.styled((TextColor)NamedTextColor.RED, new ComponentLike[0]));
    }

    private void argumentParsing(@NonNull Commander commander, @NonNull ArgumentParseException exception) {
        Component message;
        Throwable cause = exception.getCause();
        if (cause instanceof ParserException) {
            ParserException ex = (ParserException)cause;
            message = Component.translatable((String)(Messages.bundleName() + "/command.caption." + ex.errorCaption().getKey()), (TextColor)NamedTextColor.GRAY, Arrays.stream(ex.captionVariables()).map(CaptionVariable::getValue).map(Component::text).collect(Collectors.toList()));
        } else {
            message = Objects.requireNonNull(ComponentMessageThrowable.getOrConvertMessage((Throwable)cause)).color((TextColor)NamedTextColor.GRAY);
        }
        ExceptionHandler.decorateAndSend(commander, (ComponentLike)Messages.COMMAND_EXCEPTION_INVALID_ARGUMENT.styled((TextColor)NamedTextColor.RED, new ComponentLike[]{message}));
    }

    private void invalidSender(@NonNull Commander commander, @NonNull InvalidCommandSenderException exception) {
        TranslatableComponent message = Messages.COMMAND_EXCEPTION_INVALID_SENDER_TYPE.styled((TextColor)NamedTextColor.RED, new ComponentLike[]{Component.text((String)exception.getRequiredSender().getSimpleName())});
        ExceptionHandler.decorateAndSend(commander, (ComponentLike)message);
    }

    private void invalidSyntax(@NonNull Commander commander, @NonNull InvalidSyntaxException exception) {
        TranslatableComponent message = Messages.COMMAND_EXCEPTION_INVALID_SYNTAX.styled((TextColor)NamedTextColor.RED, new ComponentLike[]{Components.highlight((Component)Component.text((String)String.format("/%s", exception.getCorrectSyntax()), (TextColor)NamedTextColor.GRAY), (TextColor)NamedTextColor.WHITE)});
        ExceptionHandler.decorateAndSend(commander, (ComponentLike)message);
    }
}

