/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.common.command.commands;

import cloud.commandframework.ArgumentDescription;
import cloud.commandframework.Command;
import cloud.commandframework.arguments.CommandArgument;
import cloud.commandframework.arguments.standard.IntegerArgument;
import cloud.commandframework.context.CommandContext;
import cloud.commandframework.execution.CommandExecutionHandler;
import cloud.commandframework.minecraft.extras.MinecraftExtrasMetaKeys;
import cloud.commandframework.minecraft.extras.RichDescription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.feature.pagination.Pagination;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.checkerframework.checker.nullness.qual.NonNull;
import xyz.jpenilla.tabtps.common.Messages;
import xyz.jpenilla.tabtps.common.TabTPS;
import xyz.jpenilla.tabtps.common.User;
import xyz.jpenilla.tabtps.common.command.Commander;
import xyz.jpenilla.tabtps.common.command.Commands;
import xyz.jpenilla.tabtps.common.command.TabTPSCommand;
import xyz.jpenilla.tabtps.common.command.exception.CommandCompletedException;
import xyz.jpenilla.tabtps.common.config.Theme;
import xyz.jpenilla.tabtps.common.util.Components;
import xyz.jpenilla.tabtps.common.util.Constants;
import xyz.jpenilla.tabtps.common.util.PingUtil;
import xyz.jpenilla.tabtps.common.util.TranslatableProvider;

public class PingCommand
extends TabTPSCommand {
    public PingCommand(@NonNull TabTPS tabTPS, @NonNull Commands commands) {
        super(tabTPS, commands);
    }

    @Override
    public void register() {
        this.commands.register((Command.Builder<Commander>)this.commandManager.commandBuilder("ping", new String[0]).permission("tabtps.ping").meta(MinecraftExtrasMetaKeys.DESCRIPTION, (Object)Messages.COMMAND_PING_SELF_DESCRIPTION.plain(new ComponentLike[0])).handler(this::onPingSelf));
        this.commands.register((Command.Builder<Commander>)this.commandManager.commandBuilder("pingall", new String[0]).argument((CommandArgument.Builder)IntegerArgument.builder((String)"page").withMin(1).withMax(999).asOptionalWithDefault(1), (ArgumentDescription)RichDescription.of((ComponentLike)Messages.COMMAND_PING_ARGUMENTS_PAGE)).permission("tabtps.ping.others").meta(MinecraftExtrasMetaKeys.DESCRIPTION, (Object)Messages.COMMAND_PING_ALL_DESCRIPTION.plain(new ComponentLike[0])).handler(this::onPingAll));
    }

    protected <T> void registerPingTargetsCommand(@NonNull CommandArgument<Commander, T> targetsArgument, @NonNull CommandExecutionHandler<Commander> handler) {
        this.commands.register((Command.Builder<Commander>)this.commandManager.commandBuilder("ping", new String[0]).argument(targetsArgument, (ArgumentDescription)RichDescription.of((ComponentLike)Messages.COMMAND_PING_TARGET_ARGUMENTS_TARGET)).argument((CommandArgument.Builder)IntegerArgument.builder((String)"page").withMin(1).withMax(999).asOptionalWithDefault(1), (ArgumentDescription)RichDescription.of((ComponentLike)Messages.COMMAND_PING_ARGUMENTS_PAGE)).permission("tabtps.ping.others").meta(MinecraftExtrasMetaKeys.DESCRIPTION, (Object)Messages.COMMAND_PING_TARGET_DESCRIPTION.plain(new ComponentLike[0])).handler(handler));
    }

    private void onPingAll(@NonNull CommandContext<Commander> context) {
        Commander sender = (Commander)context.getSender();
        int page = (Integer)context.get("page");
        this.pingMultiple(sender, Collections.unmodifiableCollection(this.tabTPS.platform().userService().onlineUsers()), page, "pingall");
    }

    private void onPingSelf(@NonNull CommandContext<Commander> context) {
        Commander sender = (Commander)context.getSender();
        if (!(sender instanceof User)) {
            throw CommandCompletedException.withMessage((ComponentLike)Components.ofChildren(new ComponentLike[]{Constants.PREFIX, Component.space(), Messages.COMMAND_PING_TEXT_CONSOLE_MUST_PROVIDE_PLAYER.styled((TextColor)NamedTextColor.RED, new ComponentLike[0])}));
        }
        User player = (User)sender;
        player.sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Constants.PREFIX)).append((Component)Component.space())).append((Component)Messages.COMMAND_PING_SELF_TEXT_YOUR_PING.styled((TextColor)NamedTextColor.GRAY, new ComponentLike[]{Components.ofChildren(new ComponentLike[]{PingUtil.coloredPing(player, Theme.DEFAULT.colorScheme()), Messages.LABEL_MILLISECONDS_SHORT.styled(Theme.DEFAULT.colorScheme().textSecondary(), new ComponentLike[0])})})));
    }

    protected final void pingTargets(@NonNull Commander commander, @NonNull List<User<?>> targets, @NonNull String inputString, int page) {
        if (targets.isEmpty()) {
            throw CommandCompletedException.withMessage((ComponentLike)Components.ofChildren(new ComponentLike[]{Constants.PREFIX, Component.space(), Messages.MISC_COMMAND_TEXT_NO_PLAYERS_FOUND.styled((TextColor)NamedTextColor.RED, new ComponentLike[]{Component.text((String)inputString)})}));
        }
        if (targets.size() > 1) {
            this.pingMultiple(commander, targets, page, String.format("ping %s", inputString));
            return;
        }
        User<?> targetPlayer = targets.get(0);
        commander.sendMessage((ComponentLike)((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Constants.PREFIX)).append((Component)Component.space())).append((Component)Messages.COMMAND_PING_TARGET_TEXT_TARGETS_PING.styled((TextColor)NamedTextColor.GRAY, new ComponentLike[]{targetPlayer.displayName(), Components.ofChildren(new ComponentLike[]{PingUtil.coloredPing(targetPlayer, Theme.DEFAULT.colorScheme()), Messages.LABEL_MILLISECONDS_SHORT.styled(Theme.DEFAULT.colorScheme().textSecondary(), new ComponentLike[0])})})));
    }

    private void pingMultiple(@NonNull Commander sender, @NonNull Collection<User<?>> targets, int page, @NonNull String commandPrefix) {
        ArrayList content = new ArrayList();
        ArrayList pings = new ArrayList();
        targets.stream().sorted(Comparator.comparing(User::ping)).forEach(player -> {
            content.add(Components.ofChildren(new ComponentLike[]{Component.space(), Component.text((String)"-", (TextColor)NamedTextColor.GRAY), Component.space(), player.displayName(), Component.text((String)":", (TextColor)NamedTextColor.GRAY), Component.space(), PingUtil.coloredPing(player, Theme.DEFAULT.colorScheme()), Messages.LABEL_MILLISECONDS_SHORT.styled((TextColor)NamedTextColor.GRAY, new ComponentLike[0])}));
            pings.add(player.ping());
        });
        int avgPing = (int)Math.round(pings.stream().mapToInt(i -> i).average().orElse(0.0));
        TranslatableProvider playerAmountTranslatable = targets.size() == 1 ? Messages.COMMAND_PING_TEXT_AMOUNT_PLAYERS_SINGULAR : Messages.COMMAND_PING_TEXT_AMOUNT_PLAYERS;
        TextComponent playerAmount = Components.ofChildren(new ComponentLike[]{Component.text((char)'(', (TextColor)NamedTextColor.WHITE), playerAmountTranslatable.styled((TextColor)NamedTextColor.GRAY, new ComponentLike[]{Component.text((int)this.tabTPS.platform().userService().onlinePlayers(), (TextColor)NamedTextColor.GREEN)}), Component.text((char)')', (TextColor)NamedTextColor.WHITE)});
        TextComponent summary = Components.ofChildren(new ComponentLike[]{Messages.COMMAND_PING_TEXT_AVERAGE_PING.styled((TextColor)NamedTextColor.WHITE, new ComponentLike[0]), Component.text((String)": ", (TextColor)NamedTextColor.GRAY), PingUtil.coloredPing(avgPing, Theme.DEFAULT.colorScheme()), Messages.LABEL_MILLISECONDS_SHORT.styled((TextColor)NamedTextColor.GRAY, new ComponentLike[0]), Component.space(), playerAmount});
        ArrayList<TextComponent> messages = new ArrayList<TextComponent>();
        messages.add(Component.empty());
        messages.addAll(PingCommand.pagination(commandPrefix).render(content, page));
        messages.add(Component.empty());
        messages.add(summary);
        messages.forEach(arg_0 -> ((Commander)sender).sendMessage(arg_0));
    }

    private static @NonNull Pagination<Component> pagination(@NonNull String prefix) {
        return Pagination.builder().resultsPerPage(10).width(38).line(line -> line.character('-').style(Style.style((TextColor)TextColor.color((int)4704511), (TextDecoration[])new TextDecoration[]{TextDecoration.STRIKETHROUGH}))).build((Component)Components.ofChildren(new ComponentLike[]{Constants.PREFIX, Component.space(), Messages.COMMAND_PING_TEXT_PLAYER_PINGS}), (value, index) -> Collections.singleton(value), page -> String.format("/%s %d", prefix, page));
    }
}

