/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.common.command.commands;

import cloud.commandframework.Command;
import cloud.commandframework.context.CommandContext;
import cloud.commandframework.minecraft.extras.MinecraftExtrasMetaKeys;
import java.lang.management.ManagementFactory;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.checkerframework.checker.nullness.qual.NonNull;
import xyz.jpenilla.tabtps.common.Messages;
import xyz.jpenilla.tabtps.common.TabTPS;
import xyz.jpenilla.tabtps.common.command.Commander;
import xyz.jpenilla.tabtps.common.command.Commands;
import xyz.jpenilla.tabtps.common.command.TabTPSCommand;
import xyz.jpenilla.tabtps.common.config.Theme;
import xyz.jpenilla.tabtps.common.module.MemoryModule;
import xyz.jpenilla.tabtps.common.module.Module;
import xyz.jpenilla.tabtps.common.module.ModuleRenderer;
import xyz.jpenilla.tabtps.common.util.Components;
import xyz.jpenilla.tabtps.common.util.Constants;
import xyz.jpenilla.tabtps.common.util.MemoryUtil;
import xyz.jpenilla.tabtps.common.util.TPSUtil;

public final class TickInfoCommand
extends TabTPSCommand {
    private static final Function<Module, Component> MODULE_RENDERER = ModuleRenderer.standardRenderFunction(Theme.DEFAULT);
    private final ModuleRenderer cpuRenderer;
    private final ModuleRenderer memoryRenderer;
    private final Formatter formatter;

    private TickInfoCommand(@NonNull TabTPS tabTPS, @NonNull Commands commands, @NonNull Formatter formatter) {
        super(tabTPS, commands);
        this.formatter = formatter;
        this.cpuRenderer = ModuleRenderer.builder().modules(tabTPS, Theme.DEFAULT, "cpu").moduleRenderFunction(MODULE_RENDERER).build();
        this.memoryRenderer = ModuleRenderer.builder().modules(new MemoryModule(tabTPS, Theme.DEFAULT, true)).moduleRenderFunction(MODULE_RENDERER).build();
    }

    @Override
    public void register() {
        this.commands.register((Command.Builder<Commander>)this.commandManager.commandBuilder("tickinfo", new String[]{"mspt", "tps"}).permission("tabtps.tps").meta(MinecraftExtrasMetaKeys.DESCRIPTION, (Object)Messages.COMMAND_TICKINFO_DESCRIPTION.plain(new ComponentLike[0])).handler(this::executeTickInfo));
    }

    public static @NonNull TickInfoCommand defaultFormatter(@NonNull TabTPS tabTPS, @NonNull Commands commands) {
        return TickInfoCommand.withFormatter(tabTPS, commands, new DefaultFormatter(tabTPS));
    }

    public static @NonNull TickInfoCommand withFormatter(@NonNull TabTPS tabTPS, @NonNull Commands commands, @NonNull Formatter formatter) {
        return new TickInfoCommand(tabTPS, commands, formatter);
    }

    private void executeTickInfo(@NonNull CommandContext<Commander> ctx) {
        ArrayList<Object> messages = new ArrayList<Object>();
        messages.add(Component.empty());
        messages.add(Components.ofChildren(new ComponentLike[]{Constants.PREFIX, Component.space(), Messages.COMMAND_TICKINFO_TEXT_HEADER.styled((TextColor)NamedTextColor.GRAY, TextDecoration.ITALIC, new ComponentLike[0])}));
        messages.add(this.formatTPS());
        messages.addAll(this.formatter.formatTickTimes());
        messages.add(this.cpuRenderer.render().hoverEvent((HoverEventSource)Messages.COMMAND_TICKINFO_TEXT_CPU_HOVER.styled((TextColor)NamedTextColor.GRAY, new ComponentLike[0])));
        messages.add(this.renderMemory());
        messages.add(MemoryUtil.renderBar(ManagementFactory.getMemoryMXBean().getHeapMemoryUsage(), 91));
        messages.forEach(arg_0 -> ((Commander)((Commander)ctx.getSender())).sendMessage(arg_0));
    }

    private @NonNull Component renderMemory() {
        return this.memoryRenderer.render().hoverEvent((HoverEventSource)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append((ComponentLike)Messages.COMMAND_TICKINFO_TEXT_MEMORY_HOVER)).append((Component)Component.newline())).append((ComponentLike)Messages.LABEL_USED)).append((Component)Component.text((String)"/", (TextColor)NamedTextColor.WHITE))).append((ComponentLike)Messages.LABEL_ALLOCATED)).append((Component)Component.space())).append((Component)Component.text((String)"(", (TextColor)NamedTextColor.WHITE))).append((ComponentLike)Messages.LABEL_MAXIMUM)).append((Component)Component.text((String)")", (TextColor)NamedTextColor.WHITE))).build());
    }

    private @NonNull Component formatTPS() {
        ArrayDeque<String> tpsDurations;
        double[] tps = this.tabTPS.platform().tickTimeService().recentTps();
        TextComponent.Builder builder = (TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().hoverEvent((HoverEventSource)Messages.COMMAND_TICKINFO_TEXT_TPS_HOVER.styled((TextColor)NamedTextColor.GRAY, new ComponentLike[0]))).append((Component)Messages.LABEL_TPS.styled((TextColor)NamedTextColor.GRAY, new ComponentLike[0]))).append((Component)Component.text((String)":", (TextColor)NamedTextColor.WHITE))).append((Component)Component.space());
        PrimitiveIterator.OfDouble tpsIterator = Arrays.stream(tps).iterator();
        ArrayDeque<String> arrayDeque = tpsDurations = tps.length == 4 ? new ArrayDeque<String>(Arrays.asList("5s", "1m", "5m", "15m")) : new ArrayDeque<String>(Arrays.asList("1m", "5m", "15m"));
        while (tpsIterator.hasNext()) {
            ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)builder.append(TPSUtil.coloredTps((Double)tpsIterator.next(), Theme.DEFAULT.colorScheme()))).append((Component)Component.space())).append((Component)Component.text((String)"(", (TextColor)NamedTextColor.GRAY, (TextDecoration[])new TextDecoration[]{TextDecoration.ITALIC}))).append((Component)Component.text((String)((String)tpsDurations.removeFirst()), (TextColor)NamedTextColor.GRAY, (TextDecoration[])new TextDecoration[]{TextDecoration.ITALIC}))).append((Component)Component.text((String)")", (TextColor)NamedTextColor.GRAY, (TextDecoration[])new TextDecoration[]{TextDecoration.ITALIC}));
            if (!tpsIterator.hasNext()) continue;
            ((TextComponent.Builder)builder.append((Component)Component.text((String)",", (TextColor)NamedTextColor.WHITE))).append((Component)Component.space());
        }
        return builder.build();
    }

    public static interface Formatter {
        public @NonNull List<Component> formatTickTimes();
    }

    private static final class DefaultFormatter
    implements Formatter {
        private final ModuleRenderer msptRenderer;

        DefaultFormatter(@NonNull TabTPS tabTPS) {
            this.msptRenderer = ModuleRenderer.builder().modules(tabTPS, Theme.DEFAULT, "mspt").moduleRenderFunction(MODULE_RENDERER).build();
        }

        @Override
        public @NonNull List<Component> formatTickTimes() {
            return Collections.singletonList(this.msptRenderer.render().hoverEvent((HoverEventSource)Messages.COMMAND_TICKINFO_TEXT_MSPT_HOVER.styled((TextColor)NamedTextColor.GRAY, new ComponentLike[0])));
        }
    }
}

