/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.common.config;

import cloud.commandframework.minecraft.extras.MinecraftHelp;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Comment;

@ConfigSerializable
public final class PluginSettings {
    @Comment(value="Should the plugin check GitHub for updates on startup?")
    private boolean updateChecker = true;
    @Comment(value="How many milliseconds in between updates")
    private UpdateRates updateRates = new UpdateRates();
    @Comment(value="These memory pools will not be displayed in the '/memory' command")
    private final Set<String> ignoredMemoryPools = new HashSet<String>(Arrays.asList("Metaspace", "Code Cache", "Compressed Class Space", "Non-Heap Memory Usage", "CodeHeap 'non-nmethods'", "CodeHeap 'non-profiled nmethods'", "CodeHeap 'profiled nmethods'"));
    @Comment(value="A player may only have a single display config active at once, even if they have permissions for multiple\nThis list allows defining the order in which permissions will be checked")
    private final Set<String> permissionPriorities = new LinkedHashSet<String>();
    @Comment(value="Colors used in the command help menus")
    private HelpColors helpColors = new HelpColors();

    public @NonNull HelpColors helpColors() {
        return this.helpColors;
    }

    public @NonNull Set<String> ignoredMemoryPools() {
        return this.ignoredMemoryPools;
    }

    public @NonNull UpdateRates updateRates() {
        return this.updateRates;
    }

    public @NonNull Set<String> permissionPriorities() {
        return this.permissionPriorities;
    }

    public boolean updateChecker() {
        return this.updateChecker;
    }

    @ConfigSerializable
    public static final class UpdateRates {
        private int tab = 250;
        private int actionBar = 250;
        private int bossBar = 250;

        public int tab() {
            return this.tab;
        }

        public int actionBar() {
            return this.actionBar;
        }

        public int bossBar() {
            return this.bossBar;
        }
    }

    @ConfigSerializable
    public static final class HelpColors {
        private TextColor primary = TextColor.color((int)41983);
        private TextColor highlight = NamedTextColor.WHITE;
        private TextColor alternateHighlight = TextColor.color((int)2641919);
        private TextColor text = NamedTextColor.GRAY;
        private TextColor accent = NamedTextColor.DARK_GRAY;

        public // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull MinecraftHelp.HelpColors toCloud() {
            return MinecraftHelp.HelpColors.of((TextColor)this.primary, (TextColor)this.highlight, (TextColor)this.alternateHighlight, (TextColor)this.text, (TextColor)this.accent);
        }
    }
}

