/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.common.config;

import java.util.Objects;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Comment;

@ConfigSerializable
public final class Theme {
    public static final Theme DEFAULT = new Theme();
    @Comment(value="The color scheme to use for this theme. Named text colors or Hex colors may be used.\n   Hex color format: \"#FFFFFF\"\n   Named text color format: \"color_name\"\n   For a list of named text colors, refer to the Minecraft wiki: https://minecraft.gamepedia.com/Formatting_codes#Color_codes")
    private Colors colorScheme = new Colors();

    public @NonNull Colors colorScheme() {
        return this.colorScheme;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Theme theme = (Theme)o;
        return this.colorScheme.equals(theme.colorScheme);
    }

    public int hashCode() {
        return Objects.hash(this.colorScheme);
    }

    @ConfigSerializable
    public static final class Colors {
        private TextColor text = NamedTextColor.GRAY;
        private TextColor textSecondary = NamedTextColor.WHITE;
        private TextColor lowPerformance = NamedTextColor.RED;
        private TextColor lowPerformanceSecondary = NamedTextColor.GOLD;
        private TextColor mediumPerformance = NamedTextColor.GOLD;
        private TextColor mediumPerformanceSecondary = NamedTextColor.YELLOW;
        private TextColor goodPerformance = NamedTextColor.GREEN;
        private TextColor goodPerformanceSecondary = NamedTextColor.DARK_GREEN;

        public TextColor text() {
            return this.text;
        }

        public TextColor textSecondary() {
            return this.textSecondary;
        }

        public @NonNull TextColor lowPerformance() {
            return this.lowPerformance;
        }

        public @NonNull TextColor lowPerformanceSecondary() {
            return this.lowPerformanceSecondary;
        }

        public @NonNull TextColor mediumPerformance() {
            return this.mediumPerformance;
        }

        public @NonNull TextColor mediumPerformanceSecondary() {
            return this.mediumPerformanceSecondary;
        }

        public @NonNull TextColor goodPerformance() {
            return this.goodPerformance;
        }

        public @NonNull TextColor goodPerformanceSecondary() {
            return this.goodPerformanceSecondary;
        }
    }
}

