/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.tabtps.common.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class RollingAverage {
    public static final int TPS = 20;
    public static final int SAMPLE_INTERVAL = 20;
    public static final long SEC_IN_NANO = 1000000000L;
    public static final int TICK_TIME = 50000000;
    public static final BigDecimal TPS_BASE = new BigDecimal("1E9").multiply(new BigDecimal(20));
    private final int size;
    private final BigDecimal[] samples;
    private final long[] times;
    private long time;
    private BigDecimal total;
    private int index = 0;

    public RollingAverage(int size) {
        this.size = size;
        this.samples = new BigDecimal[size];
        this.times = new long[size];
        this.time = (long)size * 1000000000L;
        this.total = RollingAverage.dec(20L).multiply(RollingAverage.dec(1000000000L)).multiply(RollingAverage.dec(size));
        for (int i = 0; i < size; ++i) {
            this.samples[i] = RollingAverage.dec(20L);
            this.times[i] = 1000000000L;
        }
    }

    private static @NonNull BigDecimal dec(long t) {
        return new BigDecimal(t);
    }

    public void add(@NonNull BigDecimal x, long t) {
        this.time -= this.times[this.index];
        this.total = this.total.subtract(this.samples[this.index].multiply(RollingAverage.dec(this.times[this.index])));
        this.samples[this.index] = x;
        this.times[this.index] = t;
        this.time += t;
        this.total = this.total.add(x.multiply(RollingAverage.dec(t)));
        if (++this.index == this.size) {
            this.index = 0;
        }
    }

    public double average() {
        return this.total.divide(RollingAverage.dec(this.time), 30, RoundingMode.HALF_UP).doubleValue();
    }
}

