/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.serialization.format.edm;

import io.wispforest.owo.serialization.format.edm.EdmMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class EdmElement<T> {
    private final T value;
    private final Type type;

    EdmElement(T value, Type type) {
        this.value = value;
        this.type = type;
    }

    public T value() {
        return this.value;
    }

    public <V> V cast() {
        return (V)this.value;
    }

    public Type type() {
        return this.type;
    }

    public Object unwrap() {
        T t = this.value;
        if (t instanceof List) {
            List list = (List)t;
            return list.stream().map(o -> ((EdmElement)o).unwrap()).toList();
        }
        t = this.value;
        if (t instanceof Map) {
            Map map = (Map)t;
            return map.entrySet().stream().map(entry -> Map.entry(entry.getKey(), ((EdmElement)entry.getValue()).unwrap())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        t = this.value;
        if (t instanceof Optional) {
            Optional optional = (Optional)t;
            return optional.map(o -> ((EdmElement)o).unwrap());
        }
        return this.value;
    }

    public EdmMap asMap() {
        if (this.type != Type.MAP) {
            throw new IllegalStateException("Cannot cast EDM element of type " + this.type + " to MAP");
        }
        return new EdmMap((EdmElement)this.cast());
    }

    public String toString() {
        return "E(" + this.type.name() + ", " + this.value + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EdmElement)) {
            return false;
        }
        EdmElement that = (EdmElement)o;
        if (!this.value.equals(that.value)) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.value.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public static EdmElement<Byte> wrapByte(byte value) {
        return new EdmElement<Byte>(value, Type.BYTE);
    }

    public static EdmElement<Short> wrapShort(short value) {
        return new EdmElement<Short>(value, Type.SHORT);
    }

    public static EdmElement<Integer> wrapInt(int value) {
        return new EdmElement<Integer>(value, Type.INT);
    }

    public static EdmElement<Long> wrapLong(long value) {
        return new EdmElement<Long>(value, Type.LONG);
    }

    public static EdmElement<Float> wrapFloat(float value) {
        return new EdmElement<Float>(Float.valueOf(value), Type.FLOAT);
    }

    public static EdmElement<Double> wrapDouble(double value) {
        return new EdmElement<Double>(value, Type.DOUBLE);
    }

    public static EdmElement<Boolean> wrapBoolean(boolean value) {
        return new EdmElement<Boolean>(value, Type.BOOLEAN);
    }

    public static EdmElement<String> wrapString(String value) {
        return new EdmElement<String>(value, Type.STRING);
    }

    public static EdmElement<byte[]> wrapBytes(byte[] value) {
        return new EdmElement<byte[]>(value, Type.BYTE);
    }

    public static EdmElement<Optional<EdmElement<?>>> wrapOptional(Optional<EdmElement<?>> value) {
        return new EdmElement(value, Type.OPTIONAL);
    }

    public static EdmElement<List<EdmElement<?>>> wrapSequence(List<EdmElement<?>> value) {
        return new EdmElement(value, Type.SEQUENCE);
    }

    public static EdmElement<Map<String, EdmElement<?>>> wrapMap(Map<String, EdmElement<?>> value) {
        return new EdmElement(value, Type.MAP);
    }

    public static enum Type {
        BYTE,
        SHORT,
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        BOOLEAN,
        STRING,
        BYTES,
        OPTIONAL,
        SEQUENCE,
        MAP;

    }
}

