/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.serialization.format.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.wispforest.owo.serialization.Deserializer;
import io.wispforest.owo.serialization.Endec;
import io.wispforest.owo.serialization.SelfDescribedDeserializer;
import io.wispforest.owo.serialization.SerializationAttribute;
import io.wispforest.owo.serialization.Serializer;
import io.wispforest.owo.serialization.format.json.JsonEndec;
import io.wispforest.owo.serialization.util.RecursiveDeserializer;
import java.math.BigDecimal;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class JsonDeserializer
extends RecursiveDeserializer<JsonElement>
implements SelfDescribedDeserializer<JsonElement> {
    private static final Set<SerializationAttribute> ATTRIBUTES = EnumSet.of(SerializationAttribute.SELF_DESCRIBING, SerializationAttribute.HUMAN_READABLE);

    protected JsonDeserializer(JsonElement serialized) {
        super(serialized);
    }

    public static JsonDeserializer of(JsonElement serialized) {
        return new JsonDeserializer(serialized);
    }

    @Override
    public Set<SerializationAttribute> attributes() {
        return ATTRIBUTES;
    }

    @Override
    public byte readByte() {
        return ((JsonElement)this.getValue()).getAsByte();
    }

    @Override
    public short readShort() {
        return ((JsonElement)this.getValue()).getAsShort();
    }

    @Override
    public int readInt() {
        return ((JsonElement)this.getValue()).getAsInt();
    }

    @Override
    public long readLong() {
        return ((JsonElement)this.getValue()).getAsLong();
    }

    @Override
    public float readFloat() {
        return ((JsonElement)this.getValue()).getAsFloat();
    }

    @Override
    public double readDouble() {
        return ((JsonElement)this.getValue()).getAsDouble();
    }

    @Override
    public int readVarInt() {
        return this.readInt();
    }

    @Override
    public long readVarLong() {
        return this.readLong();
    }

    @Override
    public boolean readBoolean() {
        return ((JsonElement)this.getValue()).getAsBoolean();
    }

    @Override
    public String readString() {
        return ((JsonElement)this.getValue()).getAsString();
    }

    @Override
    public byte[] readBytes() {
        List array = ((JsonElement)this.getValue()).getAsJsonArray().asList();
        byte[] result = new byte[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            result[i] = ((JsonElement)array.get(i)).getAsByte();
        }
        return result;
    }

    @Override
    public <V> Optional<V> readOptional(Endec<V> endec) {
        JsonElement value = (JsonElement)this.getValue();
        return !value.isJsonNull() ? Optional.of(endec.decode(this)) : Optional.empty();
    }

    @Override
    public <E> Deserializer.Sequence<E> sequence(Endec<E> elementEndec) {
        return new Sequence<E>(elementEndec, (JsonArray)this.getValue());
    }

    @Override
    public <V> Deserializer.Map<V> map(Endec<V> valueEndec) {
        return new Map<V>(valueEndec, (JsonObject)this.getValue());
    }

    @Override
    public Deserializer.Struct struct() {
        return new Struct((JsonObject)this.getValue());
    }

    @Override
    public <S> void readAny(Serializer<S> visitor) {
        this.decodeValue(visitor, (JsonElement)this.getValue());
    }

    private <S> void decodeValue(Serializer<S> visitor, JsonElement element) {
        block30: {
            if (element.isJsonNull()) {
                visitor.writeOptional(JsonEndec.INSTANCE, Optional.empty());
            } else if (element instanceof JsonPrimitive) {
                JsonPrimitive primitive = (JsonPrimitive)element;
                if (primitive.isString()) {
                    visitor.writeString(primitive.getAsString());
                } else if (primitive.isBoolean()) {
                    visitor.writeBoolean(primitive.getAsBoolean());
                } else {
                    BigDecimal value = primitive.getAsBigDecimal();
                    try {
                        long asLong = value.longValueExact();
                        if ((long)((byte)asLong) == asLong) {
                            visitor.writeByte(element.getAsByte());
                            break block30;
                        }
                        if ((long)((short)asLong) == asLong) {
                            visitor.writeShort(element.getAsShort());
                            break block30;
                        }
                        if ((long)((int)asLong) == asLong) {
                            visitor.writeInt(element.getAsInt());
                            break block30;
                        }
                        visitor.writeLong(asLong);
                    }
                    catch (ArithmeticException bruh) {
                        double asDouble = value.doubleValue();
                        if ((double)((float)asDouble) == asDouble) {
                            visitor.writeFloat(element.getAsFloat());
                            break block30;
                        }
                        visitor.writeDouble(asDouble);
                    }
                }
            } else if (element instanceof JsonArray) {
                JsonArray array = (JsonArray)element;
                try (Serializer.Sequence<JsonElement> sequence = visitor.sequence(Endec.of(this::decodeValue, deserializer -> null), array.size());){
                    array.forEach(sequence::element);
                }
            } else if (element instanceof JsonObject) {
                JsonObject object = (JsonObject)element;
                try (Serializer.Map<JsonElement> map = visitor.map(Endec.of(this::decodeValue, deserializer -> null), object.size());){
                    object.asMap().forEach(map::entry);
                }
            } else {
                throw new IllegalArgumentException("Non-standard, unrecognized JsonElement implementation cannot be decoded");
            }
        }
    }

    private class Sequence<V>
    implements Deserializer.Sequence<V> {
        private final Endec<V> valueEndec;
        private final Iterator<JsonElement> elements;
        private final int size;

        private Sequence(Endec<V> valueEndec, JsonArray elements) {
            this.valueEndec = valueEndec;
            this.elements = elements.iterator();
            this.size = elements.size();
        }

        @Override
        public int estimatedSize() {
            return this.size;
        }

        @Override
        public boolean hasNext() {
            return this.elements.hasNext();
        }

        @Override
        public V next() {
            return (V)JsonDeserializer.this.frame(this.elements::next, () -> this.valueEndec.decode(JsonDeserializer.this), false);
        }
    }

    private class Map<V>
    implements Deserializer.Map<V> {
        private final Endec<V> valueEndec;
        private final Iterator<Map.Entry<String, JsonElement>> entries;
        private final int size;

        private Map(Endec<V> valueEndec, JsonObject entries) {
            this.valueEndec = valueEndec;
            this.entries = entries.entrySet().iterator();
            this.size = entries.size();
        }

        @Override
        public int estimatedSize() {
            return this.size;
        }

        @Override
        public boolean hasNext() {
            return this.entries.hasNext();
        }

        @Override
        public Map.Entry<String, V> next() {
            Map.Entry<String, JsonElement> entry = this.entries.next();
            return (Map.Entry)JsonDeserializer.this.frame(entry::getValue, () -> java.util.Map.entry((String)entry.getKey(), this.valueEndec.decode(JsonDeserializer.this)), false);
        }
    }

    private class Struct
    implements Deserializer.Struct {
        private final JsonObject object;

        private Struct(JsonObject object) {
            this.object = object;
        }

        @Override
        @Nullable
        public <F> F field(String name, Endec<F> endec) {
            if (!this.object.has(name)) {
                throw new IllegalStateException("Field '" + name + "' was missing from serialized data, but no default value was provided");
            }
            return (F)JsonDeserializer.this.frame(() -> this.object.get(name), () -> endec.decode(JsonDeserializer.this), true);
        }

        @Override
        @Nullable
        public <F> F field(String name, Endec<F> endec, @Nullable F defaultValue) {
            if (!this.object.has(name)) {
                return defaultValue;
            }
            return (F)JsonDeserializer.this.frame(() -> this.object.get(name), () -> endec.decode(JsonDeserializer.this), true);
        }
    }
}

