/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.core;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.systems.RenderSystem;
import io.wispforest.owo.client.OwoClient;
import io.wispforest.owo.mixin.ui.DrawContextInvoker;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.event.WindowResizeCallback;
import io.wispforest.owo.ui.util.NinePatchTexture;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5684;
import net.minecraft.class_757;
import net.minecraft.class_8001;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector2d;

public class OwoUIDrawContext
extends class_332 {
    @Deprecated
    public static final class_2960 PANEL_TEXTURE = new class_2960("owo", "textures/gui/panel.png");
    @Deprecated
    public static final class_2960 DARK_PANEL_TEXTURE = new class_2960("owo", "textures/gui/dark_panel.png");
    @Deprecated
    public static final class_2960 PANEL_INSET_TEXTURE = new class_2960("owo", "textures/gui/panel_inset.png");
    public static final class_2960 PANEL_NINE_PATCH_TEXTURE = new class_2960("owo", "panel/default");
    public static final class_2960 DARK_PANEL_NINE_PATCH_TEXTURE = new class_2960("owo", "panel/dark");
    public static final class_2960 PANEL_INSET_NINE_PATCH_TEXTURE = new class_2960("owo", "panel/inset");
    private boolean recording = false;

    private OwoUIDrawContext(class_310 client, class_4597.class_4598 vertexConsumers) {
        super(client, vertexConsumers);
    }

    public static OwoUIDrawContext of(class_332 context) {
        OwoUIDrawContext owoContext = new OwoUIDrawContext(class_310.method_1551(), context.method_51450());
        ((DrawContextInvoker)((Object)owoContext)).owo$setScissorStack(((DrawContextInvoker)context).owo$getScissorStack());
        ((DrawContextInvoker)((Object)owoContext)).owo$setMatrices(((DrawContextInvoker)context).owo$getMatrices());
        return owoContext;
    }

    public static UtilityScreen utilityScreen() {
        return UtilityScreen.get();
    }

    public void recordQuads() {
        this.recording = true;
    }

    public boolean recording() {
        return this.recording;
    }

    public void submitQuads() {
        this.recording = false;
        class_289.method_1348().method_1350();
    }

    public void drawRectOutline(int x, int y, int width, int height, int color) {
        this.method_25294(x, y, x + width, y + 1, color);
        this.method_25294(x, y + height - 1, x + width, y + height, color);
        this.method_25294(x, y + 1, x + 1, y + height - 1, color);
        this.method_25294(x + width - 1, y + 1, x + width, y + height - 1, color);
    }

    public void drawGradientRect(int x, int y, int width, int height, int topLeftColor, int topRightColor, int bottomRightColor, int bottomLeftColor) {
        class_287 buffer = class_289.method_1348().method_1349();
        Matrix4f matrix = this.method_51448().method_23760().method_23761();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        buffer.method_22918(matrix, (float)(x + width), (float)y, 0.0f).method_39415(topRightColor).method_1344();
        buffer.method_22918(matrix, (float)x, (float)y, 0.0f).method_39415(topLeftColor).method_1344();
        buffer.method_22918(matrix, (float)x, (float)(y + height), 0.0f).method_39415(bottomLeftColor).method_1344();
        buffer.method_22918(matrix, (float)(x + width), (float)(y + height), 0.0f).method_39415(bottomRightColor).method_1344();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        class_289.method_1348().method_1350();
        RenderSystem.disableBlend();
    }

    public void drawPanel(int x, int y, int width, int height, boolean dark) {
        NinePatchTexture.draw(dark ? DARK_PANEL_NINE_PATCH_TEXTURE : PANEL_NINE_PATCH_TEXTURE, this, x, y, width, height);
    }

    public void drawSpectrum(int x, int y, int width, int height, boolean vertical) {
        class_287 buffer = class_289.method_1348().method_1349();
        Matrix4f matrix = this.method_51448().method_23760().method_23761();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        buffer.method_22918(matrix, (float)x, (float)y, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_1344();
        buffer.method_22918(matrix, (float)x, (float)(y + height), 0.0f).method_22915(vertical ? 0.0f : 1.0f, 1.0f, 1.0f, 1.0f).method_1344();
        buffer.method_22918(matrix, (float)(x + width), (float)(y + height), 0.0f).method_22915(0.0f, 1.0f, 1.0f, 1.0f).method_1344();
        buffer.method_22918(matrix, (float)(x + width), (float)y, 0.0f).method_22915(vertical ? 1.0f : 0.0f, 1.0f, 1.0f, 1.0f).method_1344();
        OwoClient.HSV_PROGRAM.use();
        class_289.method_1348().method_1350();
    }

    public void drawText(class_2561 text, float x, float y, float scale, int color) {
        this.drawText(text, x, y, scale, color, TextAnchor.TOP_LEFT);
    }

    public void drawText(class_2561 text, float x, float y, float scale, int color, TextAnchor anchorPoint) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        this.method_51448().method_22903();
        this.method_51448().method_22905(scale, scale, 1.0f);
        switch (anchorPoint) {
            case TOP_RIGHT: {
                x -= (float)textRenderer.method_27525((class_5348)text) * scale;
                break;
            }
            case BOTTOM_LEFT: {
                Objects.requireNonNull(textRenderer);
                y -= 9.0f * scale;
                break;
            }
            case BOTTOM_RIGHT: {
                x -= (float)textRenderer.method_27525((class_5348)text) * scale;
                Objects.requireNonNull(textRenderer);
                y -= 9.0f * scale;
            }
        }
        this.method_51439(textRenderer, text, (int)(x * (1.0f / scale)), (int)(y * (1.0f / scale)), color, false);
        this.method_51448().method_22909();
    }

    public void drawLine(int x1, int y1, int x2, int y2, double thiccness, Color color) {
        Vector2d offset = new Vector2d((double)(x2 - x1), (double)(y2 - y1)).perpendicular().normalize().mul(thiccness * 0.5);
        class_287 buffer = class_289.method_1348().method_1349();
        Matrix4f matrix = this.method_51448().method_23760().method_23761();
        int vColor = color.argb();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        buffer.method_22918(matrix, (float)((double)x1 + offset.x), (float)((double)y1 + offset.y), 0.0f).method_39415(vColor).method_1344();
        buffer.method_22918(matrix, (float)((double)x1 - offset.x), (float)((double)y1 - offset.y), 0.0f).method_39415(vColor).method_1344();
        buffer.method_22918(matrix, (float)((double)x2 - offset.x), (float)((double)y2 - offset.y), 0.0f).method_39415(vColor).method_1344();
        buffer.method_22918(matrix, (float)((double)x2 + offset.x), (float)((double)y2 + offset.y), 0.0f).method_39415(vColor).method_1344();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        class_289.method_1348().method_1350();
    }

    public void drawCircle(int centerX, int centerY, int segments, double radius, Color color) {
        this.drawCircle(centerX, centerY, 0.0, 360.0, segments, radius, color);
    }

    public void drawCircle(int centerX, int centerY, double angleFrom, double angleTo, int segments, double radius, Color color) {
        Preconditions.checkArgument((angleFrom < angleTo ? 1 : 0) != 0, (Object)"angleFrom must be less than angleTo");
        class_287 buffer = class_289.method_1348().method_1349();
        Matrix4f matrix = this.method_51448().method_23760().method_23761();
        double angleStep = Math.toRadians(angleTo - angleFrom) / (double)segments;
        int vColor = color.argb();
        buffer.method_1328(class_293.class_5596.field_27381, class_290.field_1576);
        buffer.method_22918(matrix, (float)centerX, (float)centerY, 0.0f).method_39415(vColor).method_1344();
        for (int i = segments; i >= 0; --i) {
            double theta = Math.toRadians(angleFrom) + (double)i * angleStep;
            buffer.method_22918(matrix, (float)((double)centerX - Math.cos(theta) * radius), (float)((double)centerY - Math.sin(theta) * radius), 0.0f).method_39415(vColor).method_1344();
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        class_289.method_1348().method_1350();
    }

    public void drawRing(int centerX, int centerY, int segments, double innerRadius, double outerRadius, Color innerColor, Color outerColor) {
        this.drawRing(centerX, centerY, 0.0, 360.0, segments, innerRadius, outerRadius, innerColor, outerColor);
    }

    public void drawRing(int centerX, int centerY, double angleFrom, double angleTo, int segments, double innerRadius, double outerRadius, Color innerColor, Color outerColor) {
        Preconditions.checkArgument((angleFrom < angleTo ? 1 : 0) != 0, (Object)"angleFrom must be less than angleTo");
        Preconditions.checkArgument((innerRadius < outerRadius ? 1 : 0) != 0, (Object)"innerRadius must be less than outerRadius");
        class_287 buffer = class_289.method_1348().method_1349();
        Matrix4f matrix = this.method_51448().method_23760().method_23761();
        double angleStep = Math.toRadians(angleTo - angleFrom) / (double)segments;
        int inColor = innerColor.argb();
        int outColor = outerColor.argb();
        buffer.method_1328(class_293.class_5596.field_27380, class_290.field_1576);
        for (int i = 0; i <= segments; ++i) {
            double theta = Math.toRadians(angleFrom) + (double)i * angleStep;
            buffer.method_22918(matrix, (float)((double)centerX - Math.cos(theta) * outerRadius), (float)((double)centerY - Math.sin(theta) * outerRadius), 0.0f).method_39415(outColor).method_1344();
            buffer.method_22918(matrix, (float)((double)centerX - Math.cos(theta) * innerRadius), (float)((double)centerY - Math.sin(theta) * innerRadius), 0.0f).method_39415(inColor).method_1344();
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        class_289.method_1348().method_1350();
    }

    public void drawTooltip(class_327 textRenderer, int x, int y, List<class_5684> components) {
        ((DrawContextInvoker)((Object)this)).owo$renderTooltipFromComponents(textRenderer, components, x, y, class_8001.field_41687);
    }

    public void drawInsets(int x, int y, int width, int height, Insets insets, int color) {
        this.method_25294(x - insets.left(), y - insets.top(), x + width + insets.right(), y, color);
        this.method_25294(x - insets.left(), y + height, x + width + insets.right(), y + height + insets.bottom(), color);
        this.method_25294(x - insets.left(), y, x, y + height, color);
        this.method_25294(x + width, y, x + width + insets.right(), y + height, color);
    }

    public void drawInspector(ParentComponent root, double mouseX, double mouseY, boolean onlyHovered) {
        RenderSystem.disableDepthTest();
        class_310 client = class_310.method_1551();
        class_327 textRenderer = client.field_1772;
        ArrayList<Component> children = new ArrayList<Component>();
        if (!onlyHovered) {
            root.collectDescendants(children);
        } else if (root.childAt((int)mouseX, (int)mouseY) != null) {
            children.add(root.childAt((int)mouseX, (int)mouseY));
        }
        for (Component child : children) {
            if (child instanceof ParentComponent) {
                ParentComponent parentComponent = (ParentComponent)child;
                this.drawInsets(parentComponent.x(), parentComponent.y(), parentComponent.width(), parentComponent.height(), ((Insets)parentComponent.padding().get()).inverted(), -1492325155);
            }
            Insets margins = (Insets)child.margins().get();
            this.drawInsets(child.x(), child.y(), child.width(), child.height(), margins, -1476398280);
            this.drawRectOutline(child.x(), child.y(), child.width(), child.height(), -12930817);
            if (!onlyHovered) continue;
            int inspectorX = child.x() + 1;
            int inspectorY = child.y() + child.height() + ((Insets)child.margins().get()).bottom() + 1;
            Objects.requireNonNull(textRenderer);
            int inspectorHeight = 9 * 2 + 4;
            if (inspectorY > client.method_22683().method_4502() - inspectorHeight) {
                if ((inspectorY -= child.fullSize().height() + inspectorHeight + 1) < 0) {
                    inspectorY = 1;
                }
                if (child instanceof ParentComponent) {
                    ParentComponent parentComponent = (ParentComponent)child;
                    inspectorX += ((Insets)parentComponent.padding().get()).left();
                    inspectorY += ((Insets)parentComponent.padding().get()).top();
                }
            }
            class_2561 nameText = class_2561.method_30163((String)(child.getClass().getSimpleName() + (String)(child.id() != null ? " '" + child.id() + "'" : "")));
            class_5250 descriptor = class_2561.method_43470((String)(child.x() + "," + child.y() + " (" + child.width() + "," + child.height() + ") <" + margins.top() + "," + margins.bottom() + "," + margins.left() + "," + margins.right() + "> "));
            if (child instanceof ParentComponent) {
                ParentComponent parentComponent = (ParentComponent)child;
                Insets padding = (Insets)parentComponent.padding().get();
                descriptor.method_27693(" >" + padding.top() + "," + padding.bottom() + "," + padding.left() + "," + padding.right() + "<");
            }
            int width = Math.max(textRenderer.method_27525((class_5348)nameText), textRenderer.method_27525((class_5348)descriptor));
            this.method_25294(inspectorX, inspectorY, inspectorX + width + 3, inspectorY + inspectorHeight, -1493172224);
            this.drawRectOutline(inspectorX, inspectorY, width + 3, inspectorHeight, -1493172224);
            this.method_51439(textRenderer, nameText, inspectorX + 2, inspectorY + 2, 0xFFFFFF, false);
            Objects.requireNonNull(textRenderer);
            this.method_51439(textRenderer, (class_2561)descriptor, inspectorX + 2, inspectorY + 9 + 2, 0xFFFFFF, false);
        }
        RenderSystem.enableDepthTest();
    }

    public static class UtilityScreen
    extends class_437 {
        private static UtilityScreen INSTANCE;
        private class_437 linkSourceScreen = null;

        private UtilityScreen() {
            super((class_2561)class_2561.method_43473());
        }

        public static UtilityScreen get() {
            if (INSTANCE == null) {
                INSTANCE = new UtilityScreen();
                class_310 client = class_310.method_1551();
                INSTANCE.method_25423(client, client.method_22683().method_4486(), client.method_22683().method_4502());
            }
            return INSTANCE;
        }

        public void setLinkSource(class_437 screen) {
            this.linkSourceScreen = screen;
        }

        public void captureLinkSource() {
            this.setLinkSource(this.field_22787.field_1755);
        }

        @ApiStatus.Internal
        @Nullable
        public class_437 getAndClearLinkSource() {
            class_437 source = this.linkSourceScreen;
            this.linkSourceScreen = null;
            return source;
        }

        public boolean method_25430(@Nullable class_2583 style) {
            return super.method_25430(style);
        }

        static {
            WindowResizeCallback.EVENT.register((client, window) -> {
                if (INSTANCE == null) {
                    return;
                }
                INSTANCE.method_25423(client, window.method_4486(), window.method_4502());
            });
        }
    }

    public static enum TextAnchor {
        TOP_RIGHT,
        BOTTOM_RIGHT,
        TOP_LEFT,
        BOTTOM_LEFT;

    }
}

