/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.brewery;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import eu.pb4.brewery.CardboardWarning;
import eu.pb4.brewery.GenericModInfo;
import eu.pb4.brewery.block.BrewBlocks;
import eu.pb4.brewery.block.BrewCauldronBlock;
import eu.pb4.brewery.block.entity.BrewBlockEntities;
import eu.pb4.brewery.compat.PolydexCompatImpl;
import eu.pb4.brewery.drink.AlcoholValueEffect;
import eu.pb4.brewery.drink.DefaultDefinitions;
import eu.pb4.brewery.drink.DrinkType;
import eu.pb4.brewery.item.BookOfBreweryItem;
import eu.pb4.brewery.item.BrewItems;
import eu.pb4.brewery.other.BrewCommands;
import eu.pb4.brewery.other.BrewGameRules;
import eu.pb4.brewery.other.BrewNetworking;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.gamerule.v1.rule.DoubleRule;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public class BreweryInit
implements ModInitializer {
    public static final String MOD_ID = "brewery";
    public static final Map<class_2960, DrinkType> DRINK_TYPES = new Object2ObjectOpenHashMap();
    public static final Map<DrinkType, class_2960> DRINK_TYPE_ID = new Reference2ObjectOpenHashMap();
    public static final List<AlcoholValueEffect.Value> ALCOHOL_EFFECTS = new ArrayList<AlcoholValueEffect.Value>();
    public static final Object2DoubleMap<class_1792> ITEM_ALCOHOL_REMOVAL_VALUES = new Object2DoubleOpenHashMap();
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final boolean IS_DEV = FabricLoader.getInstance().isDevelopmentEnvironment();
    public static final boolean DISPLAY_DEV;
    public static final boolean USE_GENERATOR;

    public static class_2960 id(String path) {
        return new class_2960(MOD_ID, path);
    }

    public void onInitialize() {
        GenericModInfo.build((ModContainer)FabricLoader.getInstance().getModContainer(MOD_ID).get());
        BrewBlocks.register();
        BrewBlockEntities.register();
        BrewItems.register();
        BrewGameRules.register();
        BrewNetworking.register();
        class_2960 id = BreweryInit.id("early_reload");
        ServerLifecycleEvents.SERVER_STARTED.addPhaseOrdering(id, Event.DEFAULT_PHASE);
        ServerLifecycleEvents.SERVER_STARTED.register(id, BreweryInit::loadDrinks);
        ServerLifecycleEvents.SERVER_STARTED.register(s -> CardboardWarning.checkAndAnnounce());
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.addPhaseOrdering(id, Event.DEFAULT_PHASE);
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register(id, (x, y, z) -> BreweryInit.loadDrinks(x));
        CommandRegistrationCallback.EVENT.register(BrewCommands::register);
        UseBlockCallback.EVENT.register(BrewCauldronBlock::handleUseEvent);
        if (FabricLoader.getInstance().isModLoaded("polydex")) {
            PolydexCompatImpl.init();
        }
    }

    public static void clearData() {
        DRINK_TYPES.clear();
        DRINK_TYPE_ID.clear();
        ITEM_ALCOHOL_REMOVAL_VALUES.clear();
        ALCOHOL_EFFECTS.clear();
    }

    public static void addDrink(class_2960 identifier, DrinkType type) {
        DRINK_TYPES.put(identifier, type);
        DRINK_TYPE_ID.put(type, identifier);
    }

    private static void loadDrinks(MinecraftServer server) {
        class_6903 ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)server.method_30611());
        BreweryInit.clearData();
        for (Map.Entry res : server.method_34864().method_14488("brewery_drinks", x -> x.method_12832().endsWith(".json")).entrySet()) {
            class_2960 id = new class_2960(((class_2960)res.getKey()).method_12836(), ((class_2960)res.getKey()).method_12832().substring("brewery_drinks/".length(), ((class_2960)res.getKey()).method_12832().length() - 5));
            try {
                Pair drinkType2 = (Pair)DrinkType.CODEC.decode((DynamicOps)ops, (Object)JsonParser.parseReader((Reader)((class_3298)res.getValue()).method_43039())).getOrThrow(false, x -> {});
                BreweryInit.addDrink(id, (DrinkType)drinkType2.getFirst());
            }
            catch (Throwable e) {
                DRINK_TYPE_ID.remove(DRINK_TYPES.remove(id));
                LOGGER.warn("{} isn't valid brewery definition!", (Object)((class_2960)res.getKey()).toString());
                e.printStackTrace();
            }
        }
        for (Map.Entry res : server.method_34864().method_14488("", x -> x.method_12832().equals("brewery_effects.json")).entrySet()) {
            try {
                AlcoholValueEffect effects = (AlcoholValueEffect)((Pair)AlcoholValueEffect.CODEC.decode((DynamicOps)ops, (Object)JsonParser.parseReader((Reader)((class_3298)res.getValue()).method_43039())).result().get()).getFirst();
                if (effects.replace()) {
                    ALCOHOL_EFFECTS.clear();
                    ITEM_ALCOHOL_REMOVAL_VALUES.clear();
                }
                ALCOHOL_EFFECTS.addAll(effects.entries());
                ITEM_ALCOHOL_REMOVAL_VALUES.putAll(effects.itemReduction());
            }
            catch (Throwable e) {
                LOGGER.warn("{} isn't valid brewery effect definition!", (Object)((class_2960)res.getKey()).toString());
                e.printStackTrace();
            }
        }
        if (USE_GENERATOR) {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            Path dir = FabricLoader.getInstance().getGameDir().resolve("../src/main/resources/data/brewery/brewery_drinks/");
            DefaultDefinitions.createBrews((key, drinkType) -> {
                class_2960 id = new class_2960("brewery:" + key);
                BreweryInit.addDrink(id, drinkType);
                try {
                    Files.writeString(dir.resolve(key + ".json"), (CharSequence)gson.toJson((JsonElement)DrinkType.CODEC.encodeStart((DynamicOps)ops, drinkType).getOrThrow(false, x -> {})), new OpenOption[0]);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            });
            AlcoholValueEffect effects = DefaultDefinitions.createEffects(server);
            if (effects.replace()) {
                ALCOHOL_EFFECTS.clear();
            }
            ALCOHOL_EFFECTS.addAll(effects.entries());
            try {
                Files.writeString(FabricLoader.getInstance().getGameDir().resolve("../src/main/resources/data/brewery/brewery_effects.json"), (CharSequence)gson.toJson((JsonElement)AlcoholValueEffect.CODEC.encodeStart((DynamicOps)ops, (Object)effects).result().get()), new OpenOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        BookOfBreweryItem.build(DRINK_TYPES.entrySet(), ((DoubleRule)server.method_30002().method_8450().method_20746(BrewGameRules.BARREL_AGING_MULTIPLIER)).get(), ((DoubleRule)server.method_30002().method_8450().method_20746(BrewGameRules.CAULDRON_COOKING_TIME_MULTIPLIER)).get());
        BrewItems.ITEM_GROUP.method_47306(new class_1761.class_8128(server.method_30002().method_45162(), false, (class_7225.class_7874)server.method_30611()));
    }

    static {
        if (IS_DEV) {
            // empty if block
        }
        DISPLAY_DEV = false;
        USE_GENERATOR = IS_DEV;
    }
}

