/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.brewery.block.entity;

import eu.pb4.brewery.BreweryInit;
import eu.pb4.brewery.block.BarrelMaterial;
import eu.pb4.brewery.block.BrewBlocks;
import eu.pb4.brewery.block.entity.BrewBlockEntities;
import eu.pb4.brewery.block.entity.TickableContents;
import eu.pb4.brewery.drink.DrinkType;
import eu.pb4.brewery.drink.DrinkUtils;
import eu.pb4.brewery.item.BrewItems;
import eu.pb4.brewery.item.IngredientMixtureItem;
import eu.pb4.brewery.other.BrewGameRules;
import eu.pb4.sgui.api.gui.SimpleGui;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.gamerule.v1.rule.DoubleRule;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2501;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import org.jetbrains.annotations.Nullable;

public final class BrewBarrelSpigotBlockEntity
extends class_2621
implements TickableContents,
class_1278 {
    private static final int[] SLOTS = IntStream.range(0, 27).toArray();
    private final LongSet parts = new LongArraySet();
    private class_2371<class_1799> inventory;
    private long lastTicked = -1L;
    private int loadedTime;
    private boolean requestUpdate;
    private BarrelMaterial material = BarrelMaterial.EMPTY;

    public BrewBarrelSpigotBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(BrewBlockEntities.BARREL_SPIGOT, blockPos, blockState);
        this.inventory = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
    }

    public static <T extends class_2586> void ticker(class_1937 world, class_2338 pos, class_2680 state, T t) {
        if (!(t instanceof BrewBarrelSpigotBlockEntity)) {
            return;
        }
        BrewBarrelSpigotBlockEntity barrel = (BrewBarrelSpigotBlockEntity)t;
        ++barrel.loadedTime;
        if (barrel.requestUpdate && world.method_8510() % 20L == 0L) {
            barrel.updateAges();
        }
    }

    private void requestUpdate() {
        this.requestUpdate = true;
    }

    public void updateAges() {
        long currentTime = this.field_11863.method_8510();
        if (this.lastTicked == -1L) {
            this.lastTicked = this.field_11863.method_8510();
            return;
        }
        double agingMultiplier = ((DoubleRule)this.field_11863.method_8450().method_20746(BrewGameRules.BARREL_AGING_MULTIPLIER)).get();
        this.tickContents(this.field_11863.method_8450().method_8355(BrewGameRules.AGE_UNLOADED) ? (double)(currentTime - this.lastTicked) * agingMultiplier : (double)this.loadedTime * agingMultiplier);
        this.lastTicked = currentTime;
        this.loadedTime = 0;
        this.requestUpdate = false;
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        if (!this.method_54872(nbt)) {
            class_1262.method_5426((class_2487)nbt, this.inventory);
        }
        nbt.method_10566("Parts", (class_2520)new class_2501(this.parts));
        nbt.method_10582("BarrelType", this.material.type().toString());
        nbt.method_10544("LastTicked", this.lastTicked);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.inventory = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        if (!this.method_54871(nbt)) {
            class_1262.method_5429((class_2487)nbt, this.inventory);
        }
        this.parts.clear();
        for (long part : nbt.method_10565("Parts")) {
            this.parts.add(part);
        }
        this.material = BrewBlocks.BARREL_MATERIAL_MAP.get(new class_2960(nbt.method_10558("BarrelType")));
        this.lastTicked = nbt.method_10537("LastTicked");
    }

    @Override
    public void tickContents(double l) {
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 stack = this.method_5438(i);
            if (stack.method_7960() || !stack.method_31574(BrewItems.INGREDIENT_MIXTURE) && !stack.method_31574((class_1792)BrewItems.DRINK_ITEM)) continue;
            double age = DrinkUtils.getAgeInTicks(stack, 0.0) + l;
            double ageSec = age / 20.0;
            DrinkType oldType = DrinkUtils.getType(stack);
            if (oldType == null && stack.method_7948().method_10545("BrewType")) continue;
            List<class_1799> ingredients = IngredientMixtureItem.getIngredients(stack);
            List<DrinkType> types = DrinkUtils.findTypes(ingredients, this.material.type(), DrinkUtils.getHeatSource(stack));
            if (types.isEmpty() && oldType == null) {
                this.method_5447(i, new class_1799((class_1935)BrewItems.FAILED_DRINK_ITEM));
                continue;
            }
            double quality = -1.0;
            DrinkType match = null;
            for (DrinkType type : types) {
                DrinkType.BarrelInfo barrelInfo = type.getBarrelInfo(this.material.type());
                if (!(ageSec >= (double)barrelInfo.baseTime())) continue;
                double newAge = ageSec - (double)barrelInfo.baseTime();
                double q = barrelInfo.qualityChange().expression().setVariable("quality", type.baseQuality().expression().setVariable("age", newAge).evaluate()).setVariable("age", newAge).evaluate();
                if (!(q > quality)) continue;
                quality = q;
                match = type;
            }
            if (match == null && oldType != null) {
                match = oldType;
            }
            if (match == null) {
                stack.method_7948().method_10549("BrewAge", age);
                continue;
            }
            if (quality < 0.0) {
                this.method_5447(i, new class_1799((class_1935)BrewItems.FAILED_DRINK_ITEM));
                continue;
            }
            if (stack.method_31574(BrewItems.INGREDIENT_MIXTURE)) {
                class_1799 nStack = new class_1799((class_1935)BrewItems.DRINK_ITEM);
                nStack.method_7980(stack.method_7969());
                stack = nStack;
                this.method_5447(i, stack);
            }
            stack.method_7948().method_10549("BrewAge", age);
            stack.method_7948().method_10582("BrewType", BreweryInit.DRINK_TYPE_ID.get(match).toString());
            DrinkType.BarrelInfo barrelInfo = match.getBarrelInfo(this.material.type());
            if (barrelInfo == null) continue;
            stack.method_7948().method_10582("BrewBarrelType", this.material.type().toString());
            double mult = match.cookingQualityMult().expression().setVariable("age", stack.method_7969().method_10574("BrewCookAge") / 20.0).evaluate();
            if (quality * mult >= 0.0) {
                stack.method_7969().method_10549("BrewQuality", Math.min(quality * mult, 10.0));
                continue;
            }
            this.method_5447(i, new class_1799((class_1935)BrewItems.FAILED_DRINK_ITEM));
        }
    }

    protected class_2561 method_17823() {
        return this.material.name();
    }

    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return null;
    }

    protected class_2371<class_1799> method_11282() {
        return this.inventory;
    }

    protected void method_11281(class_2371<class_1799> list) {
        this.inventory = list;
    }

    public int method_5439() {
        return 27;
    }

    public void addPart(class_2338 pos) {
        this.parts.add(pos.method_10063());
        this.method_5431();
    }

    public LongSet getParts() {
        return this.parts;
    }

    public Iterable<class_2338.class_2339> iterableParts() {
        final class_2338.class_2339 pos = new class_2338.class_2339();
        return () -> new Iterator<class_2338.class_2339>(){
            final LongIterator iter;
            {
                this.iter = BrewBarrelSpigotBlockEntity.this.parts.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public class_2338.class_2339 next() {
                long val = this.iter.nextLong();
                return pos.method_10103(class_2338.method_10061((long)val), class_2338.method_10071((long)val), class_2338.method_10083((long)val));
            }
        };
    }

    public void setBarrelType(BarrelMaterial material) {
        this.material = material;
    }

    public void openGui(class_3222 player) {
        this.updateAges();
        new Gui(player);
    }

    public int[] method_5494(class_2350 side) {
        return SLOTS;
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return this.canInsert(stack);
    }

    public boolean canInsert(class_1799 stack) {
        if (stack.method_31574((class_1792)BrewItems.DRINK_ITEM)) {
            DrinkType type = DrinkUtils.getType(stack);
            String barrelType = DrinkUtils.getBarrelType(stack);
            return type != null && !type.barrelInfo().isEmpty() && (barrelType.isEmpty() || barrelType.equals(this.material.type()) || DrinkUtils.getAgeInTicks(stack) <= 0.0);
        }
        return stack.method_31574(BrewItems.INGREDIENT_MIXTURE);
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return true;
    }

    private class Gui
    extends SimpleGui {
        public Gui(class_3222 player) {
            super(class_3917.field_17326, player, false);
            this.setTitle(BrewBarrelSpigotBlockEntity.this.method_5476());
            for (int i = 0; i < BrewBarrelSpigotBlockEntity.this.method_5439(); ++i) {
                this.setSlotRedirect(i, new class_1735((class_1263)BrewBarrelSpigotBlockEntity.this, i, 0, 0){

                    public boolean method_7680(class_1799 stack) {
                        return BrewBarrelSpigotBlockEntity.this.canInsert(stack);
                    }

                    public int method_7675() {
                        return 1;
                    }

                    public int method_7676(class_1799 stack) {
                        return 1;
                    }
                });
            }
            this.open();
        }

        public void onTick() {
            if (BrewBarrelSpigotBlockEntity.this.method_11015() || BrewBarrelSpigotBlockEntity.this.method_11016().method_10268(this.player.method_23317(), this.player.method_23318(), this.player.method_23321()) > 400.0) {
                this.close();
            }
            BrewBarrelSpigotBlockEntity.this.requestUpdate();
            super.onTick();
        }
    }
}

