/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.brewery.block.entity;

import eu.pb4.brewery.BreweryInit;
import eu.pb4.brewery.block.BrewCauldronBlock;
import eu.pb4.brewery.block.entity.BrewBlockEntities;
import eu.pb4.brewery.block.entity.TickableContents;
import eu.pb4.brewery.drink.DrinkType;
import eu.pb4.brewery.drink.DrinkUtils;
import eu.pb4.brewery.item.BrewItems;
import eu.pb4.brewery.other.BrewGameRules;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.ChunkAttachment;
import eu.pb4.polymer.virtualentity.api.elements.TextDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.gamerule.v1.rule.DoubleRule;
import net.minecraft.class_1268;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import net.minecraft.class_5556;
import net.minecraft.class_7923;
import org.joml.Matrix4f;

public class BrewCauldronBlockEntity
extends class_2586
implements TickableContents {
    private class_2499 inventory = new class_2499();
    private long lastTicked = -1L;
    private double timeCooking = 0.0;
    private ElementHolder elementHolder;
    private TextDisplayElement[] textDisplayElement = new TextDisplayElement[4];

    public BrewCauldronBlockEntity(class_2338 pos, class_2680 state) {
        super(BrewBlockEntities.CAULDRON, pos, state);
    }

    public static <T extends class_2586> void ticker(class_1937 world, class_2338 pos, class_2680 state, T t) {
        if (t instanceof BrewCauldronBlockEntity) {
            BrewCauldronBlockEntity cauldron = (BrewCauldronBlockEntity)t;
            if (world instanceof class_3218) {
                class_3218 world1 = (class_3218)world;
                long currentTime = world.method_8510();
                if (cauldron.lastTicked == -1L) {
                    cauldron.lastTicked = currentTime;
                    return;
                }
                if (cauldron.elementHolder == null) {
                    cauldron.elementHolder = new ElementHolder();
                    Matrix4f matrix = new Matrix4f();
                    int seconds = (int)(cauldron.timeCooking / 20.0) % 60;
                    int minutes = (int)(cauldron.timeCooking / 1200.0);
                    class_5250 text = class_2561.method_43470((String)(minutes + ":" + (seconds < 10 ? "0" : "") + seconds));
                    for (int i = 0; i < 4; ++i) {
                        TextDisplayElement element = cauldron.textDisplayElement[i] = new TextDisplayElement();
                        element.setTransformation(matrix.rotationY((float)i * 1.5707964f).translate(0.0f, -0.14f, 0.51f));
                        element.setDisplayHeight(1.0f);
                        element.setDisplayWidth(1.0f);
                        element.setText((class_2561)text);
                        element.setViewRange(0.3f);
                        cauldron.elementHolder.addElement((VirtualElement)element);
                    }
                    ChunkAttachment.of((ElementHolder)cauldron.elementHolder, (class_3218)world1, (class_2338)cauldron.field_11867);
                }
                if (BrewCauldronBlock.isValid(pos, state, world)) {
                    cauldron.timeCooking = cauldron.timeCooking + (world.method_8450().method_8355(BrewGameRules.AGE_UNLOADED) ? (double)(currentTime - cauldron.lastTicked) : 1.0);
                    world1.method_14199((class_2394)class_2398.field_11241, 0.4 * (double)world.field_9229.method_43057(), (6.0 + (double)((Integer)state.method_11654((class_2769)class_5556.field_27206)).intValue() * 3.0) / 16.0, 0.4 * (double)world.field_9229.method_43057(), 0, 0.0, 0.0, 0.0, 0.0);
                    if (cauldron.timeCooking % 20.0 == 0.0) {
                        int seconds = (int)(cauldron.timeCooking / 20.0) % 60;
                        int minutes = (int)(cauldron.timeCooking / 1200.0);
                        class_5250 text = class_2561.method_43470((String)(minutes + ":" + (seconds < 10 ? "0" : "") + seconds));
                        for (int i = 0; i < 4; ++i) {
                            cauldron.textDisplayElement[i].setText((class_2561)text);
                        }
                        cauldron.elementHolder.tick();
                    }
                }
                cauldron.lastTicked = currentTime;
            }
        }
    }

    public void method_11012() {
        super.method_11012();
        if (this.elementHolder != null) {
            this.elementHolder.destroy();
        }
        this.elementHolder = null;
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10544("LastTicked", this.lastTicked);
        nbt.method_10566("Ingredients", (class_2520)this.inventory);
        nbt.method_10549("CookingTime", this.timeCooking);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.lastTicked = nbt.method_10537("LastTicked");
        this.inventory = nbt.method_10554("Ingredients", 10);
        this.timeCooking = nbt.method_10574("CookingTime");
    }

    public void addIngredients(List<class_1542> entities) {
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        for (class_1542 entity : entities) {
            if (!entity.method_6983().method_7960()) {
                items.add(entity.method_6983());
            }
            entity.method_31472();
        }
        for (class_1799 item : items) {
            this.inventory.add((Object)item.method_7953(new class_2487()));
        }
    }

    public boolean onUse(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!stack.method_7960() && stack.method_31574(class_1802.field_8469)) {
            stack.method_7934(1);
            double agingMultiplier = ((DoubleRule)this.field_11863.method_8450().method_20746(BrewGameRules.CAULDRON_COOKING_TIME_MULTIPLIER)).get();
            ArrayList<class_1799> ingredients = new ArrayList<class_1799>();
            for (class_2520 nbt : this.inventory) {
                ingredients.add(class_1799.method_7915((class_2487)((class_2487)nbt)));
            }
            class_2248 heatSource = this.method_10997().method_8320(this.field_11867.method_10074()).method_26204();
            List<DrinkType> types = DrinkUtils.findTypes(ingredients, null, heatSource);
            double age = this.timeCooking * agingMultiplier;
            double quality = Double.MIN_VALUE;
            DrinkType match = null;
            for (DrinkType type : types) {
                double q;
                if (type.requireDistillation() || !((q = type.cookingQualityMult().expression().setVariable("age", age / 20.0).evaluate()) > quality)) continue;
                quality = q;
                match = type;
            }
            if (match == null || quality < 0.0) {
                class_1799 out = new class_1799((class_1935)BrewItems.INGREDIENT_MIXTURE);
                out.method_7948().method_10549("BrewCookAge", age);
                out.method_7948().method_10566("Ingredients", (class_2520)this.inventory.method_10612());
                out.method_7948().method_10582("BrewHeatSource", class_7923.field_41175.method_10221((Object)heatSource).toString());
                player.method_7270(out);
            } else {
                player.method_7270(DrinkUtils.createDrink(BreweryInit.DRINK_TYPE_ID.get(match), 0, quality * 10.0, 0, class_7923.field_41175.method_10221((Object)heatSource)));
            }
            int level = (Integer)this.method_11010().method_11654((class_2769)class_5556.field_27206) - 1;
            if (level == 0) {
                this.field_11863.method_8501(this.field_11867, class_2246.field_10593.method_9564());
            } else {
                this.field_11863.method_8501(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf(level)));
            }
            return true;
        }
        return false;
    }

    @Override
    public void tickContents(double ticksPassed) {
        this.timeCooking += ticksPassed;
    }
}

