/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.brewery.drink;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import eu.pb4.brewery.BreweryInit;
import eu.pb4.brewery.drink.AlcoholValueEffect;
import eu.pb4.brewery.drink.ConsumptionEffect;
import eu.pb4.brewery.drink.DrinkType;
import eu.pb4.brewery.duck.LivingEntityExt;
import eu.pb4.brewery.other.BrewGameRules;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.gamerule.v1.rule.DoubleRule;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;

public final class AlcoholManager {
    private final class_1309 entity;
    public double alcoholLevel = 0.0;
    public double quality = -1.0;
    private final List<DelayedEffect> delayedEffects = new ArrayList<DelayedEffect>();

    public AlcoholManager(class_1309 entity) {
        this.entity = entity;
    }

    public void drink(DrinkType type, double quality, double alcoholicValue) {
        double multiplier = ((DoubleRule)this.entity.method_37908().method_8450().method_20746(BrewGameRules.ALCOHOL_MULTIPLIER)).get();
        this.alcoholLevel = Math.max(this.alcoholLevel + alcoholicValue * multiplier, alcoholicValue * multiplier);
        this.quality = this.quality == -1.0 ? quality : (this.quality + quality) / 2.0;
    }

    public void eat(class_1799 stack) {
        if (this.alcoholLevel > 0.0) {
            this.alcoholLevel -= BreweryInit.ITEM_ALCOHOL_REMOVAL_VALUES.getDouble((Object)stack.method_7909());
        }
    }

    public static AlcoholManager of(class_1309 entity) {
        return ((LivingEntityExt)entity).brewery$getAlcoholManager();
    }

    public void writeNbt(class_2487 nbt) {
        nbt.method_10549("brewery:alcohol_level", this.alcoholLevel);
        nbt.method_10549("brewery:quality", this.quality);
        class_2499 list = new class_2499();
        for (DelayedEffect effect : this.delayedEffects) {
            list.add((Object)effect.toNbt());
        }
        nbt.method_10566("brewery:delayed_effects", (class_2520)list);
    }

    public void readNbt(class_2487 nbt) {
        this.alcoholLevel = nbt.method_10574("brewery:alcohol_level");
        this.quality = nbt.method_10574("brewery:quality");
        this.delayedEffects.clear();
        for (class_2520 effect : nbt.method_10554("brewery:delayed_effects", 10)) {
            this.delayedEffects.add(DelayedEffect.fromNbt((class_2487)effect));
        }
    }

    public void tick() {
        this.delayedEffects.removeIf(this::applyDelayedEffects);
        if (this.alcoholLevel > 0.0) {
            this.alcoholLevel -= 0.0012 * this.quality;
            double level = this.getModifiedAlcoholLevel();
            for (AlcoholValueEffect.Value effects : BreweryInit.ALCOHOL_EFFECTS) {
                if (!(level >= effects.minimumValue()) || this.entity.field_6012 % effects.rate() != 0) continue;
                for (ConsumptionEffect effect : effects.effects()) {
                    effect.apply(this.entity, 0.0, this.quality);
                }
            }
        }
    }

    private boolean applyDelayedEffects(DelayedEffect delayedEffect) {
        if (--delayedEffect.ticksLeft <= 0) {
            for (ConsumptionEffect effect : delayedEffect.effects) {
                effect.apply(this.entity, delayedEffect.age, delayedEffect.quality);
            }
            return true;
        }
        return false;
    }

    public void addDelayedEffect(int ticks, double drinkAge, double drinkQuality, List<ConsumptionEffect> effects) {
        this.delayedEffects.add(new DelayedEffect(ticks, drinkQuality, drinkAge, List.copyOf(effects)));
    }

    public double getModifiedAlcoholLevel() {
        return this.alcoholLevel - (this.quality - 8.0) * 5.0;
    }

    private static class DelayedEffect {
        public int ticksLeft;
        private final double quality;
        private final double age;
        private final List<ConsumptionEffect> effects;

        public DelayedEffect(int ticks, double quality, double age, List<ConsumptionEffect> effects) {
            this.ticksLeft = ticks;
            this.quality = quality;
            this.age = age;
            this.effects = effects;
        }

        public class_2487 toNbt() {
            class_2487 nbt = new class_2487();
            nbt.method_10569("ticks", this.ticksLeft);
            nbt.method_10549("quality", this.quality);
            nbt.method_10549("age", this.age);
            class_2499 list = new class_2499();
            for (ConsumptionEffect effect : this.effects) {
                list.add((Object)((class_2520)ConsumptionEffect.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)effect).result().get()));
            }
            nbt.method_10566("entries", (class_2520)list);
            return nbt;
        }

        public static DelayedEffect fromNbt(class_2487 nbt) {
            int ticks = nbt.method_10550("ticks");
            double quality = nbt.method_10574("quality");
            double age = nbt.method_10574("age");
            ArrayList<ConsumptionEffect> list = new ArrayList<ConsumptionEffect>();
            for (class_2520 effect : nbt.method_10554("entries", 10)) {
                Optional x = ConsumptionEffect.CODEC.decode((DynamicOps)class_2509.field_11560, (Object)effect).result();
                if (!x.isPresent()) continue;
                list.add((ConsumptionEffect)((Pair)x.get()).getFirst());
            }
            return new DelayedEffect(ticks, quality, age, list);
        }
    }
}

