/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.brewery.drink;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.pb4.brewery.drink.AlcoholManager;
import eu.pb4.brewery.drink.ExpressionUtil;
import eu.pb4.brewery.drink.WrappedExpression;
import eu.pb4.brewery.duck.StatusEffectInstanceExt;
import eu.pb4.brewery.other.TypeMapCodec;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2165;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2743;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4019;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_6899;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import net.minecraft.server.MinecraftServer;

public interface ConsumptionEffect
extends TypeMapCodec.CodecContainer<ConsumptionEffect> {
    public static final MapCodec<ConsumptionEffect> MAP_CODEC = new TypeMapCodec<ConsumptionEffect>(self -> {
        self.register("potion", Potion.CODEC);
        self.register("teleport_random", TeleportRandom.CODEC);
        self.register("execute_command", ExecuteCommand.CODEC);
        self.register("random", Random.CODEC);
        self.register("set_on_fire", SetOnFire.CODEC);
        self.register("freeze", Freeze.CODEC);
        self.register("set_alcohol_level", SetAlcoholLevel.CODEC);
        self.register("delayed", Delayed.CODEC);
        self.register("velocity", Velocity.CODEC);
        self.register("damage", Damage.CODEC);
    });
    public static final Codec<ConsumptionEffect> CODEC = new MapCodec.MapCodecCodec(MAP_CODEC);

    public static void register(class_2960 identifier, MapCodec<ConsumptionEffect> codec) {
        ((TypeMapCodec)CODEC).register(identifier.toString(), codec);
    }

    public static ConsumptionEffect of(class_1291 effect, String time, String value, boolean locked) {
        return new Potion(effect, WrappedExpression.createDefaultCE(time), WrappedExpression.createDefaultCE(value), locked, false, true);
    }

    public void apply(class_1309 var1, double var2, double var4);

    @Override
    public MapCodec<ConsumptionEffect> codec();

    public record Potion(class_1291 effect, WrappedExpression time, WrappedExpression value, boolean locked, boolean particles, boolean showIcon) implements ConsumptionEffect
    {
        public static MapCodec<Potion> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_7923.field_41174.method_40294().comapFlatMap(x -> DataResult.success((Object)((class_1291)x.comp_349())), x -> (class_6880)class_7923.field_41174.method_40265(class_7923.field_41174.method_10206(x)).get()).fieldOf("effect").forGetter(Potion::effect), (App)ExpressionUtil.COMMON_CE_EXPRESSION.fieldOf("time").forGetter(Potion::time), (App)ExpressionUtil.COMMON_CE_EXPRESSION.optionalFieldOf("value", (Object)WrappedExpression.createDefaultCE("0")).forGetter(Potion::value), (App)Codec.BOOL.optionalFieldOf("locked", (Object)true).forGetter(Potion::locked), (App)Codec.BOOL.optionalFieldOf("particles", (Object)false).forGetter(Potion::particles), (App)Codec.BOOL.optionalFieldOf("show_icon", (Object)true).forGetter(Potion::showIcon)).apply((Applicative)instance, Potion::new));

        public static ConsumptionEffect of(class_1291 effect, String time, String value, boolean locked, boolean particles, boolean showIcon) {
            return new Potion(effect, WrappedExpression.createDefaultCE(time), WrappedExpression.createDefaultCE(value), locked, particles, showIcon);
        }

        @Override
        public void apply(class_1309 user, double age, double quality) {
            double time = this.time().expression().setVariable("age", age).setVariable("quality", quality).setVariable("userAlcoholLevel", AlcoholManager.of(user).getModifiedAlcoholLevel()).evaluate() * 20.0;
            double level = this.value().expression().setVariable("age", age).setVariable("quality", quality).setVariable("userAlcoholLevel", AlcoholManager.of(user).getModifiedAlcoholLevel()).evaluate();
            if (time >= 0.0 && level >= 0.0) {
                class_1293 instance = new class_1293(this.effect(), (int)time, (int)level, false, this.particles, this.showIcon);
                ((StatusEffectInstanceExt)instance).brewery$setLocked(this.locked);
                user.method_26082(instance, (class_1297)user);
            }
        }

        @Override
        public MapCodec<ConsumptionEffect> codec() {
            return CODEC;
        }
    }

    public record TeleportRandom(WrappedExpression distance) implements ConsumptionEffect
    {
        public static MapCodec<TeleportRandom> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExpressionUtil.COMMON_CE_EXPRESSION.fieldOf("distance").forGetter(TeleportRandom::distance)).apply((Applicative)instance, TeleportRandom::new));

        public static ConsumptionEffect of(String distance) {
            return new TeleportRandom(WrappedExpression.createDefaultCE(distance));
        }

        @Override
        public void apply(class_1309 user, double age, double quality) {
            double distance = this.distance.expression().setVariable("age", age).setVariable("quality", quality).setVariable("userAlcoholLevel", AlcoholManager.of(user).getModifiedAlcoholLevel()).evaluate();
            if (distance > 0.0) {
                double d = user.method_23317();
                double e = user.method_23318();
                double f = user.method_23321();
                for (int i = 0; i < 16; ++i) {
                    double g = user.method_23317() + (user.method_6051().method_43058() - 0.5) * distance;
                    double h = class_3532.method_15350((double)(user.method_23318() + user.method_6051().method_43058() - 0.5), (double)user.method_37908().method_31607(), (double)(user.method_37908().method_31607() + ((class_3218)user.method_37908()).method_32819() - 1));
                    double j = user.method_23321() + (user.method_6051().method_43058() - 0.5) * distance;
                    if (user.method_5765()) {
                        user.method_5848();
                    }
                    class_243 vec3d = user.method_19538();
                    if (!user.method_6082(g, h, j, true)) continue;
                    user.method_37908().method_32888(class_5712.field_39446, vec3d, class_5712.class_7397.method_43285((class_1297)user));
                    class_3414 soundEvent = user instanceof class_4019 ? class_3417.field_24630 : class_3417.field_14890;
                    user.method_37908().method_43128(null, d, e, f, soundEvent, class_3419.field_15248, 1.0f, 1.0f);
                    user.method_5783(soundEvent, 1.0f, 1.0f);
                    break;
                }
            }
        }

        @Override
        public MapCodec<ConsumptionEffect> codec() {
            return CODEC;
        }
    }

    public record ExecuteCommand(String command, WrappedExpression apply) implements ConsumptionEffect
    {
        public static MapCodec<ExecuteCommand> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("command").forGetter(ExecuteCommand::command), (App)ExpressionUtil.COMMON_CE_EXPRESSION.optionalFieldOf("apply_check", (Object)WrappedExpression.createDefaultCE("1")).forGetter(ExecuteCommand::apply)).apply((Applicative)instance, ExecuteCommand::new));

        public static ConsumptionEffect of(String command, String applyCheck) {
            return new ExecuteCommand(command, WrappedExpression.createDefaultCE(applyCheck));
        }

        public static ConsumptionEffect of(String command) {
            return ExecuteCommand.of(command, "1");
        }

        @Override
        public void apply(class_1309 user, double age, double quality) {
            double value = this.apply.expression().setVariable("age", age).setVariable("quality", quality).setVariable("userAlcoholLevel", AlcoholManager.of(user).getModifiedAlcoholLevel()).evaluate();
            if (value >= 0.0) {
                user.method_5682().method_3734().method_44252(user.method_5671().method_9206(4).method_36321(class_2165.field_17395), this.command);
            }
        }

        @Override
        public MapCodec<ConsumptionEffect> codec() {
            return CODEC;
        }
    }

    public record Random(List<ConsumptionEffect> effects, WrappedExpression apply) implements ConsumptionEffect
    {
        public static MapCodec<Random> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.list(CODEC).fieldOf("entries").forGetter(Random::effects), (App)ExpressionUtil.COMMON_CE_EXPRESSION.optionalFieldOf("apply_check", (Object)WrappedExpression.createDefaultCE("1")).forGetter(Random::apply)).apply((Applicative)instance, Random::new));

        public static ConsumptionEffect of(List<ConsumptionEffect> effects, String applyCheck) {
            return new Random(effects, WrappedExpression.createDefaultCE(applyCheck));
        }

        public static ConsumptionEffect of(List<ConsumptionEffect> effects) {
            return Random.of(effects, "1");
        }

        @Override
        public void apply(class_1309 user, double age, double quality) {
            double value = this.apply.expression().setVariable("age", age).setVariable("quality", quality).setVariable("userAlcoholLevel", AlcoholManager.of(user).getModifiedAlcoholLevel()).evaluate();
            if (value >= 0.0) {
                this.effects.get(user.method_6051().method_43048(this.effects.size())).apply(user, age, quality);
            }
        }

        @Override
        public MapCodec<ConsumptionEffect> codec() {
            return CODEC;
        }
    }

    public record SetOnFire(WrappedExpression time) implements ConsumptionEffect
    {
        public static MapCodec<SetOnFire> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExpressionUtil.createCodec("age", "quality", "userAlcoholLevel", "current").fieldOf("time").forGetter(SetOnFire::time)).apply((Applicative)instance, SetOnFire::new));

        public static ConsumptionEffect of(String time) {
            return new SetOnFire(WrappedExpression.create(time, "age", "quality", "userAlcoholLevel", "current"));
        }

        @Override
        public void apply(class_1309 user, double age, double quality) {
            double value = this.time.expression().setVariable("age", age).setVariable("quality", quality).setVariable("userAlcoholLevel", AlcoholManager.of(user).getModifiedAlcoholLevel()).setVariable("current", (double)user.method_20802() / 20.0).evaluate() * 20.0;
            if (value >= 0.0) {
                user.method_20803((int)value);
            }
        }

        @Override
        public MapCodec<ConsumptionEffect> codec() {
            return CODEC;
        }
    }

    public record Freeze(WrappedExpression time) implements ConsumptionEffect
    {
        public static MapCodec<Freeze> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExpressionUtil.createCodec("age", "quality", "userAlcoholLevel", "current").fieldOf("time").forGetter(Freeze::time)).apply((Applicative)instance, Freeze::new));

        public static ConsumptionEffect of(String time) {
            return new Freeze(WrappedExpression.create(time, "age", "quality", "userAlcoholLevel", "current"));
        }

        @Override
        public void apply(class_1309 user, double age, double quality) {
            double value = this.time.expression().setVariable("age", age).setVariable("quality", quality).setVariable("userAlcoholLevel", AlcoholManager.of(user).getModifiedAlcoholLevel()).setVariable("current", (double)user.method_20802() / 20.0).evaluate() * 20.0;
            if (value >= 0.0) {
                user.method_32317((int)value);
            }
        }

        @Override
        public MapCodec<ConsumptionEffect> codec() {
            return CODEC;
        }
    }

    public record SetAlcoholLevel(WrappedExpression value) implements ConsumptionEffect
    {
        public static MapCodec<SetAlcoholLevel> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExpressionUtil.createCodec("age", "quality", "userAlcoholLevel", "current").fieldOf("value").forGetter(SetAlcoholLevel::value)).apply((Applicative)instance, SetAlcoholLevel::new));

        public static ConsumptionEffect of(String value) {
            return new SetAlcoholLevel(WrappedExpression.create(value, "age", "quality", "current"));
        }

        @Override
        public void apply(class_1309 user, double age, double quality) {
            double value = this.value.expression().setVariable("age", age).setVariable("quality", quality).setVariable("userAlcoholLevel", AlcoholManager.of(user).getModifiedAlcoholLevel()).setVariable("current", AlcoholManager.of((class_1309)user).alcoholLevel).evaluate();
            if (value >= 0.0) {
                AlcoholManager.of((class_1309)user).alcoholLevel = value;
            }
        }

        @Override
        public MapCodec<ConsumptionEffect> codec() {
            return CODEC;
        }
    }

    public record Delayed(WrappedExpression time, List<ConsumptionEffect> effects) implements ConsumptionEffect
    {
        public static MapCodec<Delayed> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExpressionUtil.COMMON_CE_EXPRESSION.fieldOf("delay").forGetter(Delayed::time), (App)Codec.list(CODEC).fieldOf("entries").forGetter(Delayed::effects)).apply((Applicative)instance, Delayed::new));

        public static ConsumptionEffect of(List<ConsumptionEffect> effects, String time) {
            return new Delayed(WrappedExpression.createDefaultCE(time), effects);
        }

        @Override
        public void apply(class_1309 user, double age, double quality) {
            double value = this.time.expression().setVariable("age", age).setVariable("quality", quality).setVariable("userAlcoholLevel", AlcoholManager.of(user).getModifiedAlcoholLevel()).evaluate() * 20.0;
            if (value >= 0.0) {
                AlcoholManager.of(user).addDelayedEffect((int)value, age, quality, this.effects);
            }
        }

        @Override
        public MapCodec<ConsumptionEffect> codec() {
            return CODEC;
        }
    }

    public record Velocity(WrappedExpression x, WrappedExpression y, WrappedExpression z, Optional<WrappedExpression> normalized) implements ConsumptionEffect
    {
        public static MapCodec<Velocity> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExpressionUtil.COMMON_CE_EXPRESSION.fieldOf("x").forGetter(Velocity::x), (App)ExpressionUtil.COMMON_CE_EXPRESSION.fieldOf("y").forGetter(Velocity::y), (App)ExpressionUtil.COMMON_CE_EXPRESSION.fieldOf("z").forGetter(Velocity::z), (App)ExpressionUtil.COMMON_CE_EXPRESSION.optionalFieldOf("normalized").forGetter(Velocity::normalized)).apply((Applicative)instance, Velocity::new));

        public static ConsumptionEffect of(String x, String y, String z) {
            return new Velocity(WrappedExpression.createDefaultCE(x), WrappedExpression.createDefaultCE(y), WrappedExpression.createDefaultCE(z), Optional.empty());
        }

        public static ConsumptionEffect of(String x, String y, String z, String normalized) {
            return new Velocity(WrappedExpression.createDefaultCE(x), WrappedExpression.createDefaultCE(y), WrappedExpression.createDefaultCE(z), Optional.of(WrappedExpression.createDefaultCE(normalized)));
        }

        @Override
        public void apply(class_1309 user, double age, double quality) {
            double x = this.x.expression().setVariable("age", age).setVariable("quality", quality).setVariable("userAlcoholLevel", AlcoholManager.of(user).getModifiedAlcoholLevel()).evaluate();
            double y = this.y.expression().setVariable("age", age).setVariable("quality", quality).setVariable("userAlcoholLevel", AlcoholManager.of(user).getModifiedAlcoholLevel()).evaluate();
            double z = this.z.expression().setVariable("age", age).setVariable("quality", quality).setVariable("userAlcoholLevel", AlcoholManager.of(user).getModifiedAlcoholLevel()).evaluate();
            if (x != 0.0 || y != 0.0 || z != 0.0) {
                if (this.normalized.isPresent()) {
                    double value = this.normalized.get().expression().setVariable("age", age).setVariable("quality", quality).setVariable("userAlcoholLevel", AlcoholManager.of(user).getModifiedAlcoholLevel()).evaluate();
                    if (value == 0.0) {
                        return;
                    }
                    class_243 vec = new class_243(x, y, z).method_1029().method_1021(Math.min(value, 100.0));
                    user.method_5762(vec.field_1352, vec.field_1351, vec.field_1350);
                } else {
                    class_243 vec = new class_243(x, y, z);
                    vec = vec.method_1029().method_1021(Math.min(vec.method_1033(), 100.0));
                    user.method_5762(vec.field_1352, vec.field_1351, vec.field_1350);
                }
                if (user instanceof class_3222) {
                    class_3222 player = (class_3222)user;
                    player.field_13987.method_14364((class_2596)new class_2743((class_1297)player));
                }
            }
        }

        @Override
        public MapCodec<ConsumptionEffect> codec() {
            return CODEC;
        }
    }

    public record Damage(class_6880<class_8110> type, WrappedExpression value) implements ConsumptionEffect
    {
        public static MapCodec<Damage> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_6899.method_40400((class_5321)class_7924.field_42534).fieldOf("id").forGetter(Damage::type), (App)ExpressionUtil.COMMON_CE_EXPRESSION.fieldOf("value").forGetter(Damage::value)).apply((Applicative)instance, Damage::new));

        public static ConsumptionEffect of(MinecraftServer server, class_5321<class_8110> type, String value) {
            return new Damage((class_6880<class_8110>)((class_6880)server.method_30611().method_30530(class_7924.field_42534).method_40264(type).get()), WrappedExpression.createDefaultCE(value));
        }

        public static ConsumptionEffect of(MinecraftServer server, class_2960 type, String value) {
            return new Damage((class_6880<class_8110>)((class_6880)server.method_30611().method_30530(class_7924.field_42534).method_40264(class_5321.method_29179((class_5321)class_7924.field_42534, (class_2960)type)).get()), WrappedExpression.createDefaultCE(value));
        }

        @Override
        public void apply(class_1309 user, double age, double quality) {
            double value = this.value.expression().setVariable("age", age).setVariable("quality", quality).setVariable("userAlcoholLevel", AlcoholManager.of(user).getModifiedAlcoholLevel()).evaluate();
            if (value >= 0.0) {
                class_1282 source = new class_1282(this.type);
                user.method_5643(source, (float)value);
            }
        }

        @Override
        public MapCodec<ConsumptionEffect> codec() {
            return CODEC;
        }
    }
}

