/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.brewery.drink;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.pb4.brewery.BreweryInit;
import eu.pb4.brewery.drink.ConsumptionEffect;
import eu.pb4.brewery.drink.DrinkInfo;
import eu.pb4.brewery.drink.DrinkUtils;
import eu.pb4.brewery.drink.ExpressionUtil;
import eu.pb4.brewery.drink.WrappedExpression;
import eu.pb4.brewery.other.BrewUtils;
import eu.pb4.brewery.other.WrappedText;
import eu.pb4.polymer.resourcepack.api.PolymerModelData;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5251;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7876;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public record DrinkType(WrappedText name, class_5251 color, ItemLookData visuals, List<BarrelInfo> barrelInfo, WrappedExpression baseQuality, WrappedExpression alcoholicValue, List<ConsumptionEffect> consumptionEffects, WrappedExpression cookingQualityMult, List<BrewIngredient> ingredients, int distillationRuns, List<ConsumptionEffect> unfinishedEffects, Optional<DrinkInfo> info, boolean showQuality, Optional<class_6885<class_2248>> heatSource) {
    public static MapCodec<DrinkType> CODEC_V2 = RecordCodecBuilder.mapCodec(instance -> instance.group((App)WrappedText.CODEC.fieldOf("name").forGetter(DrinkType::name), (App)class_5251.field_39242.fieldOf("color").forGetter(DrinkType::color), (App)ItemLookData.CODEC.optionalFieldOf("visual", (Object)ItemLookData.DEFAULT).forGetter(DrinkType::visuals), (App)Codec.list(BarrelInfo.CODEC_V1).optionalFieldOf("barrel_definitions", List.of()).forGetter(DrinkType::barrelInfo), (App)ExpressionUtil.createCodec("age").fieldOf("base_quality_value").forGetter(DrinkType::baseQuality), (App)ExpressionUtil.COMMON_EXPRESSION.fieldOf("alcoholic_value").forGetter(DrinkType::alcoholicValue), (App)Codec.list(ConsumptionEffect.CODEC).optionalFieldOf("entries", new ArrayList()).forGetter(DrinkType::consumptionEffects), (App)ExpressionUtil.createCodec("age").fieldOf("cooking_quality_multiplier").forGetter(DrinkType::cookingQualityMult), (App)Codec.list(BrewIngredient.CODEC_V1).optionalFieldOf("ingredients", new ArrayList()).forGetter(DrinkType::ingredients), (App)Codec.INT.optionalFieldOf("distillation_runs", (Object)0).forGetter(DrinkType::distillationRuns), (App)Codec.list(ConsumptionEffect.CODEC).optionalFieldOf("unfinished_brew_effects", new ArrayList()).forGetter(DrinkType::unfinishedEffects), (App)DrinkInfo.CODEC.optionalFieldOf("book_information").forGetter(DrinkType::info), (App)Codec.BOOL.optionalFieldOf("show_quality", (Object)true).forGetter(DrinkType::showQuality), (App)class_6895.method_40340((class_5321)class_7924.field_41254).optionalFieldOf("required_heat_source").forGetter(DrinkType::heatSource)).apply((Applicative)instance, DrinkType::new));
    public static MapCodec<DrinkType> CODEC_V1 = RecordCodecBuilder.mapCodec(instance -> instance.group((App)WrappedText.CODEC.fieldOf("name").forGetter(DrinkType::name), (App)class_5251.field_39242.fieldOf("color").forGetter(DrinkType::color), (App)ItemLookData.CODEC.optionalFieldOf("visual", (Object)ItemLookData.DEFAULT).forGetter(DrinkType::visuals), (App)Codec.list(BarrelInfo.CODEC_V1).optionalFieldOf("barrel_definitions", List.of()).forGetter(DrinkType::barrelInfo), (App)ExpressionUtil.createCodec("age").fieldOf("base_quality_value").forGetter(DrinkType::baseQuality), (App)ExpressionUtil.COMMON_EXPRESSION.fieldOf("alcoholic_value").forGetter(DrinkType::alcoholicValue), (App)Codec.list(ConsumptionEffect.CODEC).optionalFieldOf("entries", new ArrayList()).forGetter(DrinkType::consumptionEffects), (App)ExpressionUtil.createCodec("age").fieldOf("cooking_quality_multiplier").forGetter(DrinkType::cookingQualityMult), (App)Codec.list(BrewIngredient.CODEC_V1).optionalFieldOf("ingredients", new ArrayList()).forGetter(DrinkType::ingredients), (App)Codec.BOOL.xmap(x -> x != false ? 1 : 0, i -> i == 1).optionalFieldOf("require_distillation", (Object)0).forGetter(DrinkType::distillationRuns), (App)Codec.list(ConsumptionEffect.CODEC).optionalFieldOf("unfinished_brew_effects", new ArrayList()).forGetter(DrinkType::unfinishedEffects), (App)DrinkInfo.CODEC.optionalFieldOf("book_information").forGetter(DrinkType::info), (App)Codec.BOOL.optionalFieldOf("show_quality", (Object)true).forGetter(DrinkType::showQuality), (App)class_6895.method_40340((class_5321)class_7924.field_41254).optionalFieldOf("required_heat_source").forGetter(DrinkType::heatSource)).apply((Applicative)instance, DrinkType::new));
    public static final Codec<DrinkType> CODEC = new MapCodec.MapCodecCodec((MapCodec)new MapCodec<DrinkType>(){

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return Stream.of(ops.createString("version"));
        }

        public <T> DataResult<DrinkType> decode(DynamicOps<T> ops, MapLike<T> input) {
            int version = ops.getNumberValue(input.get("version"), (Number)0).intValue();
            return switch (version) {
                case 1 -> CODEC_V1.decode(ops, input);
                default -> CODEC_V2.decode(ops, input);
            };
        }

        public <T> RecordBuilder<T> encode(DrinkType input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
            return CODEC_V2.encode((Object)input, ops, prefix.add("version", ops.createInt(2)));
        }
    });

    public static DrinkType create(class_2561 name, class_5251 color, List<BarrelInfo> barrelInfo, String quality, String alcoholicValue, List<ConsumptionEffect> consumptionEffects, String cookingTime, List<BrewIngredient> ingredients, DrinkInfo info) {
        return DrinkType.create(name, color, barrelInfo, quality, alcoholicValue, consumptionEffects, cookingTime, ingredients, false, List.of(), info);
    }

    public static DrinkType create(class_2561 name, class_5251 color, List<BarrelInfo> barrelInfo, String quality, String alcoholicValue, List<ConsumptionEffect> consumptionEffects, String cookingTime, List<BrewIngredient> ingredients, boolean requireDistillation, List<ConsumptionEffect> unfinishedEffects, DrinkInfo info) {
        return DrinkType.create(name, color, barrelInfo, quality, alcoholicValue, consumptionEffects, cookingTime, ingredients, requireDistillation ? 1 : 0, unfinishedEffects, info);
    }

    public static DrinkType create(class_2561 name, class_5251 color, List<BarrelInfo> barrelInfo, String quality, String alcoholicValue, List<ConsumptionEffect> consumptionEffects, String cookingTime, List<BrewIngredient> ingredients, int distillationRuns, List<ConsumptionEffect> unfinishedEffects, DrinkInfo info) {
        return DrinkType.create(name, color, barrelInfo, quality, alcoholicValue, consumptionEffects, cookingTime, ingredients, distillationRuns, unfinishedEffects, info, Optional.empty());
    }

    public static DrinkType create(class_2561 name, class_5251 color, List<BarrelInfo> barrelInfo, String quality, String alcoholicValue, List<ConsumptionEffect> consumptionEffects, String cookingTime, List<BrewIngredient> ingredients, int distillationRuns, List<ConsumptionEffect> unfinishedEffects, DrinkInfo info, class_6862<class_2248> heatSource) {
        return DrinkType.create(name, color, barrelInfo, quality, alcoholicValue, consumptionEffects, cookingTime, ingredients, distillationRuns, unfinishedEffects, info, Optional.of(class_6885.method_45924((class_7876)class_7923.field_41175.method_46770(), heatSource)));
    }

    public static DrinkType create(class_2561 name, class_5251 color, List<BarrelInfo> barrelInfo, String quality, String alcoholicValue, List<ConsumptionEffect> consumptionEffects, String cookingTime, List<BrewIngredient> ingredients, int distillationRuns, List<ConsumptionEffect> unfinishedEffects, DrinkInfo info, Optional<class_6885<class_2248>> heatSource) {
        return new DrinkType(WrappedText.of(name), color, ItemLookData.DEFAULT, barrelInfo, WrappedExpression.create(quality, "age"), WrappedExpression.createDefault(alcoholicValue), consumptionEffects, WrappedExpression.create(cookingTime, "age"), ingredients, distillationRuns, unfinishedEffects, Optional.of(info), true, heatSource);
    }

    public boolean requireDistillation() {
        return this.distillationRuns > 0;
    }

    @Nullable
    public BarrelInfo getBarrelInfo(class_2960 barrelType) {
        BarrelInfo def = null;
        for (BarrelInfo info : this.barrelInfo) {
            if (info.type.equals((Object)barrelType)) {
                return info;
            }
            if (!info.type.equals((Object)BarrelInfo.ANY)) continue;
            def = info;
        }
        return def;
    }

    public boolean isFinished(class_1799 itemStack) {
        return DrinkUtils.getAgeInSeconds(itemStack) >= 0.0 && (!this.requireDistillation() || DrinkUtils.getDistillationStatus(itemStack));
    }

    public record ItemLookData(class_1792 item, Optional<class_2487> extraNbt, Optional<PolymerModelData> model) {
        public static final ItemLookData DEFAULT = new ItemLookData(class_1802.field_8574, Optional.empty(), Optional.empty());
        public static Codec<ItemLookData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_7923.field_41178.method_39673().optionalFieldOf("item", (Object)class_1802.field_8574).forGetter(ItemLookData::item), (App)class_2487.field_25128.optionalFieldOf("nbt").forGetter(ItemLookData::extraNbt), (App)class_2960.field_25139.optionalFieldOf("model").forGetter(x -> x.model.map(PolymerModelData::modelPath))).apply((Applicative)instance, ItemLookData::create));

        private static ItemLookData create(class_1792 item, Optional<class_2487> nbtCompound, Optional<class_2960> identifier) {
            return new ItemLookData(item, nbtCompound, identifier.map(value -> PolymerResourcePackUtils.requestModel((class_1792)item, (class_2960)value)));
        }
    }

    public record BarrelInfo(class_2960 type, WrappedExpression qualityChange, int baseTime) {
        public static final class_2960 ANY = BreweryInit.id("any_barrel");
        public static final class_2960 NONE = BreweryInit.id("none");
        protected static Codec<class_2960> TYPE_CODEC = Codec.STRING.xmap(x -> x.equals("*") ? ANY : BrewUtils.tryParsingId(x, NONE), x -> x.equals((Object)ANY) ? "*" : x.toString());
        public static Codec<BarrelInfo> CODEC_V1 = RecordCodecBuilder.create(instance -> instance.group((App)TYPE_CODEC.fieldOf("type").forGetter(BarrelInfo::type), (App)ExpressionUtil.COMMON_EXPRESSION.fieldOf("quality_value").forGetter(BarrelInfo::qualityChange), (App)class_5699.field_33442.fieldOf("reveal_time").forGetter(BarrelInfo::baseTime)).apply((Applicative)instance, BarrelInfo::new));

        public static BarrelInfo of(String type, String qualityChange, int baseTime) {
            return BarrelInfo.of(type.equals("*") ? ANY : new class_2960(type), qualityChange, baseTime);
        }

        public static BarrelInfo of(class_2960 type, String qualityChange, int baseTime) {
            return new BarrelInfo(type, WrappedExpression.createDefault(qualityChange), baseTime);
        }
    }

    public record BrewIngredient(List<class_1792> items, int count, class_1799 returnedItemStack) {
        public static Codec<BrewIngredient> CODEC_V1 = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)class_7923.field_41178.method_39673()).fieldOf("items").forGetter(BrewIngredient::items), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(BrewIngredient::count), (App)class_1799.field_24671.optionalFieldOf("dropped_stack", (Object)class_1799.field_8037).forGetter(BrewIngredient::returnedItemStack)).apply((Applicative)instance, BrewIngredient::new));

        public static BrewIngredient of(int count, class_1792 ... items) {
            return new BrewIngredient(List.of(items), count, class_1799.field_8037);
        }

        public static BrewIngredient of(int count, class_1799 stack, class_1792 ... items) {
            return new BrewIngredient(List.of(items), count, stack);
        }

        public static BrewIngredient of(class_1792 ... items) {
            return new BrewIngredient(List.of(items), 1, class_1799.field_8037);
        }
    }
}

