/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.brewery.drink;

import eu.pb4.brewery.BreweryInit;
import eu.pb4.brewery.drink.DrinkType;
import eu.pb4.brewery.item.BrewItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class DrinkUtils {
    public static final String TYPE_NBT = "BrewType";
    public static final String QUALITY_NBT = "BrewQuality";
    public static final String AGE_NBT = "BrewAge";
    public static final String AGE_COOK_NBT = "BrewCookAge";
    public static final String QUALITY_MULT_NBT = "BrewQualityMult";
    public static final String BARREL_TYPE_NBT = "BrewBarrelType";
    public static final String DISTILLATED_NBT = "BrewDistillated";
    public static final String HEAT_SOURCE_NBT = "BrewHeatSource";

    @Nullable
    public static DrinkType getType(class_1799 stack) {
        if (stack.method_31574((class_1792)BrewItems.DRINK_ITEM) && stack.method_7985()) {
            class_2960 id = class_2960.method_12829((String)stack.method_7969().method_10558(TYPE_NBT));
            DrinkType type = BreweryInit.DRINK_TYPES.get(id);
            if (type != null) {
                return type;
            }
            if (id.method_12832().startsWith("drinks/")) {
                class_2960 id2 = new class_2960(id.method_12836(), id.method_12832().substring("drinks/".length()));
                type = BreweryInit.DRINK_TYPES.get(id2);
                return type;
            }
        }
        return null;
    }

    public static double getQuality(class_1799 stack) {
        if (stack.method_31574((class_1792)BrewItems.DRINK_ITEM) && stack.method_7985()) {
            return stack.method_7969().method_10574(QUALITY_NBT);
        }
        return -1.0;
    }

    public static String getBarrelType(class_1799 stack) {
        if (stack.method_31574((class_1792)BrewItems.DRINK_ITEM) && stack.method_7985()) {
            return stack.method_7969().method_10558(BARREL_TYPE_NBT);
        }
        return "";
    }

    public static boolean getDistillationStatus(class_1799 stack) {
        DrinkType type;
        if (stack.method_7985() && (type = DrinkUtils.getType(stack)) != null) {
            return stack.method_7969().method_10550(DISTILLATED_NBT) >= type.distillationRuns();
        }
        return false;
    }

    @Nullable
    public static class_2248 getHeatSource(class_1799 stack) {
        if (stack.method_7985() && stack.method_7969().method_10545(HEAT_SOURCE_NBT)) {
            return (class_2248)class_7923.field_41175.method_10223(class_2960.method_12829((String)stack.method_7969().method_10558(HEAT_SOURCE_NBT)));
        }
        return class_2246.field_10036;
    }

    public static boolean canBeDistillated(class_1799 stack) {
        DrinkType type = DrinkUtils.getType(stack);
        boolean already = DrinkUtils.getDistillationStatus(stack);
        return !already && (type != null && type.requireDistillation() || stack.method_31574(BrewItems.INGREDIENT_MIXTURE));
    }

    public static double getAgeInTicks(class_1799 stack) {
        return DrinkUtils.getAgeInTicks(stack, Double.MIN_VALUE);
    }

    public static double getAgeInTicks(class_1799 stack, double defaultValue) {
        if (stack.method_7985() && stack.method_7969().method_10573(AGE_NBT, 99)) {
            return stack.method_7969().method_10574(AGE_NBT);
        }
        return defaultValue;
    }

    public static double getAgeInSeconds(class_1799 stack) {
        return DrinkUtils.getAgeInTicks(stack) / 20.0;
    }

    public static class_1799 createDrink(class_2960 type, int age, double quality, int distillated, class_2960 heatingSource) {
        class_1799 stack = new class_1799((class_1935)BrewItems.DRINK_ITEM);
        stack.method_7948().method_10569(AGE_NBT, age);
        stack.method_7948().method_10549(QUALITY_NBT, quality);
        stack.method_7948().method_10582(TYPE_NBT, type.toString());
        stack.method_7948().method_10569(DISTILLATED_NBT, distillated);
        stack.method_7948().method_10582(HEAT_SOURCE_NBT, heatingSource.toString());
        return stack;
    }

    public static class_1799 createDrink(class_2960 type, double qualityMultiplier) {
        class_1799 stack = new class_1799((class_1935)BrewItems.DRINK_ITEM);
        stack.method_7948().method_10569(AGE_NBT, 0);
        stack.method_7948().method_10582(TYPE_NBT, type.toString());
        stack.method_7948().method_10549(QUALITY_MULT_NBT, qualityMultiplier);
        return stack;
    }

    public static double getIngredientMultiplier(class_1799 stack) {
        if (stack.method_7985() && stack.method_7969().method_10573(QUALITY_MULT_NBT, 99)) {
            return stack.method_7969().method_10574(QUALITY_MULT_NBT);
        }
        return 1.0;
    }

    public static List<DrinkType> findTypes(List<class_1799> ingredients, class_2960 barrelType, class_2248 heatSource) {
        if (ingredients.isEmpty()) {
            return List.of();
        }
        ArrayList<DrinkType> list = new ArrayList<DrinkType>();
        block0: for (DrinkType type : BreweryInit.DRINK_TYPES.values()) {
            if ((barrelType != null || !type.barrelInfo().isEmpty()) && (barrelType == null || type.getBarrelInfo(barrelType) == null) || type.ingredients().isEmpty() || !type.heatSource().isEmpty() && !type.heatSource().get().method_40241(class_7923.field_41175.method_47983((Object)heatSource))) continue;
            ArrayList<class_1799> ing = new ArrayList<class_1799>(ingredients.size());
            for (class_1799 i : ingredients) {
                ing.add(new class_1799((class_1935)i.method_7909(), i.method_7947()));
            }
            for (DrinkType.BrewIngredient ingredient : type.ingredients()) {
                int count = ingredient.count();
                for (class_1799 stack : ing) {
                    if (stack.method_7960() || !ingredient.items().contains(stack.method_7909())) continue;
                    if ((count -= stack.method_7947()) < 0) continue block0;
                    stack.method_7939(0);
                }
                if (count == 0) continue;
                continue block0;
            }
            list.add(type);
        }
        return list;
    }
}

