/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.brewery.item;

import eu.pb4.brewery.BreweryInit;
import eu.pb4.brewery.drink.AlcoholManager;
import eu.pb4.brewery.drink.ConsumptionEffect;
import eu.pb4.brewery.drink.DrinkType;
import eu.pb4.brewery.drink.DrinkUtils;
import eu.pb4.brewery.other.BrewGameRules;
import eu.pb4.brewery.other.BrewUtils;
import eu.pb4.polymer.core.api.item.PolymerItem;
import java.util.List;
import net.fabricmc.fabric.api.gamerule.v1.rule.DoubleRule;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_4174;
import net.minecraft.class_5253;
import net.minecraft.class_5328;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;

public class DrinkItem
extends class_1792
implements PolymerItem {
    public DrinkItem(class_1792.class_1793 settings) {
        super(settings.method_7889(1).method_19265(new class_4174.class_4175().method_19240().method_19242()));
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        class_1657 playerEntity;
        class_1657 class_16572 = playerEntity = user instanceof class_1657 ? (class_1657)user : null;
        if (playerEntity instanceof class_3222) {
            class_174.field_1198.method_8821((class_3222)playerEntity, stack);
        }
        if (!world.field_9236) {
            try {
                DrinkType type = DrinkUtils.getType(stack);
                if (type != null) {
                    double age = DrinkUtils.getAgeInSeconds(stack);
                    double quality = DrinkUtils.getQuality(stack);
                    double alcoholicValue = type.alcoholicValue().expression().setVariable("age", age).setVariable("quality", quality).evaluate();
                    AlcoholManager.of(user).drink(type, quality, alcoholicValue);
                    for (ConsumptionEffect effect : type.isFinished(stack) ? type.consumptionEffects() : type.unfinishedEffects()) {
                        effect.apply(user, age, quality);
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (playerEntity != null) {
            playerEntity.method_7259(class_3468.field_15372.method_14956((Object)this));
            if (!playerEntity.method_31549().field_7477) {
                stack.method_7934(1);
            }
        }
        if (playerEntity == null || !playerEntity.method_31549().field_7477) {
            if (stack.method_7960()) {
                return new class_1799((class_1935)class_1802.field_8469);
            }
            if (playerEntity != null) {
                playerEntity.method_31548().method_7394(new class_1799((class_1935)class_1802.field_8469));
            }
        }
        user.method_32876(class_5712.field_28734);
        return stack;
    }

    public int method_7881(class_1799 stack) {
        return 32;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8946;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        return class_5328.method_29282((class_1937)world, (class_1657)user, (class_1268)hand);
    }

    public class_2561 method_7864(class_1799 stack) {
        String id;
        DrinkType type = DrinkUtils.getType(stack);
        if (type != null) {
            if (type.isFinished(stack)) {
                return type.name().text();
            }
            return class_2561.method_43469((String)"item.brewery.ingredient_mixture_specific", (Object[])new Object[]{type.name().text()});
        }
        String string = id = stack.method_7985() ? stack.method_7969().method_10558("BrewType") : null;
        if (id == null || id.isEmpty()) {
            id = "<Unknown>";
        }
        return class_2561.method_43469((String)this.method_7876(), (Object[])new Object[]{id});
    }

    public String method_7866(class_1799 stack) {
        return this.method_7876();
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        if (stack.method_7985() && world != null) {
            DrinkType type = DrinkUtils.getType(stack);
            if (type != null && type.showQuality() && world.method_8450().method_8355(BrewGameRules.SHOW_QUALITY)) {
                double starCount;
                double quality = DrinkUtils.getQuality(stack);
                StringBuilder stars = new StringBuilder();
                StringBuilder antistars = new StringBuilder();
                for (starCount = (double)Math.round(quality / 2.0 * 10.0) / 10.0; starCount >= 1.0; starCount -= 1.0) {
                    stars.append("\u2b50");
                }
                if (starCount > 0.0) {
                    stars.append("\u2606");
                }
                int starsLeft = 5 - stars.length();
                for (int i = 0; i < starsLeft; ++i) {
                    antistars.append("\u2606");
                }
                tooltip.add((class_2561)class_2561.method_43469((String)"text.brewery.quality", (Object[])new Object[]{class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)stars.toString()).method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)antistars.toString()).method_27692(class_124.field_1063))}));
            }
            if (world.method_8450().method_8355(BrewGameRules.SHOW_AGE)) {
                double mult = world != null ? ((DoubleRule)world.method_8450().method_20746(BrewGameRules.BARREL_AGING_MULTIPLIER)).get() : 1.0;
                double age = DrinkUtils.getAgeInSeconds(stack) / mult;
                if (age > 0.0) {
                    tooltip.add((class_2561)class_2561.method_43469((String)"text.brewery.age", (Object[])new Object[]{BrewUtils.fromTimeShort(age).method_27692(class_124.field_1080)}));
                }
            }
            if (BreweryInit.DISPLAY_DEV) {
                tooltip.add((class_2561)class_2561.method_43470((String)"== DEV ==").method_27692(class_124.field_1075));
                tooltip.add((class_2561)class_2561.method_43470((String)"BrewType: ").method_27693(stack.method_7969().method_10558("BrewType")).method_27692(class_124.field_1080));
                tooltip.add((class_2561)class_2561.method_43470((String)"BrewQuality: ").method_27693("" + DrinkUtils.getQuality(stack)).method_27692(class_124.field_1080));
                tooltip.add((class_2561)class_2561.method_43470((String)"BrewAge: ").method_27693("" + DrinkUtils.getAgeInTicks(stack)).method_27692(class_124.field_1080));
                tooltip.add((class_2561)class_2561.method_43470((String)"BrewDistillated: ").method_27693("" + DrinkUtils.getDistillationStatus(stack)).method_27692(class_124.field_1080));
            }
        }
    }

    public class_1792 getPolymerItem(class_1799 itemStack, @Nullable class_3222 player) {
        DrinkType type = DrinkUtils.getType(itemStack);
        if (type != null) {
            return type.visuals().item();
        }
        return class_1802.field_8574;
    }

    public class_1799 getPolymerItemStack(class_1799 itemStack, class_1836 context, @Nullable class_3222 player) {
        class_1799 out = super.getPolymerItemStack(itemStack, context, player);
        DrinkType type = DrinkUtils.getType(itemStack);
        if (type != null) {
            if (type.isFinished(itemStack)) {
                out.method_7948().method_10569("CustomPotionColor", type.color().method_27716());
            } else {
                out.method_7948().method_10569("CustomPotionColor", class_5253.class_5254.method_27763((int)type.color().method_27716(), (int)3694022));
            }
            if (type.visuals().extraNbt().isPresent()) {
                out.method_7948().method_10543(type.visuals().extraNbt().get());
            }
            if (type.visuals().model().isPresent()) {
                out.method_7948().method_10569("CustomModelData", type.visuals().model().get().value());
            }
        }
        return out;
    }
}

