/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.brewery.other;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import eu.pb4.brewery.BreweryInit;
import eu.pb4.brewery.GenericModInfo;
import eu.pb4.brewery.block.entity.TickableContents;
import eu.pb4.brewery.drink.AlcoholManager;
import eu.pb4.brewery.drink.DefaultDefinitions;
import eu.pb4.brewery.drink.DrinkType;
import eu.pb4.brewery.drink.DrinkUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.function.Function;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2245;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class BrewCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"brewery").executes(BrewCommands::about)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"create").requires(Permissions.require((String)"brewery.create", (int)2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"type", (ArgumentType)class_2232.method_9441()).suggests((context, builder) -> {
            Iterable candidates = BreweryInit.DRINK_TYPES.keySet()::iterator;
            String remaining = builder.getRemaining().toLowerCase(Locale.ROOT);
            class_2172.method_9268(candidates, (String)remaining, Function.identity(), id -> builder.suggest(id.toString(), (Message)BreweryInit.DRINK_TYPES.get(id).name().text()));
            return builder.buildFuture();
        }).executes(BrewCommands::createDrink)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"quality", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)10.0)).executes(BrewCommands::createDrink)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"age", (ArgumentType)DoubleArgumentType.doubleArg()).executes(BrewCommands::createDrink)).then(class_2170.method_9244((String)"distillated", (ArgumentType)BoolArgumentType.bool()).executes(BrewCommands::createDrink))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"force_age").requires(Permissions.require((String)"brewery.force_age", (int)2))).then(class_2170.method_9244((String)"position", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"time", (ArgumentType)class_2245.method_9489()).executes(BrewCommands::ageContainer))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"stats").requires(Permissions.require((String)"brewery.stats", (int)2))).executes(ctx -> BrewCommands.showStats((CommandContext<class_2168>)ctx, (class_1297)((class_2168)ctx.getSource()).method_9207()))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9309()).requires(Permissions.require((String)"brewery.stats_others", (int)2))).executes(ctx -> BrewCommands.showStats((CommandContext<class_2168>)ctx, class_2186.method_9313((CommandContext)ctx, (String)"player")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"set").requires(Permissions.require((String)"brewery.set", (int)2))).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9306()).then(class_2170.method_9244((String)"alcohol", (ArgumentType)DoubleArgumentType.doubleArg()).then(class_2170.method_9244((String)"quality", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)10.0f)).executes(BrewCommands::setAlcoholValue)))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"dump_defaults").requires(Permissions.require((String)"brewery.dump_defaults", (int)4))).executes(ctx -> BrewCommands.dumpDefaultDefinitions())));
    }

    private static int setAlcoholValue(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        double alcohol = DoubleArgumentType.getDouble(ctx, (String)"alcohol");
        float quality = FloatArgumentType.getFloat(ctx, (String)"quality");
        int r = 0;
        for (class_1297 entity : class_2186.method_9317(ctx, (String)"target")) {
            if (!(entity instanceof class_1309)) continue;
            class_1309 livingEntity = (class_1309)entity;
            AlcoholManager m = AlcoholManager.of(livingEntity);
            m.alcoholLevel = alcohol;
            m.quality = quality;
            ++r;
        }
        return r;
    }

    private static int ageContainer(CommandContext<class_2168> ctx) {
        class_2338 pos = class_2262.method_48299(ctx, (String)"position");
        Integer time = (Integer)ctx.getArgument("time", Integer.class);
        class_2586 class_25862 = ((class_2168)ctx.getSource()).method_9225().method_8321(pos);
        if (class_25862 instanceof TickableContents) {
            TickableContents tickableContents = (TickableContents)class_25862;
            tickableContents.tickContents(time.intValue());
        }
        return 0;
    }

    private static int dumpDefaultDefinitions() {
        Path dir = FabricLoader.getInstance().getGameDir().resolve("brewery_defaults_dump");
        try {
            if (!Files.exists(dir, new LinkOption[0])) {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            DefaultDefinitions.createBrews((key, type) -> {
                try {
                    Files.writeString(dir.resolve(key + ".json"), (CharSequence)gson.toJson((JsonElement)DrinkType.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, type).getOrThrow(false, x -> {})), new OpenOption[0]);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return 0;
    }

    private static int showStats(CommandContext<class_2168> ctx, class_1297 player) {
        if (player instanceof class_1309) {
            class_1309 livingEntity = (class_1309)player;
            AlcoholManager m = AlcoholManager.of(livingEntity);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"text.brewery.stats", (Object[])new Object[]{player.method_5476(), m.alcoholLevel, m.quality}), false);
        }
        return 0;
    }

    private static int createDrink(CommandContext<class_2168> context) throws CommandSyntaxException {
        int distillated;
        int age;
        double quality;
        class_2960 id = class_2232.method_9443(context, (String)"type");
        DrinkType type = BreweryInit.DRINK_TYPES.get(id);
        if (type == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Invalid type!"));
        }
        try {
            quality = DoubleArgumentType.getDouble(context, (String)"quality");
        }
        catch (Throwable t) {
            quality = 10.0;
        }
        try {
            age = (int)(DoubleArgumentType.getDouble(context, (String)"age") * 20.0);
        }
        catch (Throwable e) {
            age = 0;
        }
        try {
            distillated = BoolArgumentType.getBool(context, (String)"distillated") ? type.distillationRuns() : 0;
        }
        catch (Throwable e) {
            distillated = 0;
        }
        ((class_2168)context.getSource()).method_9207().method_7270(DrinkUtils.createDrink(id, age, quality, distillated, new class_2960("air")));
        return 1;
    }

    private static int about(CommandContext<class_2168> context) {
        for (class_2561 text : ((class_2168)context.getSource()).method_9228() instanceof class_3222 ? GenericModInfo.getAboutFull() : GenericModInfo.getAboutConsole()) {
            ((class_2168)context.getSource()).method_9226(() -> text, false);
        }
        return 1;
    }
}

