/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.brewery.other;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class TypeMapCodec<A extends CodecContainer<A>>
extends MapCodec<A> {
    private final BiMap<String, MapCodec<A>> codecs = HashBiMap.create();
    private Consumer<TypeMapCodec<A>> initConsumer;

    public TypeMapCodec() {
    }

    public TypeMapCodec(Consumer<TypeMapCodec<A>> consumer) {
        this.initConsumer = consumer;
    }

    public <T> Stream<T> keys(DynamicOps<T> ops) {
        return Stream.of(ops.createString("type"));
    }

    public <T> DataResult<A> decode(DynamicOps<T> ops, MapLike<T> input) {
        Optional type;
        if (this.initConsumer != null) {
            this.initConsumer.accept(this);
        }
        if ((type = ops.getStringValue(input.get("type")).result()).isEmpty()) {
            return DataResult.error(() -> "Missing type");
        }
        try {
            MapCodec data = (MapCodec)this.codecs.get((Object)((String)type.get()).toLowerCase(Locale.ROOT));
            if (data != null) {
                return data.decode(ops, input);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return DataResult.error(() -> "Invalid type");
    }

    public <T> RecordBuilder<T> encode(A input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
        if (this.initConsumer != null) {
            this.initConsumer.accept(this);
        }
        return input.codec().encode(input, ops, prefix.add("type", ops.createString((String)this.codecs.inverse().get(input.codec()))));
    }

    public void register(String string, MapCodec<A> codec) {
        this.codecs.put((Object)string, codec);
    }

    public static interface CodecContainer<A> {
        public MapCodec<A> codec();
    }
}

