/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.libs.me.neznamy.yamlassist;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.neznamy.tab.libs.me.neznamy.yamlassist.SyntaxError;
import me.neznamy.tab.libs.me.neznamy.yamlassist.types.BadIndentation;
import me.neznamy.tab.libs.me.neznamy.yamlassist.types.DoubleMapping;
import me.neznamy.tab.libs.me.neznamy.yamlassist.types.InvalidLine;
import me.neznamy.tab.libs.me.neznamy.yamlassist.types.InvalidList;
import me.neznamy.tab.libs.me.neznamy.yamlassist.types.MissingQuote;
import me.neznamy.tab.libs.me.neznamy.yamlassist.types.MissingSpaceBeforeValue;
import me.neznamy.tab.libs.me.neznamy.yamlassist.types.QuoteWrapRequired;
import me.neznamy.tab.libs.me.neznamy.yamlassist.types.TABIndent;
import me.neznamy.tab.libs.me.neznamy.yamlassist.types.UnknownEscape;
import me.neznamy.tab.libs.org.yaml.snakeyaml.Yaml;
import me.neznamy.tab.libs.org.yaml.snakeyaml.error.YAMLException;

public class YamlAssist {
    private static final Map<Class<? extends SyntaxError>, SyntaxError> registeredSyntaxErrors = new HashMap<Class<? extends SyntaxError>, SyntaxError>();

    public static List<String> getSuggestions(File file) {
        ArrayList<String> suggestions = new ArrayList<String>();
        try {
            if (file == null) {
                throw new IllegalArgumentException("File cannot be null");
            }
            if (!file.exists()) {
                throw new IllegalStateException("File does not exist");
            }
            FileInputStream input = new FileInputStream(file);
            try {
                new Yaml().load(input);
            }
            catch (YAMLException exception) {
                for (SyntaxError possibleError : registeredSyntaxErrors.values()) {
                    suggestions.addAll(possibleError.getSuggestions(exception, Files.readAllLines(file.toPath())));
                }
            }
            input.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return suggestions;
    }

    public static void registerSyntaxError(SyntaxError error) {
        registeredSyntaxErrors.put(error.getClass(), error);
    }

    public static <T> T getError(Class<T> clazz) {
        return (T)registeredSyntaxErrors.get(clazz);
    }

    static {
        YamlAssist.registerSyntaxError(new DoubleMapping());
        YamlAssist.registerSyntaxError(new InvalidList());
        YamlAssist.registerSyntaxError(new InvalidLine());
        YamlAssist.registerSyntaxError(new MissingQuote());
        YamlAssist.registerSyntaxError(new MissingSpaceBeforeValue());
        YamlAssist.registerSyntaxError(new QuoteWrapRequired());
        YamlAssist.registerSyntaxError(new TABIndent());
        YamlAssist.registerSyntaxError(new UnknownEscape());
        YamlAssist.registerSyntaxError(new BadIndentation());
    }
}

