/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit;

import java.util.Collection;
import me.neznamy.tab.shared.ProtocolVersion;
import me.neznamy.tab.shared.chat.EnumChatFormat;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitUtils {
    public static final boolean PRINT_EXCEPTIONS = false;
    private static boolean compatibilityIssue;

    @NotNull
    public static Player[] getOnlinePlayers() {
        Object players = Bukkit.class.getMethod("getOnlinePlayers", new Class[0]).invoke(null, new Object[0]);
        if (players instanceof Player[]) {
            return (Player[])players;
        }
        return ((Collection)players).toArray(new Player[0]);
    }

    public static void compatibilityError(@NotNull Exception exception, @NotNull String failedCheck, @Nullable String fallback, String ... missingFeatures) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)EnumChatFormat.RED);
        sb.append("[TAB] Failed to initialize minecraft fields for ");
        sb.append(failedCheck);
        sb.append(" due to a compatibility error. ");
        if (fallback != null) {
            sb.append("Using fallback solution using ").append(fallback).append(". ");
        } else {
            sb.append("No fallback solution was found. ");
        }
        if (missingFeatures.length > 0) {
            sb.append("This will result in: ");
        }
        for (int i = 0; i < missingFeatures.length; ++i) {
            sb.append("\n").append("#").append(i + 1).append(": ").append(missingFeatures[i]);
        }
        Bukkit.getConsoleSender().sendMessage(sb.toString());
        compatibilityIssue = true;
    }

    public static void sendCompatibilityMessage() {
        if (!compatibilityIssue) {
            return;
        }
        Bukkit.getConsoleSender().sendMessage((Object)((Object)EnumChatFormat.RED) + "[TAB] Please update the plugin to a version with native support for your server version for optimal experience. This plugin version was made for " + ProtocolVersion.V1_5.getFriendlyName() + " - " + ProtocolVersion.LATEST_KNOWN_VERSION.getFriendlyName() + ".");
    }

    private BukkitUtils() {
    }
}

