/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.features;

import me.neznamy.tab.api.bossbar.BossBar;
import me.neznamy.tab.platforms.bukkit.BukkitTabPlayer;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.backend.BackendTabPlayer;
import me.neznamy.tab.shared.backend.Location;
import me.neznamy.tab.shared.features.bossbar.BossBarManagerImpl;
import me.neznamy.tab.shared.features.types.WorldSwitchListener;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class WitherBossBar
extends BossBarManagerImpl
implements Listener,
WorldSwitchListener {
    private static final int WITHER_DISTANCE = 60;

    public WitherBossBar(JavaPlugin plugin) {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @Override
    public void load() {
        TAB.getInstance().getCPUManager().startRepeatingMeasuredTask(100, this.getFeatureName(), "Teleporting wither", this::teleport);
        super.load();
        this.teleport();
    }

    private void teleport() {
        for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
            if (p.getVersion().getMinorVersion() > 8) continue;
            for (BossBar line : this.getRegisteredBossBars().values()) {
                if (!line.containsPlayer(p)) continue;
                org.bukkit.Location eyeLocation = ((BukkitTabPlayer)p).getPlayer().getEyeLocation();
                org.bukkit.Location loc = eyeLocation.add(eyeLocation.getDirection().normalize().multiply(60));
                if (loc.getY() < 1.0) {
                    loc.setY(1.0);
                }
                ((BackendTabPlayer)p).getEntityView().teleportEntity(line.getUniqueId().hashCode(), new Location(loc.getX(), loc.getY(), loc.getZ()));
            }
        }
    }

    @Override
    public void unload() {
        super.unload();
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent e) {
        TabPlayer player = TAB.getInstance().getPlayer(e.getPlayer().getUniqueId());
        if (player == null) {
            return;
        }
        TAB.getInstance().getCPUManager().runMeasuredTask(this.getFeatureName(), "Player Respawn", () -> this.detectBossBarsAndSend(player));
    }

    @Override
    public void onWorldChange(@NotNull TabPlayer p, @NotNull String from, @NotNull String to) {
        for (BossBar line : this.lineValues) {
            line.removePlayer(p);
        }
        this.detectBossBarsAndSend(p);
    }

    public WitherBossBar() {
    }
}

