/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.nms;

import java.util.Arrays;
import me.neznamy.tab.shared.util.FunctionWithException;
import me.neznamy.tab.shared.util.ReflectionUtils;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

public class BukkitReflection {
    private static final String CRAFTBUKKIT_PACKAGE = Bukkit.getServer().getClass().getPackage().getName();
    private static final ServerVersion serverVersion = BukkitReflection.detectServerVersion();
    private static final boolean is1_19_3Plus = ReflectionUtils.classExists("net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket");
    private static final boolean is1_19_4Plus = ReflectionUtils.classExists("net.minecraft.network.protocol.game.ClientboundBundlePacket");
    private static final boolean is1_20_2Plus = ReflectionUtils.classExists("net.minecraft.world.scores.DisplaySlot");
    private static final boolean is1_20_3Plus = ReflectionUtils.classExists("net.minecraft.network.protocol.game.ClientboundResetScorePacket");

    private static ServerVersion detectServerVersion() {
        int minorVersion;
        FunctionWithException<String, Class<?>> classFunction = name -> Class.forName("net.minecraft." + name);
        String[] array = Bukkit.getServer().getClass().getPackage().getName().split("\\.");
        if (array.length > 3) {
            String serverPackage = array[3];
            minorVersion = Integer.parseInt(serverPackage.split("_")[1]);
            if (minorVersion < 17) {
                ClassLoader loader = BukkitReflection.class.getClassLoader();
                classFunction = name -> loader.loadClass("net.minecraft.server." + serverPackage + "." + name);
            }
        } else {
            minorVersion = Integer.parseInt(Bukkit.getBukkitVersion().split("-")[0].split("\\.")[1]);
        }
        return new ServerVersion(classFunction, minorVersion);
    }

    public static int getMinorVersion() {
        return serverVersion.getMinorVersion();
    }

    public static Class<?> getClass(String ... names) throws ClassNotFoundException {
        for (String name : names) {
            try {
                return (Class)serverVersion.getClass.apply(name);
            }
            catch (ClassNotFoundException | NullPointerException exception) {
            }
        }
        throw new ClassNotFoundException("No class found with possible names " + Arrays.toString(names));
    }

    public static Class<?> getBukkitClass(@NotNull String name) throws ClassNotFoundException {
        return Class.forName(CRAFTBUKKIT_PACKAGE + "." + name);
    }

    public static boolean is1_19_3Plus() {
        return is1_19_3Plus;
    }

    public static boolean is1_19_4Plus() {
        return is1_19_4Plus;
    }

    public static boolean is1_20_2Plus() {
        return is1_20_2Plus;
    }

    public static boolean is1_20_3Plus() {
        return is1_20_3Plus;
    }

    private static class ServerVersion {
        private final FunctionWithException<String, Class<?>> getClass;
        private final int minorVersion;

        public ServerVersion(FunctionWithException<String, Class<?>> getClass, int minorVersion) {
            this.getClass = getClass;
            this.minorVersion = minorVersion;
        }

        public FunctionWithException<String, Class<?>> getGetClass() {
            return this.getClass;
        }

        public int getMinorVersion() {
            return this.minorVersion;
        }
    }
}

