/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.tablist;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.NonNull;
import me.neznamy.tab.platforms.bukkit.BukkitTabPlayer;
import me.neznamy.tab.platforms.bukkit.nms.BukkitReflection;
import me.neznamy.tab.platforms.bukkit.nms.PacketSender;
import me.neznamy.tab.platforms.bukkit.tablist.TabListBase;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.platform.TabList;
import me.neznamy.tab.shared.util.ReflectionUtils;
import me.neznamy.tab.shared.util.TriFunctionWithException;
import org.jetbrains.annotations.Nullable;

public class PacketTabList17
extends TabListBase<String> {
    private static TriFunctionWithException<String, Boolean, Integer, Object> newPacket;
    private static PacketSender packetSender;
    @NonNull
    private final Map<UUID, String> userNames = new HashMap<UUID, String>();
    @NonNull
    private final Map<UUID, String> displayNames = new HashMap<UUID, String>();

    public PacketTabList17(@NonNull BukkitTabPlayer player) {
        super(player);
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
    }

    public static void load() throws ReflectiveOperationException {
        Class<?> PlayerInfoClass = BukkitReflection.getClass("PacketPlayOutPlayerInfo", "Packet201PlayerInfo");
        try {
            Constructor<?> newPlayerInfo = PlayerInfoClass.getConstructor(String.class, Boolean.TYPE, Integer.TYPE);
            newPacket = (xva$0, xva$1, xva$2) -> newPlayerInfo.newInstance(xva$0, xva$1, xva$2);
        }
        catch (NoSuchMethodException e) {
            Constructor<?> newPlayerInfo = PlayerInfoClass.getConstructor(new Class[0]);
            Field USERNAME = ReflectionUtils.getField(PlayerInfoClass, "username");
            Field ACTION = ReflectionUtils.getField(PlayerInfoClass, "action");
            Field PING = ReflectionUtils.getField(PlayerInfoClass, "ping");
            newPacket = (name, addOrUpdate, latency) -> {
                Object packet = newPlayerInfo.newInstance(new Object[0]);
                USERNAME.set(packet, name);
                ACTION.set(packet, addOrUpdate != false ? 3 : 4);
                PING.set(packet, latency);
                return packet;
            };
        }
        packetSender = new PacketSender();
    }

    @Override
    public void removeEntry(@NonNull UUID entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        if (!this.displayNames.containsKey(entry)) {
            return;
        }
        packetSender.sendPacket(((BukkitTabPlayer)this.player).getPlayer(), newPacket.apply(this.displayNames.get(entry), false, 0));
        this.userNames.remove(entry);
        this.displayNames.remove(entry);
    }

    @Override
    public void updateDisplayName0(@NonNull UUID entry, @Nullable String displayName) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        if (!this.displayNames.containsKey(entry)) {
            return;
        }
        packetSender.sendPacket(((BukkitTabPlayer)this.player).getPlayer(), newPacket.apply(this.displayNames.get(entry), false, 0));
        this.addEntry0(entry, this.userNames.get(entry), (TabList.Skin)null, false, 0, 0, displayName);
    }

    @Override
    public void updateLatency(@NonNull UUID entry, int latency) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        if (!this.displayNames.containsKey(entry)) {
            return;
        }
        packetSender.sendPacket(((BukkitTabPlayer)this.player).getPlayer(), newPacket.apply(this.displayNames.get(entry), true, latency));
    }

    @Override
    public void updateGameMode(@NonNull UUID entry, int gameMode) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
    }

    @Override
    public void updateListed(@NonNull UUID entry, boolean listed) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
    }

    @Override
    public void addEntry0(@NonNull UUID id, @NonNull String name, @Nullable TabList.Skin skin, boolean listed, int latency, int gameMode, @Nullable String displayName) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        String display = displayName == null ? name : displayName;
        packetSender.sendPacket(((BukkitTabPlayer)this.player).getPlayer(), newPacket.apply(display, true, latency));
        this.userNames.put(id, name);
        this.displayNames.put(id, display);
    }

    @Override
    public String toComponent(@NonNull TabComponent component) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        String name = component.toLegacyText();
        if (name.length() > 16) {
            name = name.substring(0, 16);
        }
        return name;
    }
}

