/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.tablist;

import java.util.UUID;
import java.util.function.Function;
import lombok.NonNull;
import me.neznamy.tab.platforms.bukkit.BukkitTabPlayer;
import me.neznamy.tab.platforms.bukkit.BukkitUtils;
import me.neznamy.tab.platforms.bukkit.nms.BukkitReflection;
import me.neznamy.tab.platforms.bukkit.tablist.BukkitTabList;
import me.neznamy.tab.platforms.bukkit.tablist.PacketHeaderFooter;
import me.neznamy.tab.platforms.bukkit.tablist.PacketTabList1193;
import me.neznamy.tab.platforms.bukkit.tablist.PacketTabList17;
import me.neznamy.tab.platforms.bukkit.tablist.PacketTabList18;
import me.neznamy.tab.platforms.bukkit.tablist.SkinData;
import me.neznamy.tab.shared.platform.TabList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TabListBase<C>
extends TabList<BukkitTabPlayer, C> {
    private static Function<BukkitTabPlayer, TabListBase<?>> instance;
    @Nullable
    protected static SkinData skinData;
    @Nullable
    private static PacketHeaderFooter headerFooter;

    protected TabListBase(@NotNull BukkitTabPlayer player) {
        super(player);
    }

    public static void findInstance() {
        try {
            if (BukkitReflection.is1_19_3Plus()) {
                PacketTabList1193.loadNew();
                instance = PacketTabList1193::new;
            } else if (BukkitReflection.getMinorVersion() >= 8) {
                PacketTabList18.load();
                instance = PacketTabList18::new;
            } else {
                PacketTabList17.load();
                instance = PacketTabList17::new;
            }
        }
        catch (Exception e) {
            BukkitUtils.compatibilityError(e, "tablist entry management", "Bukkit API", "Layout feature will not work", "Prevent-spectator-effect feature will not work", "Ping spoof feature will not work", "Tablist formatting missing anti-override", "Tablist formatting not supporting relational placeholders");
            instance = BukkitTabList::new;
        }
        try {
            if (BukkitReflection.getMinorVersion() >= 8) {
                headerFooter = new PacketHeaderFooter();
            }
        }
        catch (Exception e) {
            BukkitUtils.compatibilityError(e, "sending header/footer", null, "Header/footer will not work");
        }
    }

    @Override
    public void setPlayerListHeaderFooter0(@NonNull Object header, @NonNull Object footer) {
        if (header == null) {
            throw new NullPointerException("header is marked non-null but is null");
        }
        if (footer == null) {
            throw new NullPointerException("footer is marked non-null but is null");
        }
        if (headerFooter != null) {
            headerFooter.set((BukkitTabPlayer)this.player, header, footer);
        }
    }

    @Override
    public boolean containsEntry(@NonNull UUID entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        return true;
    }

    @Nullable
    public TabList.Skin getSkin() {
        if (skinData == null) {
            return null;
        }
        return skinData.getSkin(((BukkitTabPlayer)this.player).getPlayer());
    }

    public static Function<BukkitTabPlayer, TabListBase<?>> getInstance() {
        return instance;
    }
}

