/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bungeecord;

import me.neznamy.tab.platforms.bungeecord.BungeePlatform;
import me.neznamy.tab.platforms.bungeecord.BungeeTabPlayer;
import me.neznamy.tab.shared.ProtocolVersion;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.platform.EventListener;
import me.neznamy.tab.shared.platform.TabPlayer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.ChatEvent;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.event.ServerSwitchEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.event.EventHandler;
import org.jetbrains.annotations.NotNull;

public class BungeeEventListener
implements EventListener<ProxiedPlayer>,
Listener {
    @EventHandler
    public void onQuit(PlayerDisconnectEvent e) {
        this.quit(e.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onSwitch(ServerSwitchEvent e) {
        TAB tab = TAB.getInstance();
        if (tab.isPluginDisabled()) {
            return;
        }
        TabPlayer p = tab.getPlayer(e.getPlayer().getUniqueId());
        if (p != null && p.getVersion().getNetworkId() >= ProtocolVersion.V1_20_2.getNetworkId()) {
            p.getScoreboard().freeze();
            p.getBossBar().freeze();
        }
        tab.getCPUManager().runTask(() -> {
            TabPlayer player = tab.getPlayer(e.getPlayer().getUniqueId());
            if (player == null) {
                player = this.createPlayer(e.getPlayer());
                if (player.getVersion().getNetworkId() >= ProtocolVersion.V1_20_2.getNetworkId()) {
                    player.getScoreboard().freeze();
                    player.getBossBar().freeze();
                }
                tab.getFeatureManager().onJoin(player);
            } else {
                tab.getFeatureManager().onServerChange(player.getUniqueId(), e.getPlayer().getServer().getInfo().getName());
                if (player.getVersion().getNetworkId() < ProtocolVersion.V1_20_2.getNetworkId()) {
                    tab.getFeatureManager().onTabListClear(player);
                }
            }
        });
    }

    @EventHandler
    public void onCommand(ChatEvent e) {
        if (e.isCommand() && this.command(((ProxiedPlayer)e.getSender()).getUniqueId(), e.getMessage())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onPluginMessage(PluginMessageEvent e) {
        if (!e.getTag().equals("tab:bridge-5")) {
            return;
        }
        if (e.getReceiver() instanceof ProxiedPlayer) {
            e.setCancelled(true);
            this.pluginMessage(((ProxiedPlayer)e.getReceiver()).getUniqueId(), e.getData());
        }
    }

    @Override
    @NotNull
    public TabPlayer createPlayer(@NotNull ProxiedPlayer player) {
        return new BungeeTabPlayer((BungeePlatform)TAB.getInstance().getPlatform(), player);
    }
}

