/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bungeecord;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.lang.reflect.Method;
import java.util.function.Function;
import java.util.function.Supplier;
import me.neznamy.tab.platforms.bungeecord.BungeeTabPlayer;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.injection.NettyPipelineInjector;
import me.neznamy.tab.shared.platform.TabPlayer;
import me.neznamy.tab.shared.util.ReflectionUtils;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.packet.Login;
import net.md_5.bungee.protocol.packet.ScoreboardDisplay;
import net.md_5.bungee.protocol.packet.ScoreboardObjective;
import net.md_5.bungee.protocol.packet.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BungeePipelineInjector
extends NettyPipelineInjector {
    @Nullable
    private static Object directionData;
    @Nullable
    private static Method getId;
    @NotNull
    private final Class<? extends DefinedPacket>[] extraPacketClasses = new Class[]{Team.class, ScoreboardDisplay.class, ScoreboardObjective.class};
    @NotNull
    private final Supplier<DefinedPacket>[] extraPacketSuppliers = new Supplier[]{Team::new, ScoreboardDisplay::new, ScoreboardObjective::new};
    protected boolean byteBufDeserialization;

    public BungeePipelineInjector() {
        super("inbound-boss");
        boolean antiOverrideTeams = this.config().getBoolean("scoreboard-teams.enabled", true) && this.config().getBoolean("scoreboard-teams.anti-override", true);
        boolean respectOtherScoreboardPlugins = this.config().getBoolean("scoreboard.enabled", false) && this.config().getBoolean("scoreboard.respect-other-plugins", true);
        this.byteBufDeserialization = antiOverrideTeams || respectOtherScoreboardPlugins;
    }

    @Override
    @NotNull
    public Function<TabPlayer, ChannelDuplexHandler> getChannelFunction() {
        return this.byteBufDeserialization ? x$0 -> new DeserializableBungeeChannelDuplexHandler((TabPlayer)x$0) : x$0 -> new NettyPipelineInjector.TabChannelDuplexHandler((TabPlayer)x$0);
    }

    @Override
    @NotNull
    protected Channel getChannel(@NotNull TabPlayer player) {
        return ((UserConnection)((BungeeTabPlayer)player).getPlayer()).getCh().getHandle();
    }

    @Override
    public boolean isLogin(@NotNull Object packet) {
        return packet instanceof Login;
    }

    static {
        try {
            directionData = ReflectionUtils.setAccessible(Protocol.class.getDeclaredField("TO_CLIENT")).get(Protocol.GAME);
            getId = ReflectionUtils.setAccessible(Protocol.DirectionData.class.getDeclaredMethod("getId", Class.class, Integer.TYPE));
        }
        catch (ReflectiveOperationException exception) {
            TAB.getInstance().getErrorManager().criticalError("Failed to initialize bungee internal fields", exception);
        }
    }

    private class DeserializableBungeeChannelDuplexHandler
    extends NettyPipelineInjector.TabChannelDuplexHandler {
        private DeserializableBungeeChannelDuplexHandler(TabPlayer player) {
            super(player);
        }

        @Override
        public void write(@NotNull ChannelHandlerContext context, @NotNull Object packet, @NotNull ChannelPromise channelPromise) {
            long time = System.nanoTime();
            Object modifiedPacket = packet instanceof ByteBuf ? this.deserialize((ByteBuf)packet) : packet;
            TAB.getInstance().getCPUManager().addTime("Packet deserializing", "ByteBuf", System.nanoTime() - time);
            super.write(context, modifiedPacket, channelPromise);
        }

        @NotNull
        private Object deserialize(@NotNull ByteBuf buf) {
            int marker = buf.readerIndex();
            try {
                byte packetId = buf.readByte();
                for (int i = 0; i < BungeePipelineInjector.this.extraPacketClasses.length; ++i) {
                    ChannelWrapper ch = ((UserConnection)((BungeeTabPlayer)this.player).getPlayer()).getCh();
                    if (!ch.getEncodeProtocol().TO_CLIENT.hasPacket(BungeePipelineInjector.this.extraPacketClasses[i], ((ProxiedPlayer)this.player.getPlayer()).getPendingConnection().getVersion()) || packetId != this.getPacketId(((BungeeTabPlayer)this.player).getPlayer().getPendingConnection().getVersion(), BungeePipelineInjector.this.extraPacketClasses[i])) continue;
                    DefinedPacket packet = (DefinedPacket)BungeePipelineInjector.this.extraPacketSuppliers[i].get();
                    packet.read(buf, null, ((ProxiedPlayer)this.player.getPlayer()).getPendingConnection().getVersion());
                    buf.release();
                    return packet;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            buf.readerIndex(marker);
            return buf;
        }

        private int getPacketId(int protocolVersion, @NotNull Class<? extends DefinedPacket> clazz) {
            if (getId == null) {
                return -1;
            }
            return (Integer)getId.invoke(directionData, clazz, protocolVersion);
        }
    }
}

