/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bungeecord;

import com.imaginarycode.minecraft.redisbungee.RedisBungeeAPI;
import java.io.File;
import java.util.ArrayList;
import me.neznamy.tab.libs.org.bstats.bungeecord.Metrics;
import me.neznamy.tab.libs.org.bstats.charts.SimplePie;
import me.neznamy.tab.platforms.bungeecord.BungeeEventListener;
import me.neznamy.tab.platforms.bungeecord.BungeePipelineInjector;
import me.neznamy.tab.platforms.bungeecord.BungeeTAB;
import me.neznamy.tab.platforms.bungeecord.BungeeTabCommand;
import me.neznamy.tab.platforms.bungeecord.BungeeTabPlayer;
import me.neznamy.tab.platforms.bungeecord.features.BungeeRedisSupport;
import me.neznamy.tab.platforms.bungeecord.hook.BungeePremiumVanishHook;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.ChatModifier;
import me.neznamy.tab.shared.chat.EnumChatFormat;
import me.neznamy.tab.shared.chat.SimpleComponent;
import me.neznamy.tab.shared.chat.StructuredComponent;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.features.injection.PipelineInjector;
import me.neznamy.tab.shared.features.redis.RedisSupport;
import me.neznamy.tab.shared.hook.PremiumVanishHook;
import me.neznamy.tab.shared.proxy.ProxyPlatform;
import me.neznamy.tab.shared.util.ReflectionUtils;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ProxyConfig;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BungeePlatform
extends ProxyPlatform {
    @NotNull
    private final BungeeTAB plugin;

    public BungeePlatform(@NotNull BungeeTAB plugin) {
        this.plugin = plugin;
        if (ProxyServer.getInstance().getPluginManager().getPlugin("PremiumVanish") != null) {
            PremiumVanishHook.setInstance(new BungeePremiumVanishHook(this));
        }
    }

    @Override
    public void loadPlayers() {
        try {
            ProxyConfig config = ProxyServer.getInstance().getConfig();
            if (((Boolean)config.getClass().getMethod("isDisableTabListRewrite", new Class[0]).invoke((Object)config, new Object[0])).booleanValue()) {
                this.logWarn(new SimpleComponent("Waterfall's \"disable_tab_list_rewrite: true\" option may cause the plugin to not work correctly. Disable it to avoid issues."));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (ProxiedPlayer p : ProxyServer.getInstance().getPlayers()) {
            TAB.getInstance().addPlayer(new BungeeTabPlayer(this, p));
        }
    }

    @Override
    @Nullable
    public RedisSupport getRedisSupport() {
        if (ReflectionUtils.classExists("com.imaginarycode.minecraft.redisbungee.RedisBungeeAPI") && RedisBungeeAPI.getRedisBungeeApi() != null) {
            return new BungeeRedisSupport(this.plugin);
        }
        return null;
    }

    @Override
    public void logInfo(@NotNull TabComponent message) {
        this.plugin.getLogger().info(message.toLegacyText());
    }

    @Override
    public void logWarn(@NotNull TabComponent message) {
        this.plugin.getLogger().warning((Object)((Object)EnumChatFormat.RED) + message.toLegacyText());
    }

    @Override
    @NotNull
    public String getServerVersionInfo() {
        return "[BungeeCord] " + this.plugin.getProxy().getName() + " - " + this.plugin.getProxy().getVersion();
    }

    @Override
    public void registerListener() {
        ProxyServer.getInstance().getPluginManager().registerListener((Plugin)this.plugin, (Listener)new BungeeEventListener());
    }

    @Override
    public void registerCommand() {
        ProxyServer.getInstance().getPluginManager().registerCommand((Plugin)this.plugin, (Command)new BungeeTabCommand());
    }

    @Override
    public void startMetrics() {
        new Metrics(this.plugin, 10535).addCustomChart(new SimplePie("global_playerlist_enabled", () -> TAB.getInstance().getFeatureManager().isFeatureEnabled("GlobalPlayerList") ? "Yes" : "No"));
    }

    @Override
    @NotNull
    public File getDataFolder() {
        return this.plugin.getDataFolder();
    }

    @Override
    @Nullable
    public PipelineInjector createPipelineInjector() {
        return new BungeePipelineInjector();
    }

    @Override
    public void registerChannel() {
        ProxyServer.getInstance().registerChannel("tab:bridge-5");
    }

    public BaseComponent convertComponent(@NotNull TabComponent component, boolean modern) {
        if (component instanceof SimpleComponent) {
            return new TextComponent(component.toLegacyText());
        }
        StructuredComponent iComponent = (StructuredComponent)component;
        TextComponent textComponent = new TextComponent(iComponent.getText());
        ChatModifier modifier = iComponent.getModifier();
        if (modifier.getColor() != null) {
            if (modern) {
                textComponent.setColor(ChatColor.of((String)("#" + modifier.getColor().getHexCode())));
            } else {
                textComponent.setColor(ChatColor.of((String)modifier.getColor().getLegacyColor().name()));
            }
        }
        if (modifier.isBold()) {
            textComponent.setBold(Boolean.valueOf(true));
        }
        if (modifier.isItalic()) {
            textComponent.setItalic(Boolean.valueOf(true));
        }
        if (modifier.isObfuscated()) {
            textComponent.setObfuscated(Boolean.valueOf(true));
        }
        if (modifier.isStrikethrough()) {
            textComponent.setStrikethrough(Boolean.valueOf(true));
        }
        if (modifier.isUnderlined()) {
            textComponent.setUnderlined(Boolean.valueOf(true));
        }
        textComponent.setFont(modifier.getFont());
        if (!iComponent.getExtra().isEmpty()) {
            ArrayList<BaseComponent> list = new ArrayList<BaseComponent>();
            for (StructuredComponent extra : iComponent.getExtra()) {
                list.add(this.convertComponent(extra, modern));
            }
            textComponent.setExtra(list);
        }
        return textComponent;
    }
}

