/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bungeecord.tablist;

import java.util.Collection;
import java.util.UUID;
import lombok.NonNull;
import me.neznamy.tab.platforms.bungeecord.BungeeTabPlayer;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.platform.TabList;
import me.neznamy.tab.shared.util.ReflectionUtils;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.Property;
import net.md_5.bungee.protocol.packet.PlayerListHeaderFooter;
import net.md_5.bungee.protocol.packet.PlayerListItem;
import net.md_5.bungee.protocol.packet.PlayerListItemUpdate;
import net.md_5.bungee.tab.ServerUnique;
import org.jetbrains.annotations.Nullable;

public abstract class BungeeTabList
extends TabList<BungeeTabPlayer, BaseComponent> {
    private final Collection<UUID> uuids;

    protected BungeeTabList(@NonNull BungeeTabPlayer player) {
        super(player);
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.uuids = (Collection)ReflectionUtils.getField(ServerUnique.class, "uuids").get(((UserConnection)player.getPlayer()).getTabListHandler());
    }

    @Override
    public void setPlayerListHeaderFooter0(@NonNull BaseComponent header, @NonNull BaseComponent footer) {
        if (header == null) {
            throw new NullPointerException("header is marked non-null but is null");
        }
        if (footer == null) {
            throw new NullPointerException("footer is marked non-null but is null");
        }
        ((BungeeTabPlayer)this.player).sendPacket((DefinedPacket)new PlayerListHeaderFooter(header, footer));
    }

    @NonNull
    public PlayerListItem.Item item(@NonNull UUID id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        PlayerListItem.Item item = new PlayerListItem.Item();
        item.setUuid(id);
        return item;
    }

    @NonNull
    public PlayerListItem.Item entryToItem(@NonNull UUID id, @NonNull String name, @Nullable TabList.Skin skin, boolean listed, int latency, int gameMode, @Nullable BaseComponent displayName) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        PlayerListItem.Item item = this.item(id);
        item.setUsername(name);
        item.setDisplayName(displayName);
        item.setGamemode(Integer.valueOf(gameMode));
        item.setListed(Boolean.valueOf(listed));
        item.setPing(Integer.valueOf(latency));
        if (skin != null) {
            item.setProperties(new Property[]{new Property("textures", skin.getValue(), skin.getSignature())});
        } else {
            item.setProperties(new Property[0]);
        }
        return item;
    }

    public void addUuid(@NonNull UUID id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.uuids.add(id);
    }

    public void removeUuid(@NonNull UUID id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.uuids.remove(id);
    }

    @Override
    public void onPacketSend(@NonNull Object packet) {
        block8: {
            block7: {
                if (packet == null) {
                    throw new NullPointerException("packet is marked non-null but is null");
                }
                if (!(packet instanceof PlayerListItem)) break block7;
                PlayerListItem listItem = (PlayerListItem)packet;
                for (PlayerListItem.Item item : listItem.getItems()) {
                    BaseComponent expectedDisplayName;
                    if ((listItem.getAction() == PlayerListItem.Action.UPDATE_DISPLAY_NAME || listItem.getAction() == PlayerListItem.Action.ADD_PLAYER) && (expectedDisplayName = (BaseComponent)this.getExpectedDisplayName(item.getUuid())) != null) {
                        item.setDisplayName(expectedDisplayName);
                    }
                    if (listItem.getAction() == PlayerListItem.Action.UPDATE_LATENCY || listItem.getAction() == PlayerListItem.Action.ADD_PLAYER) {
                        item.setPing(Integer.valueOf(TAB.getInstance().getFeatureManager().onLatencyChange(this.player, item.getUuid(), item.getPing())));
                    }
                    if (listItem.getAction() != PlayerListItem.Action.ADD_PLAYER) continue;
                    TAB.getInstance().getFeatureManager().onEntryAdd(this.player, item.getUuid(), item.getUsername());
                }
                break block8;
            }
            if (!(packet instanceof PlayerListItemUpdate)) break block8;
            PlayerListItemUpdate update = (PlayerListItemUpdate)packet;
            for (PlayerListItem.Item item : update.getItems()) {
                BaseComponent expectedDisplayName;
                if (update.getActions().contains(PlayerListItemUpdate.Action.UPDATE_DISPLAY_NAME) && (expectedDisplayName = (BaseComponent)this.getExpectedDisplayName(item.getUuid())) != null) {
                    item.setDisplayName(expectedDisplayName);
                }
                if (update.getActions().contains(PlayerListItemUpdate.Action.UPDATE_LATENCY)) {
                    item.setPing(Integer.valueOf(TAB.getInstance().getFeatureManager().onLatencyChange(this.player, item.getUuid(), item.getPing())));
                }
                if (!update.getActions().contains(PlayerListItemUpdate.Action.ADD_PLAYER)) continue;
                TAB.getInstance().getFeatureManager().onEntryAdd(this.player, item.getUuid(), item.getUsername());
            }
        }
    }

    @Override
    public boolean containsEntry(@NonNull UUID entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        return this.uuids.contains(entry);
    }
}

