/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.fabric;

import java.io.File;
import me.lucko.fabric.api.permissions.v0.Permissions;
import me.neznamy.tab.platforms.fabric.FabricEventListener;
import me.neznamy.tab.platforms.fabric.FabricMultiVersion;
import me.neznamy.tab.platforms.fabric.FabricPipelineInjector;
import me.neznamy.tab.platforms.fabric.FabricTAB;
import me.neznamy.tab.platforms.fabric.FabricTabPlayer;
import me.neznamy.tab.platforms.fabric.features.FabricNameTagX;
import me.neznamy.tab.shared.ProtocolVersion;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.backend.BackendPlatform;
import me.neznamy.tab.shared.chat.SimpleComponent;
import me.neznamy.tab.shared.chat.StructuredComponent;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.features.injection.PipelineInjector;
import me.neznamy.tab.shared.features.nametags.NameTag;
import me.neznamy.tab.shared.features.types.TabFeature;
import me.neznamy.tab.shared.placeholders.expansion.EmptyTabExpansion;
import me.neznamy.tab.shared.placeholders.expansion.TabExpansion;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FabricPlatform
implements BackendPlatform {
    private final MinecraftServer server;
    private final boolean fabricPermissionsApi = FabricLoader.getInstance().isModLoaded("fabric-permissions-api-v0");
    private final ProtocolVersion serverVersion = ProtocolVersion.fromFriendlyName(FabricTAB.minecraftVersion);

    @Override
    public void registerUnknownPlaceholder(@NotNull String identifier) {
        this.registerDummyPlaceholder(identifier);
    }

    @Override
    public void loadPlayers() {
        for (class_3222 player : PlayerLookup.all((MinecraftServer)this.server)) {
            TAB.getInstance().addPlayer(new FabricTabPlayer(this, player));
        }
    }

    @Override
    @NotNull
    public PipelineInjector createPipelineInjector() {
        return new FabricPipelineInjector();
    }

    @Override
    @NotNull
    public NameTag getUnlimitedNameTags() {
        return new FabricNameTagX();
    }

    @Override
    @NotNull
    public TabExpansion createTabExpansion() {
        return new EmptyTabExpansion();
    }

    @Override
    @Nullable
    public TabFeature getPerWorldPlayerList() {
        return null;
    }

    @Override
    public void logInfo(@NotNull TabComponent message) {
        FabricMultiVersion.logInfo(message);
    }

    @Override
    public void logWarn(@NotNull TabComponent message) {
        FabricMultiVersion.logWarn(message);
    }

    @Override
    @NotNull
    public String getServerVersionInfo() {
        return "[Fabric] " + FabricTAB.minecraftVersion;
    }

    @Override
    public void registerListener() {
        new FabricEventListener().register();
    }

    @Override
    public void registerCommand() {
    }

    @Override
    public void startMetrics() {
    }

    @Override
    @NotNull
    public File getDataFolder() {
        return FabricLoader.getInstance().getConfigDir().resolve("tab").toFile();
    }

    public class_2561 convertComponent(@NotNull TabComponent component, boolean modern) {
        if (component instanceof SimpleComponent) {
            return FabricMultiVersion.newTextComponent(((SimpleComponent)component).getText());
        }
        StructuredComponent component1 = (StructuredComponent)component;
        class_2561 nmsComponent = FabricMultiVersion.newTextComponent(component1.getText());
        FabricMultiVersion.setStyle(nmsComponent, FabricMultiVersion.convertModifier(component1.getModifier(), modern));
        for (StructuredComponent extra : component1.getExtra()) {
            FabricMultiVersion.addSibling(nmsComponent, this.convertComponent(extra, modern));
        }
        return nmsComponent;
    }

    @Override
    public double getTPS() {
        return -1.0;
    }

    @Override
    public double getMSPT() {
        return FabricMultiVersion.getMSPT(this.server);
    }

    public boolean hasPermission(@NotNull class_2168 source, @NotNull String permission) {
        if (source.method_9259(4)) {
            return true;
        }
        return this.fabricPermissionsApi && Permissions.check((class_2172)source, (String)permission);
    }

    public FabricPlatform(MinecraftServer server) {
        this.server = server;
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    public boolean isFabricPermissionsApi() {
        return this.fabricPermissionsApi;
    }

    public ProtocolVersion getServerVersion() {
        return this.serverVersion;
    }
}

