/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.sponge8;

import java.util.Collection;
import java.util.function.Supplier;
import lombok.NonNull;
import me.neznamy.tab.platforms.sponge8.SpongeTabPlayer;
import me.neznamy.tab.shared.chat.EnumChatFormat;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.hook.AdventureHook;
import me.neznamy.tab.shared.platform.Scoreboard;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.api.scoreboard.CollisionRule;
import org.spongepowered.api.scoreboard.CollisionRules;
import org.spongepowered.api.scoreboard.Score;
import org.spongepowered.api.scoreboard.Team;
import org.spongepowered.api.scoreboard.Visibilities;
import org.spongepowered.api.scoreboard.Visibility;
import org.spongepowered.api.scoreboard.criteria.Criteria;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlot;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlots;
import org.spongepowered.api.scoreboard.objective.Objective;
import org.spongepowered.api.scoreboard.objective.displaymode.ObjectiveDisplayMode;
import org.spongepowered.api.scoreboard.objective.displaymode.ObjectiveDisplayModes;

public class SpongeScoreboard
extends Scoreboard<SpongeTabPlayer, Component> {
    private static final CollisionRule[] collisionRules = new CollisionRule[]{(CollisionRule)CollisionRules.ALWAYS.get(), (CollisionRule)CollisionRules.NEVER.get(), (CollisionRule)CollisionRules.PUSH_OTHER_TEAMS.get(), (CollisionRule)CollisionRules.PUSH_OWN_TEAM.get()};
    private static final Visibility[] visibilities = new Visibility[]{(Visibility)Visibilities.ALWAYS.get(), (Visibility)Visibilities.NEVER.get(), (Visibility)Visibilities.HIDE_FOR_OTHER_TEAMS.get(), (Visibility)Visibilities.HIDE_FOR_OWN_TEAM.get()};
    private static final DisplaySlot[] displaySlots = new DisplaySlot[]{(DisplaySlot)DisplaySlots.LIST.get(), (DisplaySlot)DisplaySlots.SIDEBAR.get(), (DisplaySlot)DisplaySlots.BELOW_NAME.get()};
    private static final ObjectiveDisplayMode[] healthDisplays = new ObjectiveDisplayMode[]{(ObjectiveDisplayMode)ObjectiveDisplayModes.INTEGER.get(), (ObjectiveDisplayMode)ObjectiveDisplayModes.HEARTS.get()};
    private final org.spongepowered.api.scoreboard.Scoreboard sb = org.spongepowered.api.scoreboard.Scoreboard.builder().build();

    public SpongeScoreboard(@NonNull SpongeTabPlayer player) {
        super(player);
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        player.getPlayer().setScoreboard(this.sb);
    }

    @Override
    public void setDisplaySlot0(int slot, @NonNull String objective) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        this.sb.objective(objective).ifPresent(o -> this.sb.updateDisplaySlot(o, displaySlots[slot]));
    }

    @Override
    public void registerObjective0(@NonNull String objectiveName, @NonNull String title, int display, @Nullable Component numberFormat) {
        if (objectiveName == null) {
            throw new NullPointerException("objectiveName is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.sb.addObjective(Objective.builder().name(objectiveName).displayName(this.adventure(title)).objectiveDisplayMode(healthDisplays[display]).criterion((Supplier)Criteria.DUMMY).build());
    }

    @Override
    public void unregisterObjective0(@NonNull String objectiveName) {
        if (objectiveName == null) {
            throw new NullPointerException("objectiveName is marked non-null but is null");
        }
        this.sb.objective(objectiveName).ifPresent(arg_0 -> ((org.spongepowered.api.scoreboard.Scoreboard)this.sb).removeObjective(arg_0));
    }

    @Override
    public void updateObjective0(@NonNull String objectiveName, @NonNull String title, int display, @Nullable Component numberFormat) {
        if (objectiveName == null) {
            throw new NullPointerException("objectiveName is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.sb.objective(objectiveName).ifPresent(obj -> {
            obj.setDisplayName(this.adventure(title));
            obj.setDisplayMode(healthDisplays[display]);
        });
    }

    @Override
    public void registerTeam0(@NonNull String name, @NonNull String prefix, @NonNull String suffix, @NonNull Scoreboard.NameVisibility visibility, @NonNull Scoreboard.CollisionRule collision, @NonNull Collection<String> players, int options, @NonNull EnumChatFormat color) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        if (suffix == null) {
            throw new NullPointerException("suffix is marked non-null but is null");
        }
        if (visibility == null) {
            throw new NullPointerException("visibility is marked non-null but is null");
        }
        if (collision == null) {
            throw new NullPointerException("collision is marked non-null but is null");
        }
        if (players == null) {
            throw new NullPointerException("players is marked non-null but is null");
        }
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        Team team = Team.builder().name(name).displayName(this.adventure(name)).prefix(this.adventure(prefix)).suffix(this.adventure(suffix)).color((NamedTextColor)NamedTextColor.NAMES.valueOr((Object)color.name(), (Object)NamedTextColor.WHITE)).allowFriendlyFire((options & 1) != 0).canSeeFriendlyInvisibles((options & 2) != 0).collisionRule(collisionRules[collision.ordinal()]).nameTagVisibility(visibilities[visibility.ordinal()]).build();
        for (String member : players) {
            team.addMember(this.adventure(member));
        }
        this.sb.registerTeam(team);
    }

    @Override
    public void unregisterTeam0(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.sb.team(name).ifPresent(Team::unregister);
    }

    @Override
    public void updateTeam0(@NonNull String name, @NonNull String prefix, @NonNull String suffix, @NonNull Scoreboard.NameVisibility visibility, @NonNull Scoreboard.CollisionRule collision, int options, @NonNull EnumChatFormat color) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        if (suffix == null) {
            throw new NullPointerException("suffix is marked non-null but is null");
        }
        if (visibility == null) {
            throw new NullPointerException("visibility is marked non-null but is null");
        }
        if (collision == null) {
            throw new NullPointerException("collision is marked non-null but is null");
        }
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        this.sb.team(name).ifPresent(team -> {
            team.setDisplayName(this.adventure(name));
            team.setPrefix(this.adventure(prefix));
            team.setSuffix(this.adventure(suffix));
            team.setColor((NamedTextColor)NamedTextColor.NAMES.valueOr((Object)color.name(), (Object)NamedTextColor.WHITE));
            team.setAllowFriendlyFire((options & 1) != 0);
            team.setCanSeeFriendlyInvisibles((options & 2) != 0);
            team.setCollisionRule(collisionRules[collision.ordinal()]);
            team.setNameTagVisibility(visibilities[visibility.ordinal()]);
        });
    }

    @Override
    public void setScore0(@NonNull String objective, @NonNull String scoreHolder, int score, @Nullable Component displayName, @Nullable Component numberFormat) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        if (scoreHolder == null) {
            throw new NullPointerException("scoreHolder is marked non-null but is null");
        }
        this.sb.objective(objective).ifPresent(o -> this.findOrCreateScore((Objective)o, scoreHolder).setScore(score));
    }

    @Override
    public void removeScore0(@NonNull String objective, @NonNull String scoreHolder) {
        if (objective == null) {
            throw new NullPointerException("objective is marked non-null but is null");
        }
        if (scoreHolder == null) {
            throw new NullPointerException("scoreHolder is marked non-null but is null");
        }
        this.sb.objective(objective).ifPresent(o -> o.removeScore(this.findOrCreateScore((Objective)o, scoreHolder)));
    }

    @NotNull
    private Score findOrCreateScore(@NotNull Objective objective, @NonNull String holder) {
        if (holder == null) {
            throw new NullPointerException("holder is marked non-null but is null");
        }
        try {
            return objective.findOrCreateScore(this.adventure(holder));
        }
        catch (NoSuchMethodError e) {
            return (Score)objective.getClass().getMethod("findOrCreateScore", String.class).invoke((Object)objective, holder);
        }
    }

    @NotNull
    private Component adventure(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        return AdventureHook.toAdventureComponent(TabComponent.optimized(text), ((SpongeTabPlayer)this.player).getVersion().supportsRGB());
    }
}

