/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.velocity;

import com.velocitypowered.api.proxy.player.TabListEntry;
import com.velocitypowered.api.util.GameProfile;
import java.util.Collections;
import java.util.Objects;
import java.util.UUID;
import lombok.NonNull;
import me.neznamy.tab.platforms.velocity.VelocityTabPlayer;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.platform.TabList;
import me.neznamy.tab.shared.platform.TabPlayer;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VelocityTabList
extends TabList<VelocityTabPlayer, Component> {
    public VelocityTabList(@NotNull VelocityTabPlayer player) {
        super(player);
    }

    @Override
    public void removeEntry(@NonNull UUID entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        ((VelocityTabPlayer)this.player).getPlayer().getTabList().removeEntry(entry);
    }

    @Override
    public void updateDisplayName0(@NonNull UUID entry, @Nullable Component displayName) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        ((VelocityTabPlayer)this.player).getPlayer().getTabList().getEntry(entry).ifPresent(e -> e.setDisplayName(displayName));
    }

    @Override
    public void updateLatency(@NonNull UUID entry, int latency) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        ((VelocityTabPlayer)this.player).getPlayer().getTabList().getEntry(entry).ifPresent(e -> e.setLatency(latency));
    }

    @Override
    public void updateGameMode(@NonNull UUID entry, int gameMode) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        ((VelocityTabPlayer)this.player).getPlayer().getTabList().getEntry(entry).ifPresent(e -> e.setGameMode(gameMode));
    }

    @Override
    public void updateListed(@NonNull UUID entry, boolean listed) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        ((VelocityTabPlayer)this.player).getPlayer().getTabList().getEntry(entry).ifPresent(e -> e.setListed(listed));
    }

    @Override
    public void addEntry0(@NonNull UUID id, @NonNull String name, @Nullable TabList.Skin skin, boolean listed, int latency, int gameMode, @Nullable Component displayName) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        TabListEntry e = TabListEntry.builder().tabList(((VelocityTabPlayer)this.player).getPlayer().getTabList()).profile(new GameProfile(id, name, skin == null ? Collections.emptyList() : Collections.singletonList(new GameProfile.Property("textures", skin.getValue(), Objects.requireNonNull(skin.getSignature()))))).listed(listed).latency(latency).gameMode(gameMode).displayName(displayName).build();
        this.removeEntry(id);
        ((VelocityTabPlayer)this.player).getPlayer().getTabList().addEntry(e);
    }

    @Override
    public void setPlayerListHeaderFooter0(@NonNull Component header, @NonNull Component footer) {
        if (header == null) {
            throw new NullPointerException("header is marked non-null but is null");
        }
        if (footer == null) {
            throw new NullPointerException("footer is marked non-null but is null");
        }
        ((VelocityTabPlayer)this.player).getPlayer().sendPlayerListHeaderAndFooter(header, footer);
    }

    @Override
    public boolean containsEntry(@NonNull UUID entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        return ((VelocityTabPlayer)this.player).getPlayer().getTabList().containsEntry(entry);
    }

    @Override
    public void checkDisplayNames() {
        for (TabPlayer target : TAB.getInstance().getOnlinePlayers()) {
            ((VelocityTabPlayer)this.player).getPlayer().getTabList().getEntry(target.getUniqueId()).ifPresent(entry -> {
                Component expectedComponent = (Component)this.getExpectedDisplayName(target);
                if (expectedComponent != null && entry.getDisplayNameComponent().orElse(null) != expectedComponent) {
                    this.displayNameWrong(entry.getProfile().getName(), this.player);
                    entry.setDisplayName(expectedComponent);
                }
            });
        }
    }
}

