/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.velocity;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.util.GameProfile;
import java.util.List;
import me.neznamy.tab.platforms.velocity.VelocityPlatform;
import me.neznamy.tab.platforms.velocity.VelocityTabList;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.platform.BossBar;
import me.neznamy.tab.shared.platform.TabList;
import me.neznamy.tab.shared.platform.impl.AdventureBossBar;
import me.neznamy.tab.shared.platform.impl.BridgeScoreboard;
import me.neznamy.tab.shared.proxy.ProxyTabPlayer;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VelocityTabPlayer
extends ProxyTabPlayer {
    @NotNull
    private final BridgeScoreboard scoreboard = new BridgeScoreboard(this);
    @NotNull
    private final VelocityTabList tabList = new VelocityTabList(this);
    @NotNull
    private final BossBar bossBar = new AdventureBossBar(this);

    public VelocityTabPlayer(@NotNull VelocityPlatform platform, @NotNull Player p) {
        super(platform, p, p.getUniqueId(), p.getUsername(), p.getCurrentServer().map(s -> s.getServerInfo().getName()).orElse("null"), p.getProtocolVersion().getProtocol());
    }

    @Override
    public boolean hasPermission0(@NotNull String permission) {
        return this.getPlayer().hasPermission(permission);
    }

    @Override
    public int getPing() {
        return (int)this.getPlayer().getPing();
    }

    @Override
    public void sendMessage(@NotNull TabComponent message) {
        this.getPlayer().sendMessage((Component)message.convert(this.getVersion()));
    }

    @Override
    @Nullable
    public TabList.Skin getSkin() {
        List properties = this.getPlayer().getGameProfile().getProperties();
        if (properties.isEmpty()) {
            return null;
        }
        return new TabList.Skin(((GameProfile.Property)properties.get(0)).getValue(), ((GameProfile.Property)properties.get(0)).getSignature());
    }

    @NotNull
    public Player getPlayer() {
        return (Player)this.player;
    }

    @Override
    public VelocityPlatform getPlatform() {
        return (VelocityPlatform)this.platform;
    }

    @Override
    public void sendPluginMessage(byte[] message) {
        try {
            this.getPlayer().getCurrentServer().ifPresent(server -> server.sendPluginMessage((ChannelIdentifier)this.getPlatform().getMCI(), message));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @NotNull
    public BridgeScoreboard getScoreboard() {
        return this.scoreboard;
    }

    @NotNull
    public VelocityTabList getTabList() {
        return this.tabList;
    }

    @Override
    @NotNull
    public BossBar getBossBar() {
        return this.bossBar;
    }
}

