/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared;

import java.util.ArrayList;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.EnumChatFormat;
import me.neznamy.tab.shared.chat.rgb.RGBUtils;
import me.neznamy.tab.shared.features.types.Refreshable;
import me.neznamy.tab.shared.placeholders.expansion.TabExpansion;
import me.neznamy.tab.shared.placeholders.types.RelationalPlaceholderImpl;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Property {
    private static long counter;
    @Nullable
    private final String name;
    @Nullable
    private final Refreshable listener;
    @NotNull
    private final TabPlayer owner;
    @NotNull
    private String originalRawValue;
    @Nullable
    private String temporaryValue;
    private String rawFormattedValue;
    private String lastReplacedValue;
    @Nullable
    private String source;
    private String[] placeholders;
    private String[] relPlaceholders;

    public Property(@Nullable String name, @Nullable Refreshable listener, @NotNull TabPlayer owner, @NotNull String rawValue, @Nullable String source) {
        this.name = name;
        this.listener = listener;
        this.owner = owner;
        this.source = source;
        this.originalRawValue = rawValue;
        this.analyze(this.originalRawValue);
    }

    private void analyze(@NotNull String value) {
        ArrayList<String> placeholders0 = new ArrayList<String>();
        ArrayList<String> relPlaceholders0 = new ArrayList<String>();
        for (String string : TAB.getInstance().getPlaceholderManager().detectPlaceholders(value)) {
            placeholders0.add(string);
            if (!string.startsWith("%rel_")) continue;
            relPlaceholders0.add(string);
        }
        String rawFormattedValue0 = value;
        for (String placeholder : placeholders0) {
            rawFormattedValue0 = this.replaceFirst(rawFormattedValue0, placeholder);
        }
        if (!placeholders0.isEmpty() && rawFormattedValue0.contains("%")) {
            int n = rawFormattedValue0.lastIndexOf(37);
            if (rawFormattedValue0.length() == n + 1 || rawFormattedValue0.charAt(n + 1) != 's') {
                StringBuilder sb = new StringBuilder(rawFormattedValue0);
                sb.insert(n + 1, "%");
                rawFormattedValue0 = sb.toString();
            }
        }
        if ((rawFormattedValue0 = RGBUtils.getInstance().applyCleanGradients(rawFormattedValue0)).contains("\\n")) {
            rawFormattedValue0 = rawFormattedValue0.replace("\\n", "\n");
        }
        this.rawFormattedValue = EnumChatFormat.color(rawFormattedValue0);
        this.placeholders = placeholders0.toArray(new String[0]);
        this.relPlaceholders = relPlaceholders0.toArray(new String[0]);
        if (this.listener != null) {
            this.listener.addUsedPlaceholders(placeholders0);
        }
        this.lastReplacedValue = this.rawFormattedValue;
        this.update();
        if (this.name != null) {
            TabExpansion tabExpansion = TAB.getInstance().getPlaceholderManager().getTabExpansion();
            tabExpansion.setPropertyValue(this.owner, this.name, this.lastReplacedValue);
            tabExpansion.setRawPropertyValue(this.owner, this.name, this.getCurrentRawValue());
        }
    }

    private String replaceFirst(String original, String searchString) {
        int index = original.indexOf(searchString);
        if (index != -1) {
            return original.substring(0, index) + "%s" + original.substring(index + searchString.length());
        }
        return original;
    }

    public void changeRawValue(@NotNull String newValue, @Nullable String newSource) {
        if (this.originalRawValue.equals(newValue)) {
            return;
        }
        this.originalRawValue = newValue;
        this.source = newSource;
        if (this.temporaryValue == null) {
            this.analyze(this.originalRawValue);
        }
    }

    @Nullable
    public String getSource() {
        return this.temporaryValue == null ? this.source : "API";
    }

    public void setTemporaryValue(@Nullable String temporaryValue) {
        if (temporaryValue != null) {
            this.temporaryValue = temporaryValue;
            this.analyze(this.temporaryValue);
        } else {
            this.temporaryValue = null;
            this.analyze(this.originalRawValue);
        }
    }

    @NotNull
    public String getCurrentRawValue() {
        return this.temporaryValue != null ? this.temporaryValue : this.originalRawValue;
    }

    @NotNull
    public String updateAndGet() {
        this.update();
        return this.get();
    }

    public boolean update() {
        String string;
        if (this.placeholders.length == 0) {
            return false;
        }
        if ("%s".equals(this.rawFormattedValue)) {
            string = TAB.getInstance().getPlaceholderManager().getPlaceholder(this.placeholders[0]).set(this.placeholders[0], this.owner);
        } else {
            Object[] values = new String[this.placeholders.length];
            for (int i = 0; i < this.placeholders.length; ++i) {
                values[i] = TAB.getInstance().getPlaceholderManager().getPlaceholder(this.placeholders[i]).set(this.placeholders[i], this.owner);
            }
            string = String.format(this.rawFormattedValue, values);
        }
        string = EnumChatFormat.color(string);
        if (!this.lastReplacedValue.equals(string)) {
            this.lastReplacedValue = string;
            if (this.name != null) {
                TAB.getInstance().getPlaceholderManager().getTabExpansion().setPropertyValue(this.owner, this.name, this.lastReplacedValue);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public String get() {
        return this.lastReplacedValue;
    }

    @NotNull
    public String getFormat(@NotNull TabPlayer viewer) {
        String format = this.lastReplacedValue;
        for (String identifier : this.relPlaceholders) {
            RelationalPlaceholderImpl pl = (RelationalPlaceholderImpl)TAB.getInstance().getPlaceholderManager().getPlaceholder(identifier);
            format = format.replace(pl.getIdentifier(), pl.getLastValue(viewer, this.owner));
        }
        for (String identifier : TAB.getInstance().getPlaceholderManager().detectPlaceholders(format)) {
            if (!identifier.startsWith("%rel_")) continue;
            RelationalPlaceholderImpl pl = (RelationalPlaceholderImpl)TAB.getInstance().getPlaceholderManager().getPlaceholder(identifier);
            format = format.replace(pl.getIdentifier(), pl.getLastValue(viewer, this.owner));
            if (this.listener == null) continue;
            this.listener.addUsedPlaceholder(identifier);
        }
        return EnumChatFormat.color(format);
    }

    public static String randomName() {
        return String.valueOf(counter++);
    }

    @NotNull
    public String getOriginalRawValue() {
        return this.originalRawValue;
    }

    @Nullable
    public String getTemporaryValue() {
        return this.temporaryValue;
    }
}

