/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.backend.features.unlimitedtags;

import java.util.UUID;
import me.neznamy.tab.shared.Property;
import me.neznamy.tab.shared.backend.BackendTabPlayer;
import me.neznamy.tab.shared.backend.EntityData;
import me.neznamy.tab.shared.backend.Location;
import me.neznamy.tab.shared.backend.features.unlimitedtags.BackendArmorStandManager;
import me.neznamy.tab.shared.backend.features.unlimitedtags.BackendNameTagX;
import me.neznamy.tab.shared.chat.EnumChatFormat;
import me.neznamy.tab.shared.chat.StructuredComponent;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;

public class ArmorStand {
    private static int idCounter = 2000000000;
    protected final BackendNameTagX manager;
    protected final BackendArmorStandManager asm;
    protected final TabPlayer owner;
    protected double offset;
    private final boolean staticOffset;
    protected final int entityId = idCounter++;
    protected final UUID uuid = UUID.randomUUID();
    protected boolean visible;
    private boolean visibleWPotion;
    protected final Property property;

    public ArmorStand(@NotNull BackendNameTagX feature, @NotNull BackendArmorStandManager asm, @NotNull TabPlayer owner, @NotNull String propertyName, double yOffset, boolean staticOffset) {
        this.manager = feature;
        this.asm = asm;
        this.owner = owner;
        this.staticOffset = staticOffset;
        this.offset = yOffset;
        this.property = owner.getProperty(propertyName);
        this.visible = this.calculateVisibility();
        this.visibleWPotion = this.visible && !owner.hasInvisibilityPotion();
    }

    public void setOffset(double offset) {
        if (this.offset == offset) {
            return;
        }
        this.offset = offset;
        for (BackendTabPlayer all : this.asm.getNearbyPlayers()) {
            this.sendTeleportPacket(all);
        }
    }

    public void refresh() {
        this.visible = this.calculateVisibility();
        this.visibleWPotion = this.visible && !this.owner.hasInvisibilityPotion();
        this.updateMetadata();
    }

    public void updateVisibility(boolean force) {
        boolean visibility;
        boolean bl = visibility = this.calculateVisibility() && !this.owner.hasInvisibilityPotion();
        if (this.visibleWPotion != visibility || force) {
            this.refresh();
        }
    }

    public void teleport() {
        for (BackendTabPlayer all : this.asm.getNearbyPlayers()) {
            this.sendTeleportPacket(all);
        }
    }

    public void teleport(BackendTabPlayer viewer) {
        if (!this.asm.isNearby(viewer) && viewer != this.owner) {
            this.asm.spawn(viewer);
        } else {
            this.sendTeleportPacket(viewer);
        }
    }

    public void move(BackendTabPlayer viewer, Location diff) {
        if (!this.asm.isNearby(viewer) && viewer != this.owner) {
            this.asm.spawn(viewer);
        } else {
            viewer.getEntityView().moveEntity(this.entityId, diff);
        }
    }

    public void spawn(BackendTabPlayer viewer) {
        this.visible = this.calculateVisibility();
        viewer.getEntityView().spawnEntity(this.entityId, this.uuid, this.manager.getArmorStandType(), new Location(this.manager.getX(this.owner), this.getYLocation(viewer), this.manager.getZ(this.owner)), this.createDataWatcher(this.property.getFormat(viewer), viewer));
    }

    public boolean calculateVisibility() {
        if (this.manager.isArmorStandsAlwaysVisible()) {
            return true;
        }
        if (this.owner.isDisguised() || this.manager.isOnBoat(this.owner)) {
            return false;
        }
        return this.owner.getGamemode() != 3 && !this.manager.hasHiddenNameTag(this.owner) && !this.property.get().isEmpty() && !this.owner.disabledUnlimitedNametags.get();
    }

    protected boolean isNameVisiblyEmpty(@NotNull String displayName) {
        String rawText;
        if (displayName.isEmpty()) {
            return true;
        }
        String string = rawText = displayName.contains(" ") ? displayName.replace(" ", "") : displayName;
        if (!(rawText.startsWith(EnumChatFormat.COLOR_STRING) || rawText.startsWith("&") || rawText.startsWith("#"))) {
            return false;
        }
        TabComponent component = TabComponent.fromColoredText(rawText);
        if (component instanceof StructuredComponent) {
            return ((StructuredComponent)component).toRawText().isEmpty();
        }
        return component.toLegacyText().isEmpty();
    }

    public double getYAdd(boolean sleeping, boolean sneaking, @NotNull TabPlayer viewer) {
        double y = this.offset;
        y = !sleeping ? (sneaking ? (viewer.getVersion().getMinorVersion() >= 15 ? (y += 1.37) : (viewer.getVersion().getMinorVersion() >= 9 ? (y += 1.52) : (y += 1.7))) : (y += viewer.getVersion().getMinorVersion() >= 9 ? 1.8 : 1.84)) : (y += viewer.getVersion().getMinorVersion() >= 9 ? 0.2 : 0.26);
        return y;
    }

    public void updateMetadata() {
        for (BackendTabPlayer viewer : this.asm.getNearbyPlayers()) {
            viewer.getEntityView().updateEntityMetadata(this.entityId, this.createDataWatcher(this.property.getFormat(viewer), viewer));
        }
    }

    public boolean shouldBeInvisibleFor(@NotNull TabPlayer viewer, @NotNull String displayName) {
        return this.isNameVisiblyEmpty(displayName) || !this.manager.canSee(viewer, this.owner) || this.manager.hasHiddenNameTag(this.owner, viewer) || this.manager.hasHiddenNameTagVisibilityView(viewer) || this.owner.hasInvisibilityPotion() && viewer.getGamemode() != 3;
    }

    public void sendTeleportPacket(@NotNull BackendTabPlayer viewer) {
        viewer.getEntityView().teleportEntity(this.entityId, new Location(this.manager.getX(this.owner), this.getYLocation(viewer), this.manager.getZ(this.owner)));
    }

    public EntityData createDataWatcher(@NotNull String displayName, @NotNull TabPlayer viewer) {
        byte flags = (byte)(this.manager.isSneaking(this.owner) ? 34 : 32);
        boolean nameVisible = !this.shouldBeInvisibleFor(viewer, displayName) && this.visible;
        return this.manager.createDataWatcher(viewer, flags, displayName, nameVisible);
    }

    public double getYLocation(@NotNull TabPlayer viewer) {
        double y = this.manager.getY(this.owner.getPlayer());
        Object vehicle = this.manager.getVehicle(this.owner);
        if (vehicle != null) {
            String type = this.manager.getEntityType(vehicle);
            double vehicleY = this.manager.getY(vehicle);
            if (type.contains("horse")) {
                y = vehicleY + 0.85;
            }
            if (type.equals("donkey")) {
                y = vehicleY + 0.525;
            }
            if (type.equals("pig")) {
                y = vehicleY + 0.325;
            }
            if (type.equals("strider")) {
                y = vehicleY + 1.15;
            }
        } else if (this.manager.isSwimming(this.owner) || this.manager.isGliding(this.owner)) {
            y = this.manager.getY(this.owner.getPlayer()) - 1.22;
        }
        return y += this.getYAdd(this.manager.isSleeping(this.owner), this.manager.isSneaking(this.owner), viewer);
    }

    public double getOffset() {
        return this.offset;
    }

    public boolean isStaticOffset() {
        return this.staticOffset;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public Property getProperty() {
        return this.property;
    }
}

