/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.backend.features.unlimitedtags;

import java.util.List;
import java.util.UUID;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.backend.BackendTabPlayer;
import me.neznamy.tab.shared.backend.EntityData;
import me.neznamy.tab.shared.backend.features.unlimitedtags.BackendArmorStandManager;
import me.neznamy.tab.shared.backend.features.unlimitedtags.PacketListener;
import me.neznamy.tab.shared.backend.features.unlimitedtags.VehicleRefresher;
import me.neznamy.tab.shared.features.nametags.unlimited.NameTagX;
import me.neznamy.tab.shared.features.types.GameModeListener;
import me.neznamy.tab.shared.features.types.PacketSendListener;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BackendNameTagX
extends NameTagX
implements GameModeListener,
PacketSendListener {
    private static final int ENTITY_TRACKING_RANGE = 48;
    private final VehicleRefresher vehicleManager = new VehicleRefresher(this);
    protected final PacketListener packetListener = new PacketListener(this);

    protected BackendNameTagX() {
        super(BackendArmorStandManager::new);
        TAB.getInstance().getFeatureManager().registerFeature("nametagx-vehicle", this.vehicleManager);
        TAB.getInstance().getFeatureManager().registerFeature("nametagx-packet", this.packetListener);
    }

    private void startVisibilityRefreshTask() {
        TAB.getInstance().getCPUManager().startRepeatingMeasuredTask(500, this.getExtraFeatureName(), "Refreshing NameTag visibility", () -> {
            for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
                if (this.isPlayerDisabled(p)) continue;
                this.getArmorStandManager(p).updateVisibility(false);
            }
        });
    }

    public BackendArmorStandManager getArmorStandManager(@NotNull TabPlayer player) {
        return (BackendArmorStandManager)player.unlimitedNametagData.armorStandManager;
    }

    @Override
    public void load() {
        super.load();
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            if (this.isPlayerDisabled(all)) continue;
            for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
                this.spawnArmorStands(viewer, all);
            }
        }
        this.startVisibilityRefreshTask();
    }

    @Override
    public void unload() {
        super.unload();
        this.unregisterListener();
    }

    @Override
    public void onJoin(@NotNull TabPlayer connectedPlayer) {
        super.onJoin(connectedPlayer);
        if (this.isPlayerDisabled(connectedPlayer)) {
            return;
        }
        for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
            this.spawnArmorStands(viewer, connectedPlayer);
            this.spawnArmorStands(connectedPlayer, viewer);
        }
    }

    @Override
    public boolean isOnBoat(@NotNull TabPlayer player) {
        return player.unlimitedNametagData.onBoat;
    }

    private void spawnArmorStands(@NotNull TabPlayer viewer, @NotNull TabPlayer target) {
        if (viewer.getVersion().getMinorVersion() < 8) {
            return;
        }
        if (target == viewer || this.isPlayerDisabled(target) || this.isDead(target)) {
            return;
        }
        if (!this.areInSameWorld(viewer, target)) {
            return;
        }
        if (this.getDistance(viewer, target) <= 48.0 && this.canSee(viewer, target) && !target.isVanished()) {
            this.getArmorStandManager(target).spawn((BackendTabPlayer)viewer);
        }
    }

    @Override
    public void onQuit(@NotNull TabPlayer disconnectedPlayer) {
        super.onQuit(disconnectedPlayer);
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            this.getArmorStandManager(all).unregisterPlayer((BackendTabPlayer)disconnectedPlayer);
        }
        disconnectedPlayer.unlimitedNametagData.armorStandManager.destroy();
    }

    @Override
    public void resumeArmorStands(@NotNull TabPlayer player) {
        if (this.isPlayerDisabled(player)) {
            return;
        }
        for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
            this.spawnArmorStands(viewer, player);
        }
    }

    @Override
    public void setNameTagPreview(@NotNull TabPlayer player, boolean status) {
        if (status) {
            this.getArmorStandManager(player).spawn((BackendTabPlayer)player);
        } else {
            this.getArmorStandManager(player).destroy((BackendTabPlayer)player);
        }
    }

    @Override
    public void pauseArmorStands(@NotNull TabPlayer player) {
        this.getArmorStandManager(player).destroy();
    }

    @Override
    public void updateNameTagVisibilityView(@NotNull TabPlayer player) {
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            this.getArmorStandManager(all).updateVisibility(true);
        }
    }

    @Override
    public void onWorldChange(@NotNull TabPlayer p, @NotNull String from, @NotNull String to) {
        super.onWorldChange(p, from, to);
        BackendArmorStandManager asm = this.getArmorStandManager(p);
        if (p.unlimitedNametagData.previewing) {
            asm.spawn((BackendTabPlayer)p);
        }
        for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
            if (!viewer.getWorld().equals(from)) continue;
            asm.destroy((BackendTabPlayer)viewer);
        }
        asm.updateMetadata();
        asm.fixArmorStandHeights();
    }

    @Override
    public void onGameModeChange(@NotNull TabPlayer player) {
        for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
            this.getArmorStandManager(player).updateMetadata((BackendTabPlayer)viewer);
        }
    }

    @Override
    public void onPacketSend(@NotNull TabPlayer receiver, @NotNull Object packet) {
        if (receiver.getVersion().getMinorVersion() < 8) {
            return;
        }
        if (!receiver.isLoaded() || receiver.disabledNametags.get() || receiver.disabledUnlimitedNametags.get()) {
            return;
        }
        this.packetListener.onPacketSend((BackendTabPlayer)receiver, packet);
    }

    public void sneak(UUID playerUUID, boolean sneaking) {
        TabPlayer p = TAB.getInstance().getPlayer(playerUUID);
        if (p == null || this.isPlayerDisabled(p)) {
            return;
        }
        TAB.getInstance().getCPUManager().runMeasuredTask(this.getExtraFeatureName(), "Player Sneak", () -> {
            BackendArmorStandManager asm = this.getArmorStandManager(p);
            if (asm != null) {
                asm.sneak(sneaking);
            } else {
                TAB.getInstance().getErrorManager().armorStandNull(p, "sneaking");
            }
        });
    }

    public void respawn(UUID playerUUID) {
        TabPlayer respawned = TAB.getInstance().getPlayer(playerUUID);
        if (respawned == null || this.isPlayerDisabled(respawned)) {
            return;
        }
        TAB.getInstance().getCPUManager().runMeasuredTask(this.getExtraFeatureName(), "Player Respawn", () -> this.getArmorStandManager(respawned).teleport());
    }

    public int getEntityId(@NotNull TabPlayer player) {
        return this.getEntityId(player.getPlayer());
    }

    public abstract double getDistance(@NotNull TabPlayer var1, @NotNull TabPlayer var2);

    public abstract boolean areInSameWorld(@NotNull TabPlayer var1, @NotNull TabPlayer var2);

    public abstract boolean canSee(@NotNull TabPlayer var1, @NotNull TabPlayer var2);

    public abstract void unregisterListener();

    @NotNull
    public abstract List<Integer> getPassengers(@NotNull Object var1);

    @Nullable
    public abstract Object getVehicle(@NotNull TabPlayer var1);

    public abstract int getEntityId(@NotNull Object var1);

    @NotNull
    public abstract String getEntityType(@NotNull Object var1);

    public abstract boolean isSneaking(@NotNull TabPlayer var1);

    public abstract boolean isSwimming(@NotNull TabPlayer var1);

    public abstract boolean isGliding(@NotNull TabPlayer var1);

    public abstract boolean isSleeping(@NotNull TabPlayer var1);

    @NotNull
    public abstract Object getArmorStandType();

    public abstract double getX(@NotNull TabPlayer var1);

    public abstract double getY(@NotNull Object var1);

    public abstract double getZ(@NotNull TabPlayer var1);

    public abstract EntityData createDataWatcher(@NotNull TabPlayer var1, byte var2, @NotNull String var3, boolean var4);

    public abstract void runInEntityScheduler(@NotNull Object var1, @NotNull Runnable var2);

    public abstract boolean isDead(@NotNull TabPlayer var1);

    public abstract boolean isFlying(@NotNull TabPlayer var1);

    public VehicleRefresher getVehicleManager() {
        return this.vehicleManager;
    }
}

