/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.chat;

import me.neznamy.tab.shared.chat.EnumChatFormat;
import me.neznamy.tab.shared.chat.TextColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChatModifier {
    @Nullable
    private TextColor color;
    private boolean bold;
    private boolean italic;
    private boolean obfuscated;
    private boolean strikethrough;
    private boolean underlined;
    @Nullable
    private String font;

    public ChatModifier(@NotNull ChatModifier modifier) {
        this.color = modifier.color;
        this.bold = modifier.bold;
        this.italic = modifier.italic;
        this.obfuscated = modifier.obfuscated;
        this.strikethrough = modifier.strikethrough;
        this.underlined = modifier.underlined;
        this.font = modifier.font;
    }

    @NotNull
    public String getMagicCodes() {
        StringBuilder builder = new StringBuilder();
        if (this.bold) {
            builder.append((Object)EnumChatFormat.BOLD);
        }
        if (this.italic) {
            builder.append((Object)EnumChatFormat.ITALIC);
        }
        if (this.obfuscated) {
            builder.append((Object)EnumChatFormat.OBFUSCATED);
        }
        if (this.strikethrough) {
            builder.append((Object)EnumChatFormat.STRIKETHROUGH);
        }
        if (this.underlined) {
            builder.append((Object)EnumChatFormat.UNDERLINE);
        }
        return builder.toString();
    }

    public int getMagicCodeBitMask() {
        int mask = 0;
        if (this.bold) {
            ++mask;
        }
        if (this.italic) {
            mask += 2;
        }
        if (this.obfuscated) {
            mask += 4;
        }
        if (this.strikethrough) {
            mask += 8;
        }
        if (this.underlined) {
            mask += 16;
        }
        return mask;
    }

    @Nullable
    public TextColor getColor() {
        return this.color;
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public boolean isObfuscated() {
        return this.obfuscated;
    }

    public boolean isStrikethrough() {
        return this.strikethrough;
    }

    public boolean isUnderlined() {
        return this.underlined;
    }

    @Nullable
    public String getFont() {
        return this.font;
    }

    public void setColor(@Nullable TextColor color) {
        this.color = color;
    }

    public void setBold(boolean bold) {
        this.bold = bold;
    }

    public void setItalic(boolean italic) {
        this.italic = italic;
    }

    public void setObfuscated(boolean obfuscated) {
        this.obfuscated = obfuscated;
    }

    public void setStrikethrough(boolean strikethrough) {
        this.strikethrough = strikethrough;
    }

    public void setUnderlined(boolean underlined) {
        this.underlined = underlined;
    }

    public void setFont(@Nullable String font) {
        this.font = font;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatModifier)) {
            return false;
        }
        ChatModifier other = (ChatModifier)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isBold() != other.isBold()) {
            return false;
        }
        if (this.isItalic() != other.isItalic()) {
            return false;
        }
        if (this.isObfuscated() != other.isObfuscated()) {
            return false;
        }
        if (this.isStrikethrough() != other.isStrikethrough()) {
            return false;
        }
        if (this.isUnderlined() != other.isUnderlined()) {
            return false;
        }
        TextColor this$color = this.getColor();
        TextColor other$color = other.getColor();
        if (this$color == null ? other$color != null : !this$color.equals(other$color)) {
            return false;
        }
        String this$font = this.getFont();
        String other$font = other.getFont();
        return !(this$font == null ? other$font != null : !this$font.equals(other$font));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatModifier;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isBold() ? 79 : 97);
        result = result * 59 + (this.isItalic() ? 79 : 97);
        result = result * 59 + (this.isObfuscated() ? 79 : 97);
        result = result * 59 + (this.isStrikethrough() ? 79 : 97);
        result = result * 59 + (this.isUnderlined() ? 79 : 97);
        TextColor $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : $color.hashCode());
        String $font = this.getFont();
        result = result * 59 + ($font == null ? 43 : $font.hashCode());
        return result;
    }

    public String toString() {
        return "ChatModifier(color=" + this.getColor() + ", bold=" + this.isBold() + ", italic=" + this.isItalic() + ", obfuscated=" + this.isObfuscated() + ", strikethrough=" + this.isStrikethrough() + ", underlined=" + this.isUnderlined() + ", font=" + this.getFont() + ")";
    }

    public ChatModifier() {
    }
}

