/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.chat;

import me.neznamy.tab.shared.chat.rgb.RGBUtils;
import me.neznamy.tab.shared.util.ComponentCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum EnumChatFormat {
    BLACK('0', 0),
    DARK_BLUE('1', 170),
    DARK_GREEN('2', 43520),
    DARK_AQUA('3', 43690),
    DARK_RED('4', 0xAA0000),
    DARK_PURPLE('5', 0xAA00AA),
    GOLD('6', 0xFFAA00),
    GRAY('7', 0xAAAAAA),
    DARK_GRAY('8', 0x555555),
    BLUE('9', 0x5555FF),
    GREEN('a', 0x55FF55),
    AQUA('b', 0x55FFFF),
    RED('c', 0xFF5555),
    LIGHT_PURPLE('d', 0xFF55FF),
    YELLOW('e', 0xFFFF55),
    WHITE('f', 0xFFFFFF),
    OBFUSCATED('k', 0),
    BOLD('l', 0),
    STRIKETHROUGH('m', 0),
    UNDERLINE('n', 0),
    ITALIC('o', 0),
    RESET('r', 0);

    public static final EnumChatFormat[] VALUES;
    public static final char COLOR_CHAR = '\u00a7';
    public static final String COLOR_STRING;
    private static final ComponentCache<String, EnumChatFormat> lastColorCache;
    private final char character;
    private final short red;
    private final short green;
    private final short blue;
    private final int rgb;
    private final String format;

    private EnumChatFormat(char character, int rgb) {
        this.character = character;
        this.rgb = rgb;
        this.format = String.valueOf('\u00a7') + character;
        this.red = (short)(rgb >> 16 & 0xFF);
        this.green = (short)(rgb >> 8 & 0xFF);
        this.blue = (short)(rgb & 0xFF);
    }

    @Nullable
    public static EnumChatFormat getByChar(char c) {
        for (EnumChatFormat format : VALUES) {
            if (format.character != c) continue;
            return format;
        }
        return null;
    }

    @NotNull
    public static EnumChatFormat lastColorsOf(@NotNull String string) {
        return lastColorCache.get(string, null);
    }

    @NotNull
    private static EnumChatFormat lastColorsOf0(@NotNull String string) {
        if (string.isEmpty()) {
            return WHITE;
        }
        String legacyText = RGBUtils.getInstance().convertRGBtoLegacy(string);
        String last = EnumChatFormat.getLastColors(legacyText);
        if (!last.isEmpty()) {
            char c = last.toCharArray()[1];
            for (EnumChatFormat e : VALUES) {
                if (e.character != c) continue;
                return e;
            }
        }
        return WHITE;
    }

    @NotNull
    public static String color(@NotNull String textToTranslate) {
        if (!textToTranslate.contains("&")) {
            return textToTranslate;
        }
        char[] b = textToTranslate.toCharArray();
        for (int i = 0; i < b.length - 1; ++i) {
            if (b[i] != '&' || "0123456789AaBbCcDdEeFfKkLlMmNnOoRrXx#".indexOf(b[i + 1]) <= -1) continue;
            b[i] = 167;
            b[i + 1] = Character.toLowerCase(b[i + 1]);
        }
        return new String(b);
    }

    @NotNull
    public static String decolor(@NotNull String text) {
        if (!text.contains(COLOR_STRING)) {
            return text;
        }
        return text.replace('\u00a7', '&');
    }

    @NotNull
    public static String getLastColors(@NotNull String input) {
        StringBuilder result = new StringBuilder();
        int length = input.length();
        for (int index = length - 1; index > -1; --index) {
            char c;
            char section = input.charAt(index);
            if (section != '\u00a7' && section != '&' || index >= length - 1 || !"0123456789AaBbCcDdEeFfKkLlMmNnOoRr".contains(String.valueOf(c = input.charAt(index + 1)))) continue;
            result.insert(0, '\u00a7');
            result.insert(1, c);
            if ("0123456789AaBbCcDdEeFfRr".contains(String.valueOf(c))) break;
        }
        return result.toString();
    }

    public String toString() {
        return this.format;
    }

    public char getCharacter() {
        return this.character;
    }

    public short getRed() {
        return this.red;
    }

    public short getGreen() {
        return this.green;
    }

    public short getBlue() {
        return this.blue;
    }

    public int getRgb() {
        return this.rgb;
    }

    public String getFormat() {
        return this.format;
    }

    static {
        VALUES = EnumChatFormat.values();
        COLOR_STRING = String.valueOf('\u00a7');
        lastColorCache = new ComponentCache<String, EnumChatFormat>(1000, (string, version) -> EnumChatFormat.lastColorsOf0(string));
    }
}

