/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.chat;

import me.neznamy.tab.shared.chat.EnumChatFormat;
import org.jetbrains.annotations.NotNull;

public class TextColor {
    private static final TextColor[] legacyColors = new TextColor[]{new TextColor(EnumChatFormat.BLACK), new TextColor(EnumChatFormat.DARK_BLUE), new TextColor(EnumChatFormat.DARK_GREEN), new TextColor(EnumChatFormat.DARK_AQUA), new TextColor(EnumChatFormat.DARK_RED), new TextColor(EnumChatFormat.DARK_PURPLE), new TextColor(EnumChatFormat.GOLD), new TextColor(EnumChatFormat.GRAY), new TextColor(EnumChatFormat.DARK_GRAY), new TextColor(EnumChatFormat.BLUE), new TextColor(EnumChatFormat.GREEN), new TextColor(EnumChatFormat.AQUA), new TextColor(EnumChatFormat.RED), new TextColor(EnumChatFormat.LIGHT_PURPLE), new TextColor(EnumChatFormat.YELLOW), new TextColor(EnumChatFormat.WHITE)};
    private int rgb = -1;
    private EnumChatFormat legacyColor;
    private String hexCode;
    private boolean legacyColorForced;

    public TextColor(@NotNull String hexCode) {
        this.hexCode = hexCode;
    }

    public TextColor(@NotNull String hexCode, @NotNull EnumChatFormat legacyColor) {
        this.hexCode = hexCode;
        this.legacyColorForced = true;
        this.legacyColor = legacyColor;
    }

    private TextColor(@NotNull EnumChatFormat legacyColor) {
        this.rgb = legacyColor.getRgb();
        this.legacyColor = legacyColor;
        this.hexCode = String.format("%06X", legacyColor.getRgb());
        this.legacyColorForced = true;
    }

    public TextColor(int red, int green, int blue) {
        this.rgb = (red << 16) + (green << 8) + blue;
    }

    private EnumChatFormat loadClosestColor() {
        double minMaxDist = 9999.0;
        EnumChatFormat closestColor = EnumChatFormat.WHITE;
        for (EnumChatFormat color : EnumChatFormat.VALUES) {
            int rDiff = Math.abs(color.getRed() - this.getRed());
            int gDiff = Math.abs(color.getGreen() - this.getGreen());
            int bDiff = Math.abs(color.getBlue() - this.getBlue());
            double maxDist = rDiff;
            if ((double)gDiff > maxDist) {
                maxDist = gDiff;
            }
            if ((double)bDiff > maxDist) {
                maxDist = bDiff;
            }
            if (!(maxDist < minMaxDist)) continue;
            minMaxDist = maxDist;
            closestColor = color;
        }
        return closestColor;
    }

    public int getRed() {
        return this.getRgb() >> 16 & 0xFF;
    }

    public int getGreen() {
        return this.getRgb() >> 8 & 0xFF;
    }

    public int getBlue() {
        return this.getRgb() & 0xFF;
    }

    public int getRgb() {
        if (this.rgb == -1) {
            this.rgb = Integer.parseInt(this.hexCode, 16);
        }
        return this.rgb;
    }

    @NotNull
    public EnumChatFormat getLegacyColor() {
        if (this.legacyColor == null) {
            this.legacyColor = this.loadClosestColor();
        }
        return this.legacyColor;
    }

    @NotNull
    public String getHexCode() {
        if (this.hexCode == null) {
            this.hexCode = String.format("%06X", this.rgb);
        }
        return this.hexCode;
    }

    public static TextColor legacy(@NotNull EnumChatFormat format) {
        return legacyColors[format.ordinal()];
    }

    public boolean isLegacyColorForced() {
        return this.legacyColorForced;
    }
}

