/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.chat.rgb;

import java.util.ArrayList;
import java.util.regex.Pattern;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.chat.rgb.format.BukkitFormat;
import me.neznamy.tab.shared.chat.rgb.format.CMIFormat;
import me.neznamy.tab.shared.chat.rgb.format.HtmlFormat;
import me.neznamy.tab.shared.chat.rgb.format.KyoriFormat;
import me.neznamy.tab.shared.chat.rgb.format.MiniMessageFormat;
import me.neznamy.tab.shared.chat.rgb.format.RGBFormatter;
import me.neznamy.tab.shared.chat.rgb.format.UnnamedFormat1;
import me.neznamy.tab.shared.chat.rgb.gradient.CMIGradient;
import me.neznamy.tab.shared.chat.rgb.gradient.CommonGradient;
import me.neznamy.tab.shared.chat.rgb.gradient.GradientPattern;
import me.neznamy.tab.shared.chat.rgb.gradient.NexEngineGradient;
import me.neznamy.tab.shared.util.ReflectionUtils;
import org.jetbrains.annotations.NotNull;

public class RGBUtils {
    private static final RGBUtils instance = new RGBUtils();
    private final RGBFormatter[] formats;
    private final GradientPattern[] gradients;

    public RGBUtils() {
        ArrayList<RGBFormatter> list = new ArrayList<RGBFormatter>();
        if (ReflectionUtils.classExists("net.kyori.adventure.text.minimessage.MiniMessage") && ReflectionUtils.classExists("net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer")) {
            list.add(new MiniMessageFormat());
        }
        list.add(new BukkitFormat());
        list.add(new CMIFormat());
        list.add(new UnnamedFormat1());
        list.add(new HtmlFormat());
        list.add(new KyoriFormat());
        this.formats = list.toArray(new RGBFormatter[0]);
        this.gradients = new GradientPattern[]{new CMIGradient(), new CommonGradient(Pattern.compile("<#[0-9a-fA-F]{6}>[^<]*</#[0-9a-fA-F]{6}>"), Pattern.compile("<#[0-9a-fA-F]{6}\\|.>[^<]*</#[0-9a-fA-F]{6}>"), "<#", 9, 2, 9, 7), new CommonGradient(Pattern.compile("<\\$#[0-9a-fA-F]{6}>[^<]*<\\$#[0-9a-fA-F]{6}>"), Pattern.compile("<\\$#[0-9a-fA-F]{6}\\|.>[^<]*<\\$#[0-9a-fA-F]{6}>"), "<$", 10, 3, 10, 7), new NexEngineGradient()};
    }

    @NotNull
    public String applyFormats(@NotNull String text) {
        String replaced = text;
        for (GradientPattern pattern : this.gradients) {
            replaced = pattern.applyPattern(replaced, false);
        }
        for (RGBFormatter formatter : this.formats) {
            replaced = formatter.reformat(replaced);
        }
        return replaced;
    }

    @NotNull
    public String applyCleanGradients(@NotNull String text) {
        String replaced = text;
        for (GradientPattern pattern : this.gradients) {
            replaced = pattern.applyPattern(replaced, true);
        }
        return replaced;
    }

    @NotNull
    public String convertRGBtoLegacy(@NotNull String text) {
        return TabComponent.fromColoredText(text).toLegacyText();
    }

    public static RGBUtils getInstance() {
        return instance;
    }
}

