/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.chat.rgb.gradient;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.neznamy.tab.shared.chat.EnumChatFormat;
import me.neznamy.tab.shared.chat.TextColor;
import me.neznamy.tab.shared.chat.rgb.gradient.GradientPattern;
import org.jetbrains.annotations.NotNull;

public class CommonGradient
implements GradientPattern {
    @NotNull
    private final Pattern pattern;
    @NotNull
    private final Pattern legacyPattern;
    @NotNull
    private final String containCheck;
    private final int legacyCharPosition;
    private final int startColorStart;
    private final int messageStart;
    private final int endColorStartSub;

    @Override
    public String applyPattern(@NotNull String text, boolean ignorePlaceholders) {
        String format;
        if (!text.contains(this.containCheck)) {
            return text;
        }
        String replaced = text;
        Matcher m = this.legacyPattern.matcher(replaced);
        while (m.find()) {
            format = m.group();
            EnumChatFormat legacyColor = EnumChatFormat.getByChar(format.charAt(this.legacyCharPosition));
            if (ignorePlaceholders && format.contains("%") || legacyColor == null) continue;
            TextColor start = new TextColor(format.substring(this.startColorStart, this.startColorStart + 6), legacyColor);
            String message = format.substring(this.messageStart + 2, format.length() - 10);
            TextColor end = new TextColor(format.substring(format.length() - this.endColorStartSub, format.length() - this.endColorStartSub + 6));
            String applied = this.asGradient(start, message, end);
            replaced = replaced.replace(format, applied);
        }
        m = this.pattern.matcher(replaced);
        while (m.find()) {
            format = m.group();
            if (ignorePlaceholders && format.contains("%")) continue;
            TextColor start = new TextColor(format.substring(this.startColorStart, this.startColorStart + 6));
            String message = format.substring(this.messageStart, format.length() - 10);
            TextColor end = new TextColor(format.substring(format.length() - this.endColorStartSub, format.length() - this.endColorStartSub + 6));
            String applied = this.asGradient(start, message, end);
            replaced = replaced.replace(format, applied);
        }
        return replaced;
    }

    public CommonGradient(@NotNull Pattern pattern, @NotNull Pattern legacyPattern, @NotNull String containCheck, int legacyCharPosition, int startColorStart, int messageStart, int endColorStartSub) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        if (legacyPattern == null) {
            throw new NullPointerException("legacyPattern is marked non-null but is null");
        }
        if (containCheck == null) {
            throw new NullPointerException("containCheck is marked non-null but is null");
        }
        this.pattern = pattern;
        this.legacyPattern = legacyPattern;
        this.containCheck = containCheck;
        this.legacyCharPosition = legacyCharPosition;
        this.startColorStart = startColorStart;
        this.messageStart = messageStart;
        this.endColorStartSub = endColorStartSub;
    }
}

