/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import me.neznamy.tab.shared.Property;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.EnumChatFormat;
import me.neznamy.tab.shared.command.SubCommand;
import me.neznamy.tab.shared.config.file.ConfigurationFile;
import me.neznamy.tab.shared.features.nametags.unlimited.NameTagX;
import me.neznamy.tab.shared.features.sorting.Sorting;
import me.neznamy.tab.shared.platform.TabPlayer;
import me.neznamy.tab.shared.proxy.ProxyTabPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebugCommand
extends SubCommand {
    public DebugCommand() {
        super("debug", "tab.debug");
    }

    @Override
    public void execute(@Nullable TabPlayer sender, @NotNull String[] args) {
        TabPlayer analyzed = null;
        if (args.length > 0 && (analyzed = TAB.getInstance().getPlayer(args[0])) == null) {
            this.sendMessage(sender, this.getMessages().getPlayerNotFound(args[0]));
            return;
        }
        if (analyzed == null && sender != null) {
            analyzed = sender;
        }
        this.debug(sender, analyzed);
    }

    private void debug(@Nullable TabPlayer sender, @Nullable TabPlayer analyzed) {
        TAB tab = TAB.getInstance();
        String separator = "&7&m>-------------------------------<";
        this.sendMessage(sender, "&3[TAB] &a&lShowing debug information");
        this.sendMessage(sender, separator);
        this.sendMessage(sender, "&6Server version: &b" + tab.getPlatform().getServerVersionInfo());
        this.sendMessage(sender, "&6Plugin version: &b4.1.7");
        this.sendMessage(sender, "&6Permission plugin: &b" + TAB.getInstance().getGroupManager().getPermissionPlugin());
        this.sendMessage(sender, "&6Permission group choice logic: &b" + this.getGroupChoiceLogic());
        this.sendMessage(sender, "&6Sorting system: &b" + this.getSortingType());
        this.sendMessage(sender, "&6Storage type: &b" + (tab.getConfiguration().getGroups() instanceof ConfigurationFile ? "File" : "MySQL"));
        this.sendMessage(sender, separator);
        if (analyzed == null) {
            return;
        }
        if (!analyzed.isLoaded()) {
            this.sendMessage(sender, "&cThe specified player is not loaded. This is either because player failed to load due to an error (see TAB's folder for errors.log file) or the plugin is overloaded (see /tab cpu).");
            return;
        }
        this.sendMessage(sender, "&ePlayer: &a" + analyzed.getName());
        this.sendMessage(sender, "&ePlayer version: &a" + analyzed.getVersion().getFriendlyName());
        if (analyzed instanceof ProxyTabPlayer) {
            char versionRequired = "tab:bridge-5".charAt("tab:bridge-5".length() - 1);
            this.sendMessage(sender, "&eBridge connection: " + (((ProxyTabPlayer)analyzed).isBridgeConnected() ? "&aConnected" : "&cNot connected (requires Bridge version " + versionRequired + ".x.x installed)"));
        }
        this.sendMessage(sender, this.getGroup(analyzed));
        this.sendMessage(sender, this.getTeamName(analyzed));
        this.sendMessage(sender, this.getTeamNameNote(analyzed));
        if (tab.getFeatureManager().isFeatureEnabled("PlayerList")) {
            this.showProperty(sender, analyzed, "tabprefix", analyzed.disabledPlayerList.get());
            this.showProperty(sender, analyzed, "tabsuffix", analyzed.disabledPlayerList.get());
            this.showProperty(sender, analyzed, "customtabname", analyzed.disabledPlayerList.get());
        } else {
            this.sendMessage(sender, "&atabprefix: &cDisabled");
            this.sendMessage(sender, "&atabsuffix: &cDisabled");
            this.sendMessage(sender, "&acustomtabname: &cDisabled");
        }
        if (tab.getNameTagManager() != null) {
            this.showProperty(sender, analyzed, "tagprefix", analyzed.disabledNametags.get());
            this.showProperty(sender, analyzed, "tagsuffix", analyzed.disabledNametags.get());
            NameTagX nameTagX = (NameTagX)TAB.getInstance().getFeatureManager().getFeature("NameTagX");
            if (nameTagX != null) {
                boolean disabledUnlimited = nameTagX.isPlayerDisabled(analyzed);
                for (String line : this.getExtraLines()) {
                    this.showProperty(sender, analyzed, line, disabledUnlimited);
                }
            }
        } else {
            this.sendMessage(sender, "&atagprefix: &cDisabled");
            this.sendMessage(sender, "&atagsuffix: &cDisabled");
        }
        this.sendMessage(sender, separator);
    }

    @NotNull
    private String getGroupChoiceLogic() {
        if (TAB.getInstance().getGroupManager().isGroupsByPermissions()) {
            return "Permissions";
        }
        return "Primary group";
    }

    @NotNull
    private String getSortingType() {
        Sorting sorting = (Sorting)TAB.getInstance().getFeatureManager().getFeature("sorting");
        if (sorting != null) {
            return sorting.typesToString();
        }
        return "&cDISABLED";
    }

    @NotNull
    private String getGroup(@NotNull TabPlayer analyzed) {
        if (TAB.getInstance().getGroupManager().isGroupsByPermissions()) {
            return "&eHighest group permission: &8tab.group.&a" + analyzed.getGroup();
        }
        return "&ePrimary permission group: &a" + analyzed.getGroup();
    }

    @NotNull
    private String getTeamName(@NotNull TabPlayer analyzed) {
        Sorting sorting = (Sorting)TAB.getInstance().getFeatureManager().getFeature("sorting");
        if (sorting == null) {
            return "";
        }
        if (TAB.getInstance().getNameTagManager() != null && analyzed.disabledNametags.get()) {
            return "&eTeam name: &cSorting is disabled in player's world/server";
        }
        return "&eTeam name: &a" + (TAB.getInstance().getFeatureManager().isFeatureEnabled("layout") ? analyzed.sortingData.fullTeamName : analyzed.sortingData.getShortTeamName());
    }

    @NotNull
    private String getTeamNameNote(@NotNull TabPlayer analyzed) {
        if (analyzed.sortingData == null) {
            return "";
        }
        if (TAB.getInstance().getNameTagManager() != null && analyzed.disabledNametags.get()) {
            return "";
        }
        return "&eSorting note: &r" + analyzed.sortingData.teamNameNote;
    }

    @NotNull
    public List<String> getExtraLines() {
        if (!TAB.getInstance().getFeatureManager().isFeatureEnabled("NameTagX")) {
            return Collections.emptyList();
        }
        ArrayList<String> lines = new ArrayList<String>(TAB.getInstance().getConfiguration().getConfig().getStringList("scoreboard-teams.unlimited-nametag-mode.dynamic-lines"));
        Map staticLines = TAB.getInstance().getConfiguration().getConfig().getConfigurationSection("scoreboard-teams.unlimited-nametag-mode.static-lines");
        lines.addAll(staticLines.keySet());
        lines.remove("nametag");
        lines.add("customtagname");
        return lines;
    }

    private void showProperty(@Nullable TabPlayer sender, @NotNull TabPlayer analyzed, @NotNull String property, boolean disabled) {
        if (disabled) {
            this.sendMessage(sender, "&a" + property + ": &cDisabled in player's world/server");
        } else {
            Property pr = analyzed.getProperty(property);
            String rawValue = EnumChatFormat.decolor(pr.getCurrentRawValue());
            String value = String.format(EnumChatFormat.color("&a%s: &e\"&r%s&r&e\" &7(Source: %s)"), property, rawValue, pr.getSource());
            this.sendRawMessage(sender, value);
        }
    }

    @Override
    @NotNull
    public List<String> complete(@Nullable TabPlayer sender, @NotNull String[] arguments) {
        return arguments.length == 1 ? this.getOnlinePlayers(arguments[0]) : new ArrayList<String>();
    }
}

