/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.command;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.rowset.CachedRowSet;
import me.neznamy.tab.libs.org.yaml.snakeyaml.error.YAMLException;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.command.SubCommand;
import me.neznamy.tab.shared.config.Configs;
import me.neznamy.tab.shared.config.PropertyConfiguration;
import me.neznamy.tab.shared.config.file.YamlPropertyConfigurationFile;
import me.neznamy.tab.shared.config.mysql.MySQL;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MySQLCommand
extends SubCommand {
    protected MySQLCommand() {
        super("mysql", null);
    }

    @Override
    public void execute(@Nullable TabPlayer sender, @NotNull String[] args) {
        if (args.length == 0) {
            this.sendMessages(sender, this.getMessages().getMySQLHelpMenu());
            return;
        }
        if (args[0].equalsIgnoreCase("download")) {
            if (this.hasPermission(sender, "tab.mysql.download")) {
                this.download(sender);
            } else {
                this.sendMessage(sender, this.getMessages().getNoPermission());
            }
        } else if (args[0].equalsIgnoreCase("upload")) {
            if (this.hasPermission(sender, "tab.mysql.upload")) {
                this.upload(sender);
            } else {
                this.sendMessage(sender, this.getMessages().getNoPermission());
            }
        } else {
            for (String message : this.getMessages().getMySQLHelpMenu()) {
                this.sendMessage(sender, message);
            }
        }
    }

    private void download(@Nullable TabPlayer sender) {
        MySQL mysql = TAB.getInstance().getConfiguration().getMysql();
        if (mysql == null) {
            this.sendMessage(sender, this.getMessages().getMySQLFailNotEnabled());
            return;
        }
        TAB.getInstance().getCPUManager().runTask(() -> {
            try {
                YamlPropertyConfigurationFile groupFile = new YamlPropertyConfigurationFile(Configs.class.getClassLoader().getResourceAsStream("config/groups.yml"), new File(TAB.getInstance().getDataFolder(), "groups.yml"));
                YamlPropertyConfigurationFile userFile = new YamlPropertyConfigurationFile(Configs.class.getClassLoader().getResourceAsStream("config/users.yml"), new File(TAB.getInstance().getDataFolder(), "users.yml"));
                CachedRowSet crs = mysql.getCRS("select * from tab_groups", new Object[0]);
                while (crs.next()) {
                    groupFile.setProperty(crs.getString("group"), crs.getString("property"), crs.getString("server"), crs.getString("world"), crs.getString("value"));
                }
                crs = mysql.getCRS("select * from tab_users", new Object[0]);
                while (crs.next()) {
                    userFile.setProperty(crs.getString("user"), crs.getString("property"), crs.getString("server"), crs.getString("world"), crs.getString("value"));
                }
                this.sendMessage(sender, this.getMessages().getMySQLDownloadSuccess());
            }
            catch (IOException | SQLException | YAMLException e) {
                this.sendMessage(sender, this.getMessages().getMySQLFailError());
                TAB.getInstance().getErrorManager().criticalError("MySQL download failed", e);
            }
        });
    }

    private void upload(@Nullable TabPlayer sender) {
        MySQL mysql = TAB.getInstance().getConfiguration().getMysql();
        if (mysql == null) {
            this.sendMessage(sender, this.getMessages().getMySQLFailNotEnabled());
            return;
        }
        TAB.getInstance().getCPUManager().runTask(() -> {
            try {
                YamlPropertyConfigurationFile groupFile = new YamlPropertyConfigurationFile(Configs.class.getClassLoader().getResourceAsStream("config/groups.yml"), new File(TAB.getInstance().getDataFolder(), "config/groups.yml"));
                YamlPropertyConfigurationFile userFile = new YamlPropertyConfigurationFile(Configs.class.getClassLoader().getResourceAsStream("config/users.yml"), new File(TAB.getInstance().getDataFolder(), "config/users.yml"));
                this.upload(groupFile, TAB.getInstance().getConfiguration().getGroups());
                this.upload(userFile, TAB.getInstance().getConfiguration().getUsers());
                this.sendMessage(sender, this.getMessages().getMySQLUploadSuccess());
            }
            catch (IOException | YAMLException e) {
                this.sendMessage(sender, this.getMessages().getMySQLFailError());
                TAB.getInstance().getErrorManager().criticalError("MySQL upload failed", e);
            }
        });
    }

    private void upload(@NotNull YamlPropertyConfigurationFile file, @NotNull PropertyConfiguration mysqlTable) {
        for (String name : file.getAllEntries()) {
            for (Map.Entry<String, Object> entry : file.getGlobalSettings(name).entrySet()) {
                mysqlTable.setProperty(name, entry.getKey(), null, null, this.toString(entry.getValue()));
            }
            for (Map.Entry<String, Object> entry : file.getPerWorldSettings(name).entrySet()) {
                if (entry.getValue() == null) continue;
                for (Map.Entry property : ((Map)entry.getValue()).entrySet()) {
                    mysqlTable.setProperty(name, (String)property.getKey(), null, entry.getKey(), this.toString(property.getValue()));
                }
            }
            for (Map.Entry<String, Object> entry : file.getPerServerSettings(name).entrySet()) {
                if (entry.getValue() == null) continue;
                for (Map.Entry property : ((Map)entry.getValue()).entrySet()) {
                    mysqlTable.setProperty(name, (String)property.getKey(), entry.getKey(), null, this.toString(property.getValue()));
                }
            }
        }
    }

    private String toString(@NotNull Object obj) {
        if (obj instanceof List) {
            return ((List)obj).stream().map(Object::toString).collect(Collectors.joining("\n"));
        }
        return obj.toString();
    }

    @Override
    @NotNull
    public List<String> complete(@Nullable TabPlayer sender, @NotNull String[] arguments) {
        return this.getStartingArgument(Arrays.asList("download", "upload"), arguments[0]);
    }
}

