/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.config;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import me.neznamy.tab.shared.FeatureManager;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.config.Converter;
import me.neznamy.tab.shared.config.MessageFile;
import me.neznamy.tab.shared.config.PropertyConfiguration;
import me.neznamy.tab.shared.config.file.ConfigurationFile;
import me.neznamy.tab.shared.config.file.YamlConfigurationFile;
import me.neznamy.tab.shared.config.file.YamlPropertyConfigurationFile;
import me.neznamy.tab.shared.config.mysql.MySQL;
import me.neznamy.tab.shared.config.mysql.MySQLGroupConfiguration;
import me.neznamy.tab.shared.config.mysql.MySQLUserConfiguration;
import me.neznamy.tab.shared.features.GlobalPlayerList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Configs {
    private final ConfigurationFile config = new YamlConfigurationFile(this.getClass().getClassLoader().getResourceAsStream("config/config.yml"), new File(TAB.getInstance().getDataFolder(), "config.yml"));
    private final boolean bukkitPermissions = TAB.getInstance().getPlatform().isProxy() && this.config.getBoolean("use-bukkit-permissions-manager", false);
    private final boolean debugMode = this.config.getBoolean("debug", false);
    private final boolean onlineUuidInTabList = this.config.getBoolean("use-online-uuid-in-tablist", true);
    private final boolean pipelineInjection = this.getSecretOption("pipeline-injection", true);
    private final String serverName = this.getSecretOption("server-name", "N/A");
    private final int permissionRefreshInterval = this.config.getInt("permission-refresh-interval", 1000);
    private final ConfigurationFile animationFile = new YamlConfigurationFile(this.getClass().getClassLoader().getResourceAsStream("config/animations.yml"), new File(TAB.getInstance().getDataFolder(), "animations.yml"));
    private final MessageFile messages = new MessageFile();
    private ConfigurationFile playerdata;
    private PropertyConfiguration groups;
    private PropertyConfiguration users;
    private MySQL mysql;

    public Configs() throws IOException {
        Converter converter = new Converter();
        converter.convert2810to290(this.animationFile);
        converter.convert292to300(this.config);
        converter.convert301to302(this.config);
        converter.convert331to332(this.config);
        converter.convert332to400(this.config);
        converter.convert403to404(this.config);
        converter.convert409to410(this.config);
        if (this.config.getBoolean("mysql.enabled", false)) {
            try {
                try {
                    Class.forName("com.mysql.cj.jdbc.Driver");
                }
                catch (ClassNotFoundException e) {
                    Class.forName("com.mysql.jdbc.Driver");
                }
                this.mysql = new MySQL(this.config.getString("mysql.host", "127.0.0.1"), this.config.getInt("mysql.port", 3306), this.config.getString("mysql.database", "tab"), this.config.getString("mysql.username", "user"), this.config.getString("mysql.password", "password"), this.config.getBoolean("mysql.useSSL", true));
                this.mysql.openConnection();
                this.groups = new MySQLGroupConfiguration(this.mysql);
                this.users = new MySQLUserConfiguration(this.mysql);
                return;
            }
            catch (ClassNotFoundException | SQLException e) {
                TAB.getInstance().getErrorManager().mysqlConnectionFailed(e);
            }
        }
        this.groups = new YamlPropertyConfigurationFile(this.getClass().getClassLoader().getResourceAsStream("config/groups.yml"), new File(TAB.getInstance().getDataFolder(), "groups.yml"));
        this.users = new YamlPropertyConfigurationFile(this.getClass().getClassLoader().getResourceAsStream("config/users.yml"), new File(TAB.getInstance().getDataFolder(), "users.yml"));
        TAB.getInstance().getConfigHelper().hint().checkForRedundantElseReplacement(this.config.getConfigurationSection("placeholder-output-replacements"));
    }

    @NotNull
    public <T> T getSecretOption(@NotNull String path, @NotNull T defaultValue) {
        Object value = this.config.getObject(path);
        return (T)(value == null ? defaultValue : value);
    }

    public ConfigurationFile getPlayerDataFile() {
        if (this.playerdata == null) {
            File file = new File(TAB.getInstance().getDataFolder(), "playerdata.yml");
            try {
                if (file.exists() || file.createNewFile()) {
                    this.playerdata = new YamlConfigurationFile(null, file);
                }
            }
            catch (IOException e) {
                TAB.getInstance().getErrorManager().criticalError("Failed to load playerdata.yml", e);
            }
        }
        return this.playerdata;
    }

    public String getGroup(@NotNull List<Object> serverGroups, @Nullable String element) {
        if (serverGroups.isEmpty() || element == null) {
            return element;
        }
        for (Object worldGroup : serverGroups) {
            for (String definedWorld : worldGroup.toString().split(";")) {
                if (!(definedWorld.endsWith("*") ? element.toLowerCase().startsWith(definedWorld.substring(0, definedWorld.length() - 1).toLowerCase()) : (definedWorld.startsWith("*") ? element.toLowerCase().endsWith(definedWorld.substring(1).toLowerCase()) : element.equalsIgnoreCase(definedWorld)))) continue;
                return worldGroup.toString();
            }
        }
        return element;
    }

    public String getServerGroup(@NotNull List<Object> serverGroups, @Nullable String server) {
        String globalGroup = this.tryServerGroup(serverGroups, server);
        if (globalGroup != null) {
            return globalGroup;
        }
        return this.getGroup(serverGroups, server);
    }

    @Nullable
    private String tryServerGroup(@NotNull List<Object> serverGroups, @Nullable String server) {
        if (serverGroups.isEmpty() || server == null) {
            return null;
        }
        FeatureManager featureManager = TAB.getInstance().getFeatureManager();
        if (!featureManager.isFeatureEnabled("GlobalPlayerList")) {
            return null;
        }
        GlobalPlayerList t = (GlobalPlayerList)featureManager.getFeature("GlobalPlayerList");
        if (t == null) {
            return null;
        }
        String globalGroup = t.getServerGroup(server);
        for (Object serverGroup : serverGroups) {
            if (!globalGroup.equals(serverGroup.toString())) continue;
            return globalGroup;
        }
        return null;
    }

    public ConfigurationFile getConfig() {
        return this.config;
    }

    public boolean isBukkitPermissions() {
        return this.bukkitPermissions;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public boolean isOnlineUuidInTabList() {
        return this.onlineUuidInTabList;
    }

    public boolean isPipelineInjection() {
        return this.pipelineInjection;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getPermissionRefreshInterval() {
        return this.permissionRefreshInterval;
    }

    public ConfigurationFile getAnimationFile() {
        return this.animationFile;
    }

    public MessageFile getMessages() {
        return this.messages;
    }

    public ConfigurationFile getPlayerdata() {
        return this.playerdata;
    }

    public PropertyConfiguration getGroups() {
        return this.groups;
    }

    public PropertyConfiguration getUsers() {
        return this.users;
    }

    public MySQL getMysql() {
        return this.mysql;
    }
}

