/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import me.neznamy.tab.api.placeholder.Placeholder;
import me.neznamy.tab.api.placeholder.PlaceholderManager;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.cpu.CpuManager;
import me.neznamy.tab.shared.event.impl.TabPlaceholderRegisterEvent;
import me.neznamy.tab.shared.features.types.JoinListener;
import me.neznamy.tab.shared.features.types.Loadable;
import me.neznamy.tab.shared.features.types.Refreshable;
import me.neznamy.tab.shared.features.types.TabFeature;
import me.neznamy.tab.shared.placeholders.PlaceholderRefreshTask;
import me.neznamy.tab.shared.placeholders.expansion.EmptyTabExpansion;
import me.neznamy.tab.shared.placeholders.expansion.TabExpansion;
import me.neznamy.tab.shared.placeholders.types.PlayerPlaceholderImpl;
import me.neznamy.tab.shared.placeholders.types.RelationalPlaceholderImpl;
import me.neznamy.tab.shared.placeholders.types.ServerPlaceholderImpl;
import me.neznamy.tab.shared.placeholders.types.TabPlaceholder;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceholderManagerImpl
extends TabFeature
implements PlaceholderManager,
JoinListener,
Loadable,
Refreshable {
    private final Pattern placeholderPattern = Pattern.compile("%([^%]*)%");
    private final boolean registerExpansion = this.config().getBoolean("placeholders.register-tab-expansion", true);
    private final Map<String, Integer> refreshIntervals = this.config().getConfigurationSection("placeholderapi-refresh-intervals");
    private final int defaultRefresh;
    private final Map<String, Placeholder> registeredPlaceholders = new HashMap<String, Placeholder>();
    private final Map<String, Set<Refreshable>> placeholderUsage = new ConcurrentHashMap<String, Set<Refreshable>>();
    private Placeholder[] usedPlaceholders = new Placeholder[0];
    private int loopTime;
    @NotNull
    private final TabExpansion tabExpansion = this.registerExpansion ? TAB.getInstance().getPlatform().createTabExpansion() : new EmptyTabExpansion();
    private final CpuManager cpu;

    public PlaceholderManagerImpl(@NotNull CpuManager cpu) {
        this.cpu = cpu;
        TAB.getInstance().getConfigHelper().startup().fixRefreshIntervals(this.refreshIntervals);
        this.defaultRefresh = this.refreshIntervals.getOrDefault("default-refresh-interval", 500);
    }

    private void refresh() {
        long time = System.nanoTime();
        this.loopTime += 50;
        ArrayList<Placeholder> placeholders = new ArrayList<Placeholder>();
        for (Placeholder placeholder : this.usedPlaceholders) {
            if (placeholder.getRefresh() == -1 || this.loopTime % placeholder.getRefresh() != 0) continue;
            placeholders.add(placeholder);
        }
        if (placeholders.isEmpty()) {
            return;
        }
        PlaceholderRefreshTask task = new PlaceholderRefreshTask(placeholders);
        this.cpu.addTime(this.getFeatureName(), "Phase #1 - Preparing for request", System.nanoTime() - time);
        this.cpu.getPlaceholderThread().submit(() -> {
            long time2 = System.nanoTime();
            task.run();
            this.cpu.addTime(this.getFeatureName(), "Phase #2 - Requesting new values", System.nanoTime() - time2);
            this.cpu.runTask(() -> this.processRefreshResults(task));
        });
    }

    private void processRefreshResults(@NotNull PlaceholderRefreshTask task) {
        long time = System.nanoTime();
        HashMap<TabPlayer, Set<Refreshable>> update = new HashMap<TabPlayer, Set<Refreshable>>(TAB.getInstance().getOnlinePlayers().length + 1, 1.0f);
        this.updateServerPlaceholders(task.getServerPlaceholderResults(), update);
        this.updatePlayerPlaceholders(task.getPlayerPlaceholderResults(), update);
        Map<TabPlayer, Set<Refreshable>> forceUpdate = this.updateRelationalPlaceholders(task.getRelationalPlaceholderResults());
        this.cpu.addTime(this.getFeatureName(), "Phase #3 - Saving results", System.nanoTime() - time);
        this.cpu.addPlaceholderTimes(task.getUsedTime());
        this.refreshFeatures(forceUpdate, update);
    }

    private void refreshFeatures(@NotNull Map<TabPlayer, Set<Refreshable>> forceUpdate, @NotNull Map<TabPlayer, Set<Refreshable>> update) {
        long startTime;
        for (Map.Entry<TabPlayer, Set<Refreshable>> entry : update.entrySet()) {
            for (Refreshable r : entry.getValue()) {
                startTime = System.nanoTime();
                r.refresh(entry.getKey(), false);
                this.cpu.addTime(r.getFeatureName(), r.getRefreshDisplayName(), System.nanoTime() - startTime);
            }
        }
        for (Map.Entry<TabPlayer, Set<Refreshable>> entry : forceUpdate.entrySet()) {
            for (Refreshable r : entry.getValue()) {
                startTime = System.nanoTime();
                r.refresh(entry.getKey(), true);
                this.cpu.addTime(r.getFeatureName(), r.getRefreshDisplayName(), System.nanoTime() - startTime);
            }
        }
    }

    @NotNull
    private Map<TabPlayer, Set<Refreshable>> updateRelationalPlaceholders(@Nullable Map<RelationalPlaceholderImpl, Map<TabPlayer, Map<TabPlayer, Object>>> results) {
        if (results == null) {
            return Collections.emptyMap();
        }
        HashMap<TabPlayer, Set<Refreshable>> update = new HashMap<TabPlayer, Set<Refreshable>>(TAB.getInstance().getOnlinePlayers().length + 1, 1.0f);
        for (Map.Entry<RelationalPlaceholderImpl, Map<TabPlayer, Map<TabPlayer, Object>>> entry : results.entrySet()) {
            RelationalPlaceholderImpl placeholder = entry.getKey();
            for (Map.Entry<TabPlayer, Map<TabPlayer, Object>> viewerResult : entry.getValue().entrySet()) {
                TabPlayer viewer = viewerResult.getKey();
                if (!viewer.isOnline()) continue;
                for (Map.Entry<TabPlayer, Object> targetResult : viewerResult.getValue().entrySet()) {
                    TabPlayer target = targetResult.getKey();
                    if (!target.isOnline() || !placeholder.hasValueChanged(viewer, target, targetResult.getValue())) continue;
                    placeholder.updateParents(target);
                    update.computeIfAbsent(target, x -> new HashSet()).addAll(this.getPlaceholderUsage(placeholder.getIdentifier()));
                }
            }
        }
        return update;
    }

    private void updatePlayerPlaceholders(@NotNull Map<PlayerPlaceholderImpl, Map<TabPlayer, Object>> results, @NotNull Map<TabPlayer, Set<Refreshable>> update) {
        if (results.isEmpty()) {
            return;
        }
        for (Map.Entry<PlayerPlaceholderImpl, Map<TabPlayer, Object>> entry : results.entrySet()) {
            PlayerPlaceholderImpl placeholder = entry.getKey();
            for (Map.Entry<TabPlayer, Object> playerResult : entry.getValue().entrySet()) {
                TabPlayer player = playerResult.getKey();
                if (!player.isOnline() || !placeholder.hasValueChanged(player, playerResult.getValue())) continue;
                placeholder.updateParents(player);
                update.computeIfAbsent(player, k -> new HashSet()).addAll(this.getPlaceholderUsage(placeholder.getIdentifier()));
                if (placeholder.getIdentifier().equals("%vanished%")) {
                    TAB.getInstance().getFeatureManager().onVanishStatusChange(player);
                }
                if (!placeholder.getIdentifier().equals("%gamemode%")) continue;
                TAB.getInstance().getFeatureManager().onGameModeChange(player);
            }
        }
    }

    private void updateServerPlaceholders(@NotNull Map<ServerPlaceholderImpl, Object> results, @NotNull Map<TabPlayer, Set<Refreshable>> update) {
        if (results.isEmpty()) {
            return;
        }
        for (Map.Entry<ServerPlaceholderImpl, Object> entry : results.entrySet()) {
            ServerPlaceholderImpl placeholder = entry.getKey();
            if (!placeholder.hasValueChanged(entry.getValue())) continue;
            for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
                placeholder.updateParents(all);
                update.computeIfAbsent(all, k -> new HashSet()).addAll(this.getPlaceholderUsage(placeholder.getIdentifier()));
            }
        }
    }

    public int getRefreshInterval(@NotNull String identifier) {
        return this.refreshIntervals.getOrDefault(identifier, this.defaultRefresh);
    }

    @NotNull
    public Collection<Placeholder> getAllPlaceholders() {
        return new ArrayList<Placeholder>(this.registeredPlaceholders.values());
    }

    public <T extends Placeholder> T registerPlaceholder(@NotNull T placeholder) {
        boolean override = this.registeredPlaceholders.containsKey(placeholder.getIdentifier());
        this.registeredPlaceholders.put(placeholder.getIdentifier(), placeholder);
        this.recalculateUsedPlaceholders();
        if (override && this.placeholderUsage.containsKey(placeholder.getIdentifier())) {
            for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
                if (!p.isLoaded()) continue;
                this.placeholderUsage.get(placeholder.getIdentifier()).forEach(f -> f.refresh(p, true));
            }
        }
        return placeholder;
    }

    @Override
    public void load() {
        this.cpu.startRepeatingTask(50, this::refresh);
        for (Placeholder pl : this.usedPlaceholders) {
            if (!(pl instanceof ServerPlaceholderImpl)) continue;
            ((ServerPlaceholderImpl)pl).update();
        }
        for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
            this.onJoin(p);
        }
    }

    @NotNull
    public List<String> detectPlaceholders(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (!text.contains("%")) {
            return Collections.emptyList();
        }
        if (text.charAt(0) == '%' && text.charAt(text.length() - 1) == '%') {
            char[] array;
            int count = 0;
            for (char c : array = text.toCharArray()) {
                if (c != '%') continue;
                ++count;
            }
            if (count == 2) {
                return Collections.singletonList(text);
            }
        }
        ArrayList<String> placeholders = new ArrayList<String>();
        Matcher m = this.placeholderPattern.matcher(text);
        while (m.find()) {
            placeholders.add(m.group());
        }
        return placeholders;
    }

    public void addUsedPlaceholder(@NonNull String identifier, @NonNull Refreshable feature) {
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        if (feature == null) {
            throw new NullPointerException("feature is marked non-null but is null");
        }
        if (this.placeholderUsage.computeIfAbsent(identifier, x -> new HashSet()).add(feature)) {
            this.recalculateUsedPlaceholders();
            TabPlaceholder p = this.getPlaceholder(identifier);
            for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
                this.tabExpansion.setPlaceholderValue(all, p.getIdentifier(), p.getLastValueSafe(all));
            }
        }
    }

    private void recalculateUsedPlaceholders() {
        this.usedPlaceholders = (Placeholder[])this.placeholderUsage.keySet().stream().map(this::getPlaceholder).distinct().toArray(Placeholder[]::new);
    }

    @NotNull
    public String findReplacement(@NonNull String placeholder, @NonNull String output) {
        if (placeholder == null) {
            throw new NullPointerException("placeholder is marked non-null but is null");
        }
        if (output == null) {
            throw new NullPointerException("output is marked non-null but is null");
        }
        return this.getPlaceholder(placeholder).getReplacements().findReplacement(output);
    }

    @NotNull
    public Set<Refreshable> getPlaceholderUsage(@NotNull String identifier) {
        Set usage = this.placeholderUsage.getOrDefault(identifier, new HashSet());
        for (String parent : this.getPlaceholder(identifier).getParents()) {
            usage.addAll(this.getPlaceholderUsage(parent));
        }
        return usage;
    }

    @Override
    public void onJoin(@NotNull TabPlayer connectedPlayer) {
        for (Placeholder p : this.usedPlaceholders) {
            if (!(p instanceof ServerPlaceholderImpl)) continue;
            this.tabExpansion.setPlaceholderValue(connectedPlayer, p.getIdentifier(), ((ServerPlaceholderImpl)p).getLastValue());
        }
        ((PlayerPlaceholderImpl)this.registeredPlaceholders.get("%vanished%")).update(connectedPlayer);
    }

    @Override
    public void refresh(@NotNull TabPlayer refreshed, boolean force) {
    }

    @Override
    @NotNull
    public String getRefreshDisplayName() {
        return "Other";
    }

    public boolean isPlaceholderRegistered(@NotNull String identifier) {
        return this.registeredPlaceholders.containsKey(identifier);
    }

    @Override
    @NotNull
    public String getFeatureName() {
        return "Refreshing placeholders";
    }

    @Override
    @NotNull
    public ServerPlaceholderImpl registerServerPlaceholder(@NonNull String identifier, int refresh, @NonNull Supplier<Object> supplier) {
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        this.ensureActive();
        return this.registerPlaceholder(new ServerPlaceholderImpl(identifier, refresh, supplier));
    }

    @Override
    @NotNull
    public PlayerPlaceholderImpl registerPlayerPlaceholder(@NonNull String identifier, int refresh, @NonNull Function<me.neznamy.tab.api.TabPlayer, Object> function) {
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        this.ensureActive();
        return this.registerPlaceholder(new PlayerPlaceholderImpl(identifier, refresh, function));
    }

    @Override
    @NotNull
    public RelationalPlaceholderImpl registerRelationalPlaceholder(@NonNull String identifier, int refresh, @NonNull BiFunction<me.neznamy.tab.api.TabPlayer, me.neznamy.tab.api.TabPlayer, Object> function) {
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        this.ensureActive();
        return this.registerPlaceholder(new RelationalPlaceholderImpl(identifier, refresh, function));
    }

    @Override
    @NotNull
    public TabPlaceholder getPlaceholder(@NonNull String identifier) {
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        this.ensureActive();
        TabPlaceholder p = (TabPlaceholder)this.registeredPlaceholders.get(identifier);
        if (p == null) {
            TabPlaceholderRegisterEvent event = new TabPlaceholderRegisterEvent(identifier);
            if (TAB.getInstance().getEventBus() != null) {
                TAB.getInstance().getEventBus().fire(event);
            }
            if (event.getServerPlaceholder() != null) {
                this.registerServerPlaceholder(identifier, this.getRefreshInterval(identifier), (Supplier)event.getServerPlaceholder());
            } else if (event.getPlayerPlaceholder() != null) {
                this.registerPlayerPlaceholder(identifier, this.getRefreshInterval(identifier), (Function)event.getPlayerPlaceholder());
            } else if (event.getRelationalPlaceholder() != null) {
                this.registerRelationalPlaceholder(identifier, this.getRefreshInterval(identifier), (BiFunction)event.getRelationalPlaceholder());
            } else {
                TAB.getInstance().getPlatform().registerUnknownPlaceholder(identifier);
            }
            this.addUsedPlaceholder(identifier, this);
            return this.getPlaceholder(identifier);
        }
        if (!this.placeholderUsage.containsKey(identifier)) {
            this.addUsedPlaceholder(identifier, this);
        }
        return p;
    }

    @Override
    public void unregisterPlaceholder(@NonNull Placeholder placeholder) {
        if (placeholder == null) {
            throw new NullPointerException("placeholder is marked non-null but is null");
        }
        this.ensureActive();
        this.unregisterPlaceholder(placeholder.getIdentifier());
    }

    @Override
    public void unregisterPlaceholder(@NonNull String identifier) {
        if (identifier == null) {
            throw new NullPointerException("identifier is marked non-null but is null");
        }
        this.ensureActive();
        this.registeredPlaceholders.remove(identifier);
        this.placeholderUsage.remove(identifier);
        this.recalculateUsedPlaceholders();
    }

    public int getLoopTime() {
        return this.loopTime;
    }

    @NotNull
    public TabExpansion getTabExpansion() {
        return this.tabExpansion;
    }
}

